/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.common.util;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.ui.popup.PopupFactoryImpl;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.swing.event.HyperlinkEvent;
import org.cxbox.intellij.community.common.util.JavaFacade;

public class BalloonUtil {
    private BalloonUtil() {
    }

    public static void showSuccessBalloon(Project project, String content, Map<String, Pair<PsiElement, BiConsumer<Project, PsiElement>>> elements) {
        Balloon balloon = new PopupFactoryImpl().createHtmlTextBalloonBuilder(content, MessageType.INFO, event -> {
            String href;
            Pair psiElementBiConsumerPair;
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (psiElementBiConsumerPair = (Pair)elements.get(href = event.getDescription())) != null) {
                ((BiConsumer)psiElementBiConsumerPair.getSecond()).accept(project, (PsiElement)psiElementBiConsumerPair.first);
            }
        }).setHideOnLinkClick(true).createBalloon();
        BalloonUtil.showBalloon(balloon, project);
    }

    private static void showBalloon(Balloon balloon, Project project) {
        JavaFacade.showPopup(balloon, project);
    }
}

