/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.wigdet.fields.field.type;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.codeInsight.daemon.MergeableLineMarkerInfo;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.lineMarker.LineMarkerActionWrapper;
import com.intellij.execution.lineMarker.RunLineMarkerContributor;
import com.intellij.icons.AllIcons;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.MarkupEditorFilter;
import com.intellij.openapi.editor.markup.MarkupEditorFilterFactory;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.ui.ColorUtil;
import com.intellij.util.Function;
import com.intellij.util.Icons;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBUI;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import org.cxbox.intellij.community.action.ShowDocumentationAction;
import org.cxbox.intellij.community.common.util.JsonFacade;
import org.cxbox.intellij.community.icons.PlatformIcons;
import org.cxbox.intellij.community.wigdet.fields.StandardFieldType;
import org.cxbox.intellij.community.wigdet.fields.field.WidgetFieldTypeDocumentationProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WidgetFieldTypeDocumentationLineMarker
extends LineMarkerProviderDescriptor {
    private static final Comparator<RunLineMarkerContributor.Info> COMPARATOR = (a, b) -> {
        if (b.shouldReplace(a)) {
            return 1;
        }
        if (a.shouldReplace(b)) {
            return -1;
        }
        return 0;
    };

    @NotNull
    public static LineMarkerInfo<PsiElement> createLineMarker(@NotNull PsiElement element, @NotNull Icon icon, @NotNull List<RunLineMarkerContributor.Info> infos) {
        if (element == null) {
            WidgetFieldTypeDocumentationLineMarker.$$$reportNull$$$0(0);
        }
        if (icon == null) {
            WidgetFieldTypeDocumentationLineMarker.$$$reportNull$$$0(1);
        }
        if (infos == null) {
            WidgetFieldTypeDocumentationLineMarker.$$$reportNull$$$0(2);
        }
        if (infos.size() > 1) {
            infos.sort(COMPARATOR);
            RunLineMarkerContributor.Info first = infos.get(0);
            infos.removeIf(info -> info != first && first.shouldReplace(info));
        }
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        for (RunLineMarkerContributor.Info info2 : infos) {
            for (AnAction action : info2.actions) {
                actionGroup.add((AnAction)(action instanceof Separator ? action : new LineMarkerActionWrapper(element, action)));
            }
            if (info2 == infos.get(infos.size() - 1)) continue;
            actionGroup.add((AnAction)new Separator());
        }
        Function tooltipProvider = element1 -> {
            StringBuilder tooltip = new StringBuilder();
            for (RunLineMarkerContributor.Info info : infos) {
                String string;
                if (info.tooltipProvider == null || (string = (String)info.tooltipProvider.apply(element1)) == null) continue;
                if (tooltip.length() != 0) {
                    tooltip.append("\n");
                }
                tooltip.append(string);
            }
            return tooltip.length() == 0 ? null : WidgetFieldTypeDocumentationLineMarker.appendShortcut(tooltip.toString());
        };
        return new RunLineMarkerInfo(element, icon, (Function<? super PsiElement, String>)tooltipProvider, actionGroup);
    }

    private static String appendShortcut(String tooltip) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return tooltip;
        }
        Executor executor = ExecutorRegistry.getInstance().getExecutorById("Run");
        if (executor != null) {
            String actionId = executor.getContextActionId();
            String shortcutText = KeymapUtil.getShortcutText((String)actionId);
            @NotNull String shortcutColor = ColorUtil.toHex((Color)JBUI.CurrentTheme.Tooltip.shortcutForeground());
            return XmlStringUtil.wrapInHtml((CharSequence)(XmlStringUtil.escapeString((String)tooltip).replaceAll("\n", "<br>") + "&nbsp;&nbsp;<font color='#" + shortcutColor + "'>" + XmlStringUtil.escapeString((String)shortcutText) + "</font>"));
        }
        return tooltip;
    }

    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement leaf) {
        PsiElement psiElement;
        if (leaf == null) {
            WidgetFieldTypeDocumentationLineMarker.$$$reportNull$$$0(3);
        }
        if (!(leaf instanceof LeafPsiElement) || !((psiElement = leaf.getParent()) instanceof JsonStringLiteral)) {
            return null;
        }
        JsonStringLiteral element = (JsonStringLiteral)psiElement;
        if (!WidgetFieldTypeDocumentationProvider.Holder.FIELDS_FIELD_TYPE_REF_PATTERN.accepts((Object)element)) {
            return null;
        }
        Icon icon = PlatformIcons.question;
        AnAction[] actions = new AnAction[1];
        JsonProperty parentOfType = JsonFacade.getParentOfType((PsiElement)element, JsonProperty.class, true);
        if (parentOfType == null) {
            return null;
        }
        String fieldType = JsonFacade.safeGetValueAsString((PsiElement)ObjectUtils.tryCast((Object)parentOfType.getValue(), JsonStringLiteral.class));
        if (fieldType == null) {
            return null;
        }
        String urlString = StandardFieldType.getByFieldType(fieldType).map(StandardFieldType::getDocumentationUrl).orElse(null);
        if (urlString == null) {
            return null;
        }
        String alternativeUrlString = StandardFieldType.getByFieldType(fieldType).map(StandardFieldType::getAlternativeDocumentationUrl).orElse(null);
        actions[0] = new ShowDocumentationAction(PlatformIcons.question, urlString, alternativeUrlString);
        ArrayList<RunLineMarkerContributor.Info> infos = new ArrayList<RunLineMarkerContributor.Info>();
        infos.add(new RunLineMarkerContributor.Info(Icons.ADD_ICON, actions, e -> "show documentation"));
        return WidgetFieldTypeDocumentationLineMarker.createLineMarker(leaf, icon, infos);
    }

    @NotNull
    public String getName() {
        String string = ExecutionBundle.message((String)"run.line.marker.name", (Object[])new Object[0]);
        if (string == null) {
            WidgetFieldTypeDocumentationLineMarker.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    public Icon getIcon() {
        return AllIcons.RunConfigurations.TestState.Run;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leaf";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/cxbox/intellij/community/wigdet/fields/field/type/WidgetFieldTypeDocumentationLineMarker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/cxbox/intellij/community/wigdet/fields/field/type/WidgetFieldTypeDocumentationLineMarker";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createLineMarker";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getLineMarkerInfo";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }

    static class RunLineMarkerInfo
    extends MergeableLineMarkerInfo<PsiElement> {
        private final DefaultActionGroup myActionGroup;
        private final AnAction mySingleAction;

        RunLineMarkerInfo(PsiElement element, Icon icon, Function<? super PsiElement, String> tooltipProvider, DefaultActionGroup actionGroup) {
            super(element, element.getTextRange(), icon, tooltipProvider, null, GutterIconRenderer.Alignment.LEFT, () -> (String)tooltipProvider.fun((Object)element));
            this.myActionGroup = actionGroup;
            this.mySingleAction = this.myActionGroup.getChildrenCount() == 1 ? this.myActionGroup.getChildActionsOrStubs()[0] : null;
        }

        public GutterIconRenderer createGutterRenderer() {
            return new LineMarkerInfo.LineMarkerGutterIconRenderer<PsiElement>((LineMarkerInfo)this){

                public AnAction getClickAction() {
                    return mySingleAction;
                }

                public boolean isNavigateAction() {
                    return true;
                }

                public ActionGroup getPopupMenuActions() {
                    return myActionGroup;
                }
            };
        }

        @NotNull
        public MarkupEditorFilter getEditorFilter() {
            MarkupEditorFilter markupEditorFilter = MarkupEditorFilterFactory.createIsNotDiffFilter();
            if (markupEditorFilter == null) {
                RunLineMarkerInfo.$$$reportNull$$$0(0);
            }
            return markupEditorFilter;
        }

        public boolean canMergeWith(@NotNull MergeableLineMarkerInfo<?> info) {
            if (info == null) {
                RunLineMarkerInfo.$$$reportNull$$$0(1);
            }
            return info instanceof RunLineMarkerInfo && info.getIcon() == this.getIcon();
        }

        public Icon getCommonIcon(@NotNull List<? extends MergeableLineMarkerInfo<?>> infos) {
            if (infos == null) {
                RunLineMarkerInfo.$$$reportNull$$$0(2);
            }
            return this.getIcon();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/cxbox/intellij/community/wigdet/fields/field/type/WidgetFieldTypeDocumentationLineMarker$RunLineMarkerInfo";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "infos";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEditorFilter";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/cxbox/intellij/community/wigdet/fields/field/type/WidgetFieldTypeDocumentationLineMarker$RunLineMarkerInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "canMergeWith";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getCommonIcon";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

