/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.wigdet.fields.field.commonProps.hidden;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonBooleanLiteral;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import java.util.List;
import org.apache.commons.lang3.tuple.Triple;
import org.cxbox.intellij.community.common.conf.JWidget;
import org.cxbox.intellij.community.common.util.QuickFixUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class FieldHiddenInspection
extends LocalInspectionTool {
    @NonNls
    @NotNull
    public String getShortName() {
        return "FieldHiddenInspection";
    }

    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            FieldHiddenInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            FieldHiddenInspection.$$$reportNull$$$0(1);
        }
        if (!(file instanceof JsonFile)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        JsonFile widgetFile = (JsonFile)file;
        if (!file.getName().endsWith(".widget.json")) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        List<Triple<String, JsonObject, JsonArray>> widgetFields = JWidget.getWidgetFields(widgetFile);
        SmartList descriptors = new SmartList();
        widgetFields.forEach(arg_0 -> FieldHiddenInspection.lambda$checkFile$0((List)descriptors, manager, arg_0));
        return descriptors.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    private static /* synthetic */ void lambda$checkFile$0(List descriptors, InspectionManager manager, Triple field) {
        JsonObject fieldJson = (JsonObject)field.getMiddle();
        JsonProperty fieldHiddenProperty = JWidget.getFieldHiddenProperty(fieldJson);
        if (!(fieldHiddenProperty == null || fieldHiddenProperty.getValue() != null && fieldHiddenProperty.getValue() instanceof JsonBooleanLiteral)) {
            boolean value = fieldHiddenProperty.getValue() != null ? !fieldHiddenProperty.getValue().getText().trim().toLowerCase().replaceAll("\"", "").equals("false") : true;
            descriptors.add(manager.createProblemDescriptor((PsiElement)fieldHiddenProperty, new TextRange(fieldHiddenProperty.getText().indexOf(58) + 1, fieldHiddenProperty.getText().length()), "Should be true/false without quotes", ProblemHighlightType.ERROR, true, new LocalQuickFix[]{new Fix(value)}));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
        }
        objectArray[1] = "org/cxbox/intellij/community/wigdet/fields/field/commonProps/hidden/FieldHiddenInspection";
        objectArray[2] = "checkFile";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private record Fix(Boolean value) implements LocalQuickFix
    {
        public boolean availableInBatchMode() {
            return false;
        }

        @IntentionName
        @NotNull
        public String getName() {
            return "Should be true/false without quotes";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor problemDescriptor) {
            if (project == null) {
                Fix.$$$reportNull$$$0(0);
            }
            if (problemDescriptor == null) {
                Fix.$$$reportNull$$$0(1);
            }
            QuickFixUtils.safeReplaceJsonBooleanLiteralValueWithText(project, problemDescriptor.getPsiElement().getLastChild(), this.value);
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            return "Should be true/false without quotes";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "problemDescriptor";
                    break;
                }
            }
            objectArray[1] = "org/cxbox/intellij/community/wigdet/fields/field/commonProps/hidden/FieldHiddenInspection$Fix";
            objectArray[2] = "applyFix";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

