/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.wigdet.bc.service.generator.common;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJvmMember;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.cxbox.intellij.community.common.util.EnumBcUtil;
import org.cxbox.intellij.community.common.util.JavaUtil;
import org.cxbox.intellij.community.exception.PlatformValidationException;
import org.cxbox.intellij.community.wigdet.bc.service.TemplateProperties;
import org.cxbox.intellij.community.wigdet.bc.service.generator.AbstractBcServicePsiElementGenerator;
import org.cxbox.intellij.community.wigdet.bc.service.generator.ElementGenerationContext;
import org.cxbox.intellij.community.wigdet.bc.service.utils.JavaNameUtils;

public class EnumBcPsiElementGeneratorBc
extends AbstractBcServicePsiElementGenerator {
    @Override
    public void setCustomProperties(ElementGenerationContext context) {
        context.properties().setProperty(TemplateProperties.FILE_TEMPLATE_NAME.name(), "PlatformRestController.java");
        context.properties().setProperty(TemplateProperties.PACKAGE_NAME.name(), JavaNameUtils.getPackageFromFQN(context.bcDialogCreationData().bcEnumHolder()));
        context.properties().setProperty(TemplateProperties.PLATFORM_CONTROLLER_NAME.name(), JavaNameUtils.getNameFromFQN(context.bcDialogCreationData().bcEnumHolder()));
        context.properties().setProperty(TemplateProperties.FILE_NAME.name(), context.properties().getProperty(TemplateProperties.PLATFORM_CONTROLLER_NAME.name()) + ".java");
    }

    @Override
    public PsiElement generateElement(ElementGenerationContext context) {
        PsiJavaFile javaFile;
        PsiImportList importList;
        PsiField anchor;
        boolean isDifferentEnumBcHolder;
        PsiElement generated;
        Project project = context.module().getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)context.module().getProject());
        PsiClass enumClass = JavaUtil.safetyFindClass(psiFacade, context.bcDialogCreationData().bcEnumHolder(), scope);
        if (enumClass == null && (generated = super.generateElement(context)) instanceof PsiClass) {
            PsiClass psiClass = (PsiClass)generated;
            List<PsiEnumConstant> enumBcs = EnumBcUtil.getPsiConstantFromEnumBcIdentifier(psiClass, context.module().getProject(), context.module());
            return enumBcs.stream().filter(ebc -> ebc.getName().equals(context.bcDialogCreationData().bcName())).findFirst().orElse(null);
        }
        PsiElementFactory factory = PsiElementFactory.getInstance((Project)context.module().getProject());
        boolean isChild = context.elementBcData().parentBcEnum() != null;
        StringBuilder enumText = new StringBuilder();
        PsiField[] fields = enumClass.getFields();
        ArrayList<PsiEnumConstant> constants = new ArrayList<PsiEnumConstant>();
        for (PsiField field : fields) {
            if (!(field instanceof PsiEnumConstant)) continue;
            constants.add((PsiEnumConstant)field);
        }
        PsiClass parentBcClass = Optional.of(context.elementBcData()).map(ElementGenerationContext.ElementBcData::parentBcEnum).map(PsiJvmMember::getContainingClass).orElse(null);
        boolean bl = isDifferentEnumBcHolder = !enumClass.isEquivalentTo((PsiElement)parentBcClass);
        if (constants.isEmpty()) {
            anchor = null;
        } else if (isChild && !isDifferentEnumBcHolder) {
            int i = constants.indexOf(context.elementBcData().parentBcEnum());
            anchor = fields[i];
        } else {
            anchor = fields[constants.size() - 1];
        }
        String className = enumClass.getContainingFile() instanceof PsiJavaFile ? context.elementBcData().serviceClz().getName() : context.elementBcData().serviceClz().getQualifiedName();
        if (anchor != null) {
            if (isChild) {
                enumText.append(",").append(anchor.getPrevSibling().getText()).append("\t");
            } else {
                enumText.append(",\n\t");
            }
        }
        enumText.append(context.elementBcData().bcEnumName()).append("(");
        if (isChild) {
            enumText.append(context.elementBcData().parentBcEnum().getName()).append(", ");
        }
        enumText.append(className).append(".class").append(")");
        PsiDocumentManager docMgr = PsiDocumentManager.getInstance((Project)context.module().getProject());
        Document doc = docMgr.getDocument(enumClass.getContainingFile());
        if (doc != null && anchor != null) {
            doc.replaceString(anchor.getTextRange().getEndOffset(), anchor.getTextRange().getEndOffset(), (CharSequence)enumText);
            docMgr.doPostponedOperationsAndUnblockDocument(doc);
            docMgr.commitDocument(doc);
        } else {
            enumClass.add((PsiElement)factory.createEnumConstantFromText(enumText.toString(), (PsiElement)enumClass));
        }
        PsiFile psiFile = enumClass.getContainingFile();
        if (psiFile instanceof PsiJavaFile && (importList = (javaFile = (PsiJavaFile)psiFile).getImportList()) != null) {
            boolean isAlreadyImportedBcParent;
            boolean alreadyImported = false;
            String serviceFullQualifiedName = context.elementBcData().serviceClz().getQualifiedName();
            if (serviceFullQualifiedName != null) {
                alreadyImported = Arrays.stream(importList.getAllImportStatements()).anyMatch(psi -> serviceFullQualifiedName.equals(Optional.of(psi).map(PsiImportStatementBase::getImportReference).map(PsiJavaCodeReferenceElement::getQualifiedName).orElse(null)));
            }
            if (!alreadyImported) {
                PsiImportStatement importStatement = factory.createImportStatement(context.elementBcData().serviceClz());
                importList.add((PsiElement)importStatement);
            }
            if (isDifferentEnumBcHolder && parentBcClass != null && parentBcClass.getQualifiedName() != null && !(isAlreadyImportedBcParent = Arrays.stream(importList.getImportStaticStatements()).anyMatch(si -> {
                PsiJavaCodeReferenceElement sir = si.getImportReference();
                if (sir == null) {
                    return false;
                }
                String qcn = sir.getQualifiedName();
                String rn = sir.getReferenceName();
                if (parentBcClass.getQualifiedName().equals(qcn) && "*".equals(rn)) {
                    return true;
                }
                return parentBcClass.getQualifiedName().equals(qcn) && context.elementBcData().parentBcEnum().getName().equals(rn);
            }))) {
                PsiImportStaticStatement psiStaticImport = factory.createImportStaticStatement(parentBcClass, context.elementBcData().parentBcEnum().getName());
                importList.add((PsiElement)psiStaticImport);
            }
        }
        return EnumBcUtil.getEnumBc(context.elementBcData().bcEnumName(), context.module().getProject(), context.module()).orElse(null);
    }

    @Override
    public PsiElement getterElement(ElementGenerationContext context) {
        return context.elementBcData().bcEnum();
    }

    @Override
    public void setterElement(ElementGenerationContext context, PsiElement element) {
        if (!(element instanceof PsiEnumConstant)) {
            throw new PlatformValidationException("Generate not available", null, new IllegalStateException("Incorrect element type, expected enum constant, actual: " + String.valueOf(element)), context.module().getProject(), MessageType.INFO, AllIcons.General.Warning);
        }
        PsiEnumConstant psiEnumConstant = (PsiEnumConstant)element;
        context.elementBcData().setBcEnum(psiEnumConstant);
    }
}

