/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.wigdet.bc.service.generator.anysource;

import com.intellij.openapi.module.Module;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import org.cxbox.intellij.community.wigdet.bc.common.ResponseServiceType;
import org.cxbox.intellij.community.wigdet.bc.service.BcServiceGeneratorHolder;
import org.cxbox.intellij.community.wigdet.bc.service.generator.BcDialogCreationData;
import org.cxbox.intellij.community.wigdet.bc.service.generator.BcServiceGenerator;
import org.cxbox.intellij.community.wigdet.bc.service.generator.ElementGenerationContext;
import org.cxbox.intellij.community.wigdet.bc.service.generator.GenerationType;
import org.cxbox.intellij.community.wigdet.bc.service.generator.ServicePsiElementGenerator;
import org.cxbox.intellij.community.wigdet.bc.service.generator.anysource.AnySourceBcServiceGenerator;
import org.cxbox.intellij.community.wigdet.bc.service.generator.anysource.AnySourceDAOGeneratorBc;
import org.cxbox.intellij.community.wigdet.bc.service.generator.anysource.AnySourceDTOGeneratorBc;
import org.cxbox.intellij.community.wigdet.bc.service.generator.anysource.AnySourceMetaGeneratorBc;
import org.cxbox.intellij.community.wigdet.bc.service.generator.common.EnumBcPsiElementGeneratorBc;

public class AnySourceElementsGenerator
extends BcServiceGenerator {
    @Override
    public boolean isApplicable(Module module, BcDialogCreationData data) {
        return ResponseServiceType.ANY_SOURCE_VERSION_AWARE_RESPONSE_SERVICE.equals(data.serviceType());
    }

    @Override
    public List<GenerationType<ElementGenerationContext>> elementsToGenerate() {
        return Arrays.stream(AnySourceGenerationType.values()).map(type -> type).toList();
    }

    public static enum AnySourceGenerationType implements GenerationType<ElementGenerationContext>
    {
        ANY_SOURCE_SERVICE_TYPE_DTO(BcServiceGeneratorHolder.ElementType.DTO, AnySourceDTOGeneratorBc::new),
        ANY_SOURCE_SERVICE_TYPE_DAO(BcServiceGeneratorHolder.ElementType.DAO, AnySourceDAOGeneratorBc::new),
        ANY_SOURCE_SERVICE_TYPE_META(BcServiceGeneratorHolder.ElementType.META, AnySourceMetaGeneratorBc::new),
        ANY_SOURCE_SERVICE_TYPE_SERVICE(BcServiceGeneratorHolder.ElementType.SERVICE, AnySourceBcServiceGenerator::new),
        BC(BcServiceGeneratorHolder.ElementType.ENUM_BC, EnumBcPsiElementGeneratorBc::new);

        private final BcServiceGeneratorHolder.ElementType type;
        private final Supplier<ServicePsiElementGenerator<ElementGenerationContext>> factorySupplier;

        private AnySourceGenerationType(BcServiceGeneratorHolder.ElementType type, Supplier<ServicePsiElementGenerator<ElementGenerationContext>> factorySupplier) {
            this.type = type;
            this.factorySupplier = factorySupplier;
        }

        @Override
        public BcServiceGeneratorHolder.ElementType type() {
            return this.type;
        }

        @Override
        public ServicePsiElementGenerator<ElementGenerationContext> factory() {
            return this.factorySupplier.get();
        }
    }
}

