/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.wigdet.bc.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.cxbox.intellij.community.common.util.JavaUtil;
import org.cxbox.intellij.community.common.util.ResponseServiceUtils;
import org.cxbox.intellij.community.wigdet.bc.BCInspection;
import org.cxbox.intellij.community.wigdet.bc.common.ResponseServiceType;
import org.cxbox.intellij.community.wigdet.bc.common.UiNamedComponent;
import org.cxbox.intellij.community.wigdet.bc.service.ElementPostfix;
import org.cxbox.intellij.community.wigdet.bc.service.generator.BcDialogCreationData;
import org.cxbox.intellij.community.wigdet.bc.service.utils.JavaNameUtils;
import org.cxbox.intellij.community.wigdet.bc.ui.RelationshipEntityType;
import org.cxbox.intellij.community.wigdet.bc.ui.component.EnumComboBox;
import org.cxbox.intellij.community.wigdet.bc.ui.component.PanelComponent;
import org.cxbox.intellij.community.wigdet.bc.ui.component.PanelWithTextAndInputAndSuggestion;
import org.cxbox.intellij.community.wigdet.bc.ui.component.PanelWithTextAndInputAndSuggestionElement;
import org.cxbox.intellij.community.wigdet.bc.ui.component.PsiEnumConstantComboBox;
import org.cxbox.intellij.community.wigdet.bc.ui.component.SuggestionPanel;
import org.jetbrains.annotations.NotNull;

public class BcCreationDialogWrapper
extends DialogWrapper {
    private final Project project;
    private final Module module;
    private final String name;
    private final Map<UiNamedComponent, JComponent> panel = new ConcurrentHashMap<UiNamedComponent, JComponent>();
    private final Map<UiNamedComponent, PanelComponent> fields = new ConcurrentHashMap<UiNamedComponent, PanelComponent>();

    private static Function<JComponent, String> getStrigValueInputFields() {
        return e -> {
            if (e instanceof ComboBox) {
                ComboBox cb = (ComboBox)e;
                Object data = Optional.of(cb).map(JComboBox::getEditor).map(ComboBoxEditor::getItem).orElse(null);
                if (data instanceof PsiClass) {
                    PsiClass clzz = data;
                    return clzz.getQualifiedName();
                }
                return String.valueOf(data);
            }
            return null;
        };
    }

    public BcCreationDialogWrapper(Project project, Module module, String name, BCInspection.FixWithCreationBc.BcCreationMetaData data) {
        super(project, true);
        this.project = project;
        this.module = module;
        this.name = name;
        this.setTitle("Create bc: " + name);
        this.panel.put(Panel.MAIN, (JComponent)new JBPanel());
        this.panel.put(Panel.BC_CREATION, (JComponent)new JBPanel());
        this.panel.put(Panel.BC_PARENT, (JComponent)new JBPanel());
        this.createAndAddToPanelFields(data);
        this.addFieldsListeners();
        this.panel.get(Panel.MAIN).add(this.fields.get(Fields.TYPE_SERVICE));
        this.panel.get(Panel.MAIN).add(this.fields.get(Fields.ENUM_BC_HOLDER));
        this.panel.get(Panel.MAIN).add(this.panel.get(Panel.BC_CREATION));
        this.panel.get(Panel.MAIN).add(Box.createVerticalStrut(5));
        this.panel.get(Panel.MAIN).add(new JSeparator(0));
        this.panel.get(Panel.MAIN).add(Box.createVerticalStrut(5));
        this.panel.get(Panel.MAIN).add(this.panel.get(Panel.BC_PARENT));
        this.init();
        this.initValidation();
    }

    protected JComponent createCenterPanel() {
        this.panel.get(Panel.MAIN).setLayout(new BoxLayout(this.panel.get(Panel.MAIN), 1));
        this.panel.get(Panel.BC_CREATION).setLayout(new BoxLayout(this.panel.get(Panel.BC_CREATION), 1));
        this.panel.get(Panel.BC_PARENT).setLayout(new BoxLayout(this.panel.get(Panel.BC_PARENT), 1));
        this.drawPanel(Panel.BC_CREATION, (ResponseServiceType)this.fields.get(Fields.TYPE_SERVICE).getTypedInputElement(EnumComboBox.class).getSelectedItem());
        this.drawPanel(Panel.BC_PARENT, (ResponseServiceType)this.fields.get(Fields.TYPE_SERVICE).getTypedInputElement(EnumComboBox.class).getSelectedItem());
        return this.panel.get(Panel.MAIN);
    }

    public void createAndAddToPanelFields(BCInspection.FixWithCreationBc.BcCreationMetaData data) {
        String nameCapitalized = JavaUtil.capitalizeFirstLetter(this.name);
        for (Fields field : Fields.values()) {
            PanelComponent component = null;
            if (field.getComponent().equals(PanelWithTextAndInputAndSuggestion.class)) {
                component = new PanelWithTextAndInputAndSuggestion((JComponent)field.nameSupplier().get(), field.providerSupplier().apply(data, nameCapitalized), field.labelSupplier().apply(data, nameCapitalized));
            } else {
                component = new PanelWithTextAndInputAndSuggestionElement((JComponent)field.nameSupplier().get(), field.providerSupplier().apply(data, nameCapitalized), field.labelSupplier().apply(data, nameCapitalized));
                JComponent jComponent = component.getLabelHelper();
                if (jComponent instanceof SuggestionPanel) {
                    SuggestionPanel panel = (SuggestionPanel)jComponent;
                    PanelComponent finalComponent = component;
                    panel.setUpdateRelatedComponent(fqn -> {
                        Object input = finalComponent.getTypedInputElement();
                        if (input instanceof ComboBox) {
                            ComboBox cb = (ComboBox)input;
                            String selectedItem = cb.getSelectedItem().toString();
                            String nameFromFQN = JavaNameUtils.getNameFromFQN(selectedItem);
                            cb.setSelectedItem((Object)(fqn + "." + nameFromFQN));
                        }
                    });
                    Object input = finalComponent.getTypedInputElement();
                    if (input instanceof ComboBox) {
                        ComboBox cb = (ComboBox)input;
                        panel.updateText(JavaNameUtils.getPackageFromFQN(Optional.ofNullable(cb.getSelectedItem()).map(String::valueOf).orElse(null)));
                        ApplicationManager.getApplication().executeOnPooledThread(() -> {
                            PsiClass psiClass = BcCreationDialogWrapper.checkInReadAction(this.project, this.module, cb.getSelectedItem().toString());
                            panel.enableButton(psiClass == null);
                        });
                    }
                }
            }
            component.setVisible(field.isVisible);
            this.fields.put(field, component);
        }
    }

    private void addFieldsListeners() {
        ((JTextComponent)this.fields.get(Fields.ENUM_BC_HOLDER).getTypedInputElement(ComboBox.class).getEditor().getEditorComponent()).getDocument().addDocumentListener(BcCreationDialogWrapper.createDocumentListener(List.of(e -> this.enumBcHolderFieldChange()), this.module));
        ((JTextComponent)this.fields.get(Fields.TYPE_SERVICE).getTypedInputElement(ComboBox.class).getEditor().getEditorComponent()).getDocument().addDocumentListener(BcCreationDialogWrapper.createDocumentListener(List.of(e -> this.typeServiceFieldChange(), e -> this.parentBcFieldChange(), e -> this.serviceVersionAwareFieldChange(), e -> this.serviceAnySourceFieldChange(), e -> this.dtoVersionAwareFieldChange(), e -> this.dtoAnySourceFieldChange()), this.module));
        ((JTextComponent)this.fields.get(Fields.SERVICE_VERSION_AWARE).getTypedInputElement(ComboBox.class).getEditor().getEditorComponent()).getDocument().addDocumentListener(BcCreationDialogWrapper.createDocumentListener(List.of(e -> this.serviceVersionAwareFieldChange(), e -> this.dtoVersionAwareFieldChange()), this.module));
        ((JTextComponent)this.fields.get(Fields.DTO_VERSION_AWARE).getTypedInputElement(ComboBox.class).getEditor().getEditorComponent()).getDocument().addDocumentListener(BcCreationDialogWrapper.createDocumentListener(List.of(e -> this.dtoVersionAwareFieldChange(), e -> this.versionAwareFieldChange()), this.module));
        ((JTextComponent)this.fields.get(Fields.ENTITY_VERSION_AWARE).getTypedInputElement(ComboBox.class).getEditor().getEditorComponent()).getDocument().addDocumentListener(BcCreationDialogWrapper.createDocumentListener(List.of(e -> this.versionAwareFieldChange()), this.module));
        ((JTextComponent)this.fields.get(Fields.SERVICE_ANY_SOURCE).getTypedInputElement(ComboBox.class).getEditor().getEditorComponent()).getDocument().addDocumentListener(BcCreationDialogWrapper.createDocumentListener(List.of(e -> this.serviceAnySourceFieldChange(), e -> this.dtoAnySourceFieldChange()), this.module));
        ((JTextComponent)this.fields.get(Fields.DTO_ANY_SOURCE).getTypedInputElement(ComboBox.class).getEditor().getEditorComponent()).getDocument().addDocumentListener(BcCreationDialogWrapper.createDocumentListener(List.of(e -> this.dtoAnySourceFieldChange()), this.module));
        ((JTextComponent)this.fields.get(Fields.PARENT_BC).getTypedInputElement(ComboBox.class).getEditor().getEditorComponent()).getDocument().addDocumentListener(BcCreationDialogWrapper.createDocumentListener(List.of(e -> this.parentBcFieldChange()), this.module));
    }

    private static DocumentListener createDocumentListener(final Collection<Consumer<DocumentEvent>> handlers, final Module module) {
        return new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                1.registerListener(handlers, module, e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                1.registerListener(handlers, module, e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                1.registerListener(handlers, module, e);
            }

            private static void registerListener(Collection<Consumer<DocumentEvent>> handlers2, Module module2, DocumentEvent e) {
                ApplicationManager.getApplication().invokeLater(() -> ReadAction.nonBlocking(() -> {
                    handlers2.forEach(h -> h.accept(e));
                    return null;
                }).inSmartMode(module2.getProject()).withDocumentsCommitted(module2.getProject()).submit((Executor)AppExecutorUtil.getAppExecutorService()));
            }
        };
    }

    private void enumBcHolderFieldChange() {
        ComboBox enumBcHolderField = this.fields.get(Fields.ENUM_BC_HOLDER).getTypedInputElement(ComboBox.class);
        SuggestionPanel enumChoosePanel = (SuggestionPanel)this.fields.get(Fields.ENUM_BC_HOLDER).getLabelHelper();
        String value = Fields.ENUM_BC_HOLDER.getValueExtractor().apply((JComponent)enumBcHolderField);
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            PsiClass psiClass = BcCreationDialogWrapper.checkInReadAction(this.project, this.module, value);
            enumChoosePanel.enableButton(psiClass == null);
            this.updatePanelChosenText(enumChoosePanel, value);
        });
    }

    private void dtoAnySourceFieldChange() {
        PsiClass dataPsi;
        ComboBox dto = (ComboBox)this.fields.get(Fields.DTO_ANY_SOURCE).getTypedInputElement();
        ComboBox entityField = (ComboBox)this.fields.get(Fields.ENTITY_ANY_SOURCE).getTypedInputElement();
        SuggestionPanel dtoChoosePanel = (SuggestionPanel)this.fields.get(Fields.DTO_ANY_SOURCE).getLabelHelper();
        SuggestionPanel entityChoosePanel = (SuggestionPanel)this.fields.get(Fields.ENTITY_ANY_SOURCE).getLabelHelper();
        Object data = dto.getSelectedItem();
        String input = Optional.of(dto).map(JComboBox::getEditor).map(ComboBoxEditor::getItem).map(String::valueOf).orElse(null);
        this.updatePanelChosenText(dtoChoosePanel, dto);
        this.updatePanelChosenText(entityChoosePanel, dto);
        entityChoosePanel.enableButton(false);
        if (data instanceof PsiClass && (dataPsi = (PsiClass)data).getName() != null && String.valueOf(dataPsi).equals(input)) {
            entityField.setSelectedItem(data);
            dtoChoosePanel.enableButton(false);
        } else {
            entityField.setSelectedItem((Object)input);
            dtoChoosePanel.enableButton(true);
        }
    }

    private void serviceAnySourceFieldChange() {
        PsiClass selectedItemPsiClass;
        ComboBox serviceName = (ComboBox)this.fields.get(Fields.SERVICE_ANY_SOURCE).getTypedInputElement();
        ComboBox entityField = (ComboBox)this.fields.get(Fields.ENTITY_ANY_SOURCE).getTypedInputElement();
        ComboBox dtoField = (ComboBox)this.fields.get(Fields.DTO_ANY_SOURCE).getTypedInputElement();
        SuggestionPanel serviceChoosePanel = (SuggestionPanel)this.fields.get(Fields.SERVICE_ANY_SOURCE).getLabelHelper();
        SuggestionPanel entityChoosePanel = (SuggestionPanel)this.fields.get(Fields.ENTITY_ANY_SOURCE).getLabelHelper();
        SuggestionPanel dtoChoosePanel = (SuggestionPanel)this.fields.get(Fields.DTO_ANY_SOURCE).getLabelHelper();
        Object selectedItem = serviceName.getSelectedItem();
        String input = Optional.of(serviceName).map(JComboBox::getEditor).map(ComboBoxEditor::getItem).map(String::valueOf).orElse(null);
        ResponseServiceUtils.ResponseServiceData responseServiceData = selectedItem instanceof PsiClass && (selectedItemPsiClass = (PsiClass)selectedItem).getName() != null && String.valueOf(selectedItem).equals(input) ? ResponseServiceUtils.getResponseServiceData(selectedItemPsiClass, this.module) : ResponseServiceUtils.getResponseServiceDataByClassName(this.project, this.module, String.valueOf(input), cn -> String.valueOf(input).equals(cn.responseServicePsiClass().getQualifiedName()));
        entityChoosePanel.setEnabled(false);
        if (responseServiceData != null) {
            entityField.setSelectedItem((Object)responseServiceData.responseServiceEntityPsiClass());
            dtoField.setSelectedItem((Object)responseServiceData.responseServiceDtoPsiClass());
            dtoField.setEnabled(false);
            serviceChoosePanel.enableButton(false);
            dtoChoosePanel.enableButton(false);
        } else {
            dtoField.setEnabled(true);
            serviceChoosePanel.enableButton(true);
            dtoChoosePanel.enableButton(true);
        }
        this.updatePanelChosenText(serviceChoosePanel, Optional.of(serviceName).map(JComboBox::getEditor).map(ComboBoxEditor::getItem).orElse(null));
        this.updatePanelChosenText(dtoChoosePanel, Optional.of(dtoField).map(JComboBox::getEditor).map(ComboBoxEditor::getItem).orElse(null));
    }

    private void parentBcFieldChange() {
        PsiEnumConstant psiEnumConstant = (PsiEnumConstant)this.fields.get(Fields.PARENT_BC).getTypedInputElement(ComboBox.class).getSelectedItem();
        this.fields.get(Fields.TYPE_RELATIONSHIP).setVisible(false);
        boolean isVersionAwareService = false;
        Optional<PsiClass> parentServiceClass = Optional.ofNullable(ResponseServiceUtils.getResponseServiceDataByBc(this.project, this.module, psiEnumConstant)).map(ResponseServiceUtils.ResponseServiceData::responseServicePsiClass);
        if (parentServiceClass.isPresent()) {
            isVersionAwareService = ResponseServiceUtils.isVersionAwareResponseService(parentServiceClass.get(), this.project, this.module);
        }
        if (psiEnumConstant != null && isVersionAwareService) {
            this.fields.get(Fields.TYPE_RELATIONSHIP).setVisible(true);
        }
    }

    private void typeServiceFieldChange() {
        Object selectedItem = this.fields.get(Fields.TYPE_SERVICE).getTypedInputElement(ComboBox.class).getSelectedItem();
        if (selectedItem instanceof ResponseServiceType) {
            ResponseServiceType responseServiceType = (ResponseServiceType)selectedItem;
            this.drawPanel(Panel.BC_CREATION, responseServiceType);
            if (responseServiceType.equals(ResponseServiceType.ANY_SOURCE_VERSION_AWARE_RESPONSE_SERVICE)) {
                ((JComponent)this.fields.get(Fields.ENTITY_ANY_SOURCE).getTypedInputElement()).setEnabled(false);
                this.fields.get(Fields.ENTITY_ANY_SOURCE).getTypedInputElement(ComboBox.class).setSelectedItem(this.fields.get(Fields.DTO_VERSION_AWARE).getTypedInputElement(ComboBox.class).getSelectedItem());
            }
            this.drawPanel(Panel.BC_PARENT, responseServiceType);
        }
    }

    private void serviceVersionAwareFieldChange() {
        PsiClass selectedItemPsiClass;
        ComboBox serviceName = (ComboBox)this.fields.get(Fields.SERVICE_VERSION_AWARE).getTypedInputElement();
        ComboBox entityField = (ComboBox)this.fields.get(Fields.ENTITY_VERSION_AWARE).getTypedInputElement();
        ComboBox dtoField = (ComboBox)this.fields.get(Fields.DTO_VERSION_AWARE).getTypedInputElement();
        SuggestionPanel dtoChoosePanel = (SuggestionPanel)this.fields.get(Fields.DTO_VERSION_AWARE).getLabelHelper();
        SuggestionPanel entityChoosePanel = (SuggestionPanel)this.fields.get(Fields.ENTITY_VERSION_AWARE).getLabelHelper();
        SuggestionPanel serviceChoosePanel = (SuggestionPanel)this.fields.get(Fields.SERVICE_VERSION_AWARE).getLabelHelper();
        dtoField.setEnabled(false);
        entityField.setEnabled(false);
        Object selectedItem = serviceName.getSelectedItem();
        String input = Optional.of(serviceName).map(JComboBox::getEditor).map(ComboBoxEditor::getItem).map(String::valueOf).orElse(null);
        ResponseServiceUtils.ResponseServiceData responseServiceData = selectedItem instanceof PsiClass && (selectedItemPsiClass = (PsiClass)selectedItem).getName() != null && String.valueOf(selectedItemPsiClass).equals(input) ? ResponseServiceUtils.getResponseServiceData(selectedItemPsiClass, this.module) : ResponseServiceUtils.getResponseServiceDataByClassName(this.project, this.module, String.valueOf(input), cn -> String.valueOf(input).equals(cn.responseServicePsiClass().getQualifiedName()));
        if (responseServiceData != null) {
            entityField.setSelectedItem((Object)responseServiceData.responseServiceEntityPsiClass());
            dtoField.setSelectedItem((Object)responseServiceData.responseServiceDtoPsiClass());
            dtoField.setEnabled(false);
            entityField.setEnabled(false);
            entityChoosePanel.enableButton(false);
            serviceChoosePanel.enableButton(false);
            dtoChoosePanel.enableButton(false);
        } else {
            dtoField.setEnabled(true);
            entityField.setEnabled(true);
            serviceChoosePanel.enableButton(true);
            entityChoosePanel.enableButton(true);
            dtoChoosePanel.enableButton(true);
        }
        this.updatePanelChosenText(serviceChoosePanel, Optional.of(serviceName).map(JComboBox::getEditor).map(ComboBoxEditor::getItem).orElse(null));
        this.updatePanelChosenText(dtoChoosePanel, Optional.of(dtoField).map(JComboBox::getEditor).map(ComboBoxEditor::getItem).orElse(null));
        this.updatePanelChosenText(entityChoosePanel, Optional.of(dtoField).map(JComboBox::getEditor).map(ComboBoxEditor::getItem).orElse(null));
    }

    private void versionAwareFieldChange() {
        Object entityFields = this.fields.get(Fields.ENTITY_VERSION_AWARE).getTypedInputElement();
        SuggestionPanel entityChoosePanel = (SuggestionPanel)this.fields.get(Fields.ENTITY_VERSION_AWARE).getLabelHelper();
        String value = Fields.ENTITY_VERSION_AWARE.getValueExtractor().apply((JComponent)entityFields);
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            PsiClass psiClass = BcCreationDialogWrapper.checkInReadAction(this.project, this.module, value);
            entityChoosePanel.enableButton(psiClass == null);
            this.updatePanelChosenText(entityChoosePanel, value);
        });
    }

    private void updatePanelChosenText(SuggestionPanel panel, Object data) {
        if (data == null) {
            return;
        }
        if (data instanceof PsiClass) {
            PsiClass psiClass = (PsiClass)data;
            panel.updateText(JavaNameUtils.getPackageFromFQN(psiClass.getQualifiedName()));
        }
        if (data instanceof String) {
            String fqn = (String)data;
            panel.updateText(JavaNameUtils.getPackageFromFQN(fqn));
        }
    }

    private void dtoVersionAwareFieldChange() {
        PsiClass dtoPsi;
        ComboBox dto = (ComboBox)this.fields.get(Fields.DTO_VERSION_AWARE).getTypedInputElement();
        ComboBox entityField = (ComboBox)this.fields.get(Fields.ENTITY_VERSION_AWARE).getTypedInputElement();
        SuggestionPanel dtoChoosePanel = (SuggestionPanel)this.fields.get(Fields.DTO_VERSION_AWARE).getLabelHelper();
        SuggestionPanel entityChoosePanel = (SuggestionPanel)this.fields.get(Fields.ENTITY_VERSION_AWARE).getLabelHelper();
        entityField.setEnabled(false);
        Object selectedItem = dto.getSelectedItem();
        String input = Optional.of(dto).map(JComboBox::getEditor).map(ComboBoxEditor::getItem).map(String::valueOf).orElse(null);
        PsiClass dtoPsiClass = selectedItem instanceof PsiClass && (dtoPsi = (PsiClass)selectedItem).getName() != null && String.valueOf(dtoPsi).equals(input) ? dtoPsi : ResponseServiceUtils.getDtoByName(this.project, this.module, String.valueOf(selectedItem));
        String entityName = null;
        if (dtoPsiClass != null) {
            entityName = ResponseServiceUtils.getEntityByDto(dtoPsiClass, this.module).map(PsiClass::getQualifiedName).orElse(null);
        }
        entityField.setEnabled(true);
        dtoChoosePanel.enableButton(true);
        entityChoosePanel.enableButton(true);
        this.updatePanelChosenText(dtoChoosePanel, Optional.of(dto).map(JComboBox::getEditor).map(ComboBoxEditor::getItem).orElse(null));
        if (entityName != null) {
            this.updatePanelChosenText(entityChoosePanel, Optional.of(entityField).map(JComboBox::getEditor).map(ComboBoxEditor::getItem).orElse(null));
        }
        if (dtoPsiClass != null) {
            if (entityName != null) {
                entityField.setEnabled(false);
                entityField.setSelectedItem((Object)entityName);
                entityField.setBackground(UIManager.getColor("Panel.background"));
            }
            entityChoosePanel.enableButton(false);
            dtoChoosePanel.enableButton(false);
        }
    }

    private void drawPanel(Panel panel, ResponseServiceType responseServiceType) {
        JPanel jbPanel = (JPanel)this.panel.get(panel);
        jbPanel.removeAll();
        Arrays.stream(Fields.values()).filter(f -> f.getPanel().equals(panel)).filter(f -> f.getApplicableType().contains(responseServiceType)).sorted(Comparator.comparingInt(Fields::getOrder)).forEach(f -> {
            jbPanel.add(this.fields.get(f));
            jbPanel.add(Box.createVerticalStrut(6));
        });
        jbPanel.repaint();
        jbPanel.revalidate();
    }

    public BcDialogCreationData getValues() {
        return (BcDialogCreationData)ApplicationManager.getApplication().runReadAction(() -> {
            ResponseServiceType selectedItem = (ResponseServiceType)this.fields.get(Fields.TYPE_SERVICE).getTypedInputElement(EnumComboBox.class).getSelectedItem();
            BcDialogCreationData.Builder builder = new BcDialogCreationData.Builder().bcName(this.name).serviceType(selectedItem).parentBcName((PsiEnumConstant)this.fields.get(Fields.PARENT_BC).getTypedInputElement(ComboBox.class).getSelectedItem()).isNewService(true);
            if (ResponseServiceType.VERSION_AWARE_RESPONSE_SERVICE.equals(selectedItem)) {
                this.filVersionAwareData(builder);
            }
            if (ResponseServiceType.ANY_SOURCE_VERSION_AWARE_RESPONSE_SERVICE.equals(selectedItem)) {
                this.fillAnySourceData(builder);
            }
            return this.fillEnumBcHolder(builder).build();
        });
    }

    private BcDialogCreationData.Builder fillEnumBcHolder(BcDialogCreationData.Builder builder) {
        Object object = this.fields.get(Fields.ENUM_BC_HOLDER).getTypedInputElement(ComboBox.class).getEditor().getItem();
        if (object instanceof String) {
            String data = (String)object;
            builder.bcEnumHolder(data);
        } else {
            object = this.fields.get(Fields.ENUM_BC_HOLDER).getTypedInputElement(ComboBox.class).getEditor().getItem();
            if (object instanceof PsiClass) {
                PsiClass psiClass = (PsiClass)object;
                builder.bcEnumHolder(psiClass.getQualifiedName());
            }
        }
        return builder;
    }

    private void filVersionAwareData(BcDialogCreationData.Builder builder) {
        PsiClass psiClass;
        String data;
        Object object = this.fields.get(Fields.ENTITY_VERSION_AWARE).getTypedInputElement(ComboBox.class).getEditor().getItem();
        if (object instanceof String) {
            data = (String)object;
            builder.entityClzName(data);
        } else {
            object = this.fields.get(Fields.ENTITY_VERSION_AWARE).getTypedInputElement(ComboBox.class).getEditor().getItem();
            if (object instanceof PsiClass) {
                psiClass = (PsiClass)object;
                builder.entityClzName(psiClass.getQualifiedName());
            }
        }
        object = this.fields.get(Fields.DTO_VERSION_AWARE).getTypedInputElement(ComboBox.class).getEditor().getItem();
        if (object instanceof String) {
            data = (String)object;
            builder.dtoClzName(data);
        } else {
            object = this.fields.get(Fields.DTO_VERSION_AWARE).getTypedInputElement(ComboBox.class).getEditor().getItem();
            if (object instanceof PsiClass) {
                psiClass = (PsiClass)object;
                builder.dtoClzName(psiClass.getQualifiedName());
            }
        }
        object = this.fields.get(Fields.SERVICE_VERSION_AWARE).getTypedInputElement(ComboBox.class).getEditor().getItem();
        if (object instanceof String) {
            data = (String)object;
            builder.serviceClzName(data);
        } else {
            object = this.fields.get(Fields.SERVICE_VERSION_AWARE).getTypedInputElement(ComboBox.class).getEditor().getItem();
            if (object instanceof PsiClass) {
                psiClass = (PsiClass)object;
                builder.serviceClzName(psiClass.getQualifiedName()).isNewService(false);
            }
        }
    }

    private void fillAnySourceData(BcDialogCreationData.Builder builder) {
        PsiClass psiClass;
        String data;
        Object object = this.fields.get(Fields.DTO_ANY_SOURCE).getTypedInputElement(ComboBox.class).getEditor().getItem();
        if (object instanceof String) {
            data = (String)object;
            builder.dtoClzName(data);
            builder.entityClzName(data);
        } else {
            object = this.fields.get(Fields.DTO_ANY_SOURCE).getTypedInputElement(ComboBox.class).getEditor().getItem();
            if (object instanceof PsiClass) {
                psiClass = (PsiClass)object;
                builder.dtoClzName(psiClass.getQualifiedName());
                builder.entityClzName(psiClass.getQualifiedName());
            }
        }
        object = this.fields.get(Fields.SERVICE_ANY_SOURCE).getTypedInputElement(ComboBox.class).getEditor().getItem();
        if (object instanceof String) {
            data = (String)object;
            builder.serviceClzName(data);
        } else {
            object = this.fields.get(Fields.SERVICE_ANY_SOURCE).getTypedInputElement(ComboBox.class).getEditor().getItem();
            if (object instanceof PsiClass) {
                psiClass = (PsiClass)object;
                builder.serviceClzName(psiClass.getQualifiedName()).isNewService(false);
            }
        }
    }

    private static void checkClassAsync(String className, Project project, List<Runnable> runnable) {
        AppExecutorUtil.getAppExecutorService().submit(() -> {
            PsiClass existing = (PsiClass)ApplicationManager.getApplication().runReadAction(() -> JavaPsiFacade.getInstance((Project)project).findClass(className, GlobalSearchScope.allScope((Project)project)));
        });
    }

    @NotNull
    protected List<ValidationInfo> doValidateAll() {
        ArrayList<ValidationInfo> validationInfos = new ArrayList<ValidationInfo>();
        ResponseServiceType responseServiceType = (ResponseServiceType)this.fields.get(Fields.TYPE_SERVICE).getTypedInputElement(EnumComboBox.class).getSelectedItem();
        PsiNameHelper psiNameHelper = PsiNameHelper.getInstance((Project)this.project);
        LanguageLevel level = PsiUtil.getLanguageLevel((Project)this.project);
        this.runCommonValidation(responseServiceType, validationInfos, psiNameHelper, level);
        ArrayList<ValidationInfo> arrayList = validationInfos;
        if (arrayList == null) {
            BcCreationDialogWrapper.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    private void runCommonValidation(ResponseServiceType responseServiceType, ArrayList<ValidationInfo> validationInfos, PsiNameHelper psiNameHelper, LanguageLevel level) {
        Arrays.stream(Fields.values()).filter(f -> f.getApplicableType().contains(responseServiceType)).filter(Fields::isValidate).forEach(f -> {
            Object typedInputElement = this.fields.get(f).getTypedInputElement();
            String value = f.getValueExtractor().apply((JComponent)typedInputElement);
            if (value == null) {
                validationInfos.add(new ValidationInfo("Cannot be empty", typedInputElement));
            } else {
                String pck = JavaNameUtils.getPackageFromFQN(value);
                String cls = JavaNameUtils.getNameFromFQN(value);
                if (!psiNameHelper.isIdentifier(cls, level)) {
                    validationInfos.add(new ValidationInfo("Invalid className", typedInputElement));
                }
                if (!psiNameHelper.isQualifiedName(pck)) {
                    validationInfos.add(new ValidationInfo("Invalid package", typedInputElement));
                }
            }
        });
    }

    private static PsiClass checkInReadAction(Project project, Module module, String fqn) {
        return (PsiClass)ApplicationManager.getApplication().runReadAction(() -> {
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
            return JavaUtil.safetyFindClass(facade, fqn, GlobalSearchScope.projectScope((Project)project).union((SearchScope)GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module)));
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/cxbox/intellij/community/wigdet/bc/ui/BcCreationDialogWrapper", "doValidateAll"));
    }

    public static enum Panel implements UiNamedComponent
    {
        MAIN,
        BC_CREATION,
        BC_PARENT;


        @Override
        public String getName() {
            return this.name();
        }
    }

    public static enum Fields implements UiNamedComponent
    {
        ENUM_BC_HOLDER(Panel.MAIN, Arrays.asList(ResponseServiceType.values()), true, true, -1, PanelWithTextAndInputAndSuggestionElement.class, () -> new JBLabel("Service association: "), (m, n) -> PanelWithTextAndInputAndSuggestionElement.createComboBox(Optional.of(m.dialogInitData().fieldsSuggestionData().enumBcIdentifier()).orElse(null), Optional.ofNullable(m.dialogInitData().suggestionInitData().nearestBcHolder()).map(PsiClass::getQualifiedName).orElse(""), PsiClass.class, PsiClass::getQualifiedName), (m, n) -> PanelWithTextAndInputAndSuggestionElement.createSuggestion(m.element().getProject(), "service association", m), BcCreationDialogWrapper.getStrigValueInputFields()),
        TYPE_SERVICE(Panel.MAIN, Arrays.asList(ResponseServiceType.values()), false, true, 0, PanelWithTextAndInputAndSuggestion.class, () -> new JBLabel("Type service: "), (m, n) -> new EnumComboBox<ResponseServiceType>(m.dialogInitData().fieldsSuggestionData().types()), (m, n) -> new JBLabel("Please choose service type"), BcCreationDialogWrapper.getStrigValueInputFields()),
        SERVICE_VERSION_AWARE(Panel.BC_CREATION, List.of(ResponseServiceType.VERSION_AWARE_RESPONSE_SERVICE), true, true, 1, PanelWithTextAndInputAndSuggestionElement.class, () -> new JBLabel("Service name: "), (m, n) -> PanelWithTextAndInputAndSuggestionElement.createComboBox(m.dialogInitData().fieldsSuggestionData().versionAwareServices(), m.dialogInitData().suggestionInitData().servicePackage().getServicePackage(ResponseServiceType.VERSION_AWARE_RESPONSE_SERVICE, m.dialogInitData().suggestionInitData().nearestBcHolder()) + "." + n + ElementPostfix.SERVICE.getName(), PsiClass.class, PsiClass::getQualifiedName), (m, n) -> PanelWithTextAndInputAndSuggestionElement.createSuggestion(m.element().getProject(), "service", m), BcCreationDialogWrapper.getStrigValueInputFields()),
        ENTITY_VERSION_AWARE(Panel.BC_CREATION, List.of(ResponseServiceType.VERSION_AWARE_RESPONSE_SERVICE), true, true, 3, PanelWithTextAndInputAndSuggestionElement.class, () -> new JBLabel("Entity name: "), (m, n) -> PanelWithTextAndInputAndSuggestionElement.createComboBox(m.dialogInitData().fieldsSuggestionData().entities(), m.dialogInitData().suggestionInitData().entitySuggestion() + "." + n + ElementPostfix.ENTITY.getName(), PsiClass.class, PsiClass::getQualifiedName), (m, n) -> PanelWithTextAndInputAndSuggestionElement.createSuggestion(m.element().getProject(), "entity", m), BcCreationDialogWrapper.getStrigValueInputFields()),
        DTO_VERSION_AWARE(Panel.BC_CREATION, List.of(ResponseServiceType.VERSION_AWARE_RESPONSE_SERVICE), true, true, 2, PanelWithTextAndInputAndSuggestionElement.class, () -> new JBLabel("DTO name: "), (m, n) -> PanelWithTextAndInputAndSuggestionElement.createComboBox(m.dialogInitData().fieldsSuggestionData().dtos(), m.dialogInitData().suggestionInitData().dtoSuggestion() + "." + n + ElementPostfix.DTO.getName(), PsiClass.class, PsiClass::getQualifiedName), (m, n) -> PanelWithTextAndInputAndSuggestionElement.createSuggestion(m.element().getProject(), "dto", m), BcCreationDialogWrapper.getStrigValueInputFields()),
        SERVICE_ANY_SOURCE(Panel.BC_CREATION, List.of(ResponseServiceType.ANY_SOURCE_VERSION_AWARE_RESPONSE_SERVICE), true, true, 1, PanelWithTextAndInputAndSuggestionElement.class, () -> new JBLabel("Service name: "), (m, n) -> PanelWithTextAndInputAndSuggestionElement.createComboBox(m.dialogInitData().fieldsSuggestionData().anySourceServices(), m.dialogInitData().suggestionInitData().servicePackage().getServicePackage(ResponseServiceType.ANY_SOURCE_VERSION_AWARE_RESPONSE_SERVICE, m.dialogInitData().suggestionInitData().nearestBcHolder()) + "." + n + ElementPostfix.SERVICE.getName(), PsiClass.class, PsiClass::getQualifiedName), (m, n) -> PanelWithTextAndInputAndSuggestionElement.createSuggestion(m.element().getProject(), "service", m), BcCreationDialogWrapper.getStrigValueInputFields()),
        ENTITY_ANY_SOURCE(Panel.BC_CREATION, List.of(ResponseServiceType.ANY_SOURCE_VERSION_AWARE_RESPONSE_SERVICE), true, true, 3, PanelWithTextAndInputAndSuggestionElement.class, () -> new JBLabel("Entity name: "), (m, n) -> PanelWithTextAndInputAndSuggestionElement.createComboBox(m.dialogInitData().fieldsSuggestionData().entities(), m.dialogInitData().suggestionInitData().dtoSuggestion() + "." + n + ElementPostfix.DTO.getName(), PsiClass.class, PsiClass::getQualifiedName), (m, n) -> PanelWithTextAndInputAndSuggestionElement.createSuggestion(m.element().getProject(), "entity", m), BcCreationDialogWrapper.getStrigValueInputFields()),
        DTO_ANY_SOURCE(Panel.BC_CREATION, List.of(ResponseServiceType.ANY_SOURCE_VERSION_AWARE_RESPONSE_SERVICE), true, true, 2, PanelWithTextAndInputAndSuggestionElement.class, () -> new JBLabel("DTO name: "), (m, n) -> PanelWithTextAndInputAndSuggestionElement.createComboBox(m.dialogInitData().fieldsSuggestionData().dtos(), m.dialogInitData().suggestionInitData().dtoSuggestion() + "." + n + ElementPostfix.DTO.getName(), PsiClass.class, PsiClass::getQualifiedName), (m, n) -> PanelWithTextAndInputAndSuggestionElement.createSuggestion(m.element().getProject(), "dto", m), BcCreationDialogWrapper.getStrigValueInputFields()),
        PARENT_BC(Panel.BC_PARENT, Arrays.asList(ResponseServiceType.values()), false, true, 10, PanelWithTextAndInputAndSuggestion.class, () -> new JBLabel("Parent bc"), (m, n) -> new PsiEnumConstantComboBox(m.module(), (List)m.dialogInitData().fieldsSuggestionData().parentBc()), (m, n) -> new JBLabel("Start typing to suggestion. <None> for empty bc parent"), BcCreationDialogWrapper.getStrigValueInputFields()),
        TYPE_RELATIONSHIP(Panel.BC_PARENT, List.of(ResponseServiceType.VERSION_AWARE_RESPONSE_SERVICE), false, false, 11, PanelWithTextAndInputAndSuggestion.class, () -> new JBLabel("Relationship type"), (m, n) -> new EnumComboBox<RelationshipEntityType>(Arrays.asList(RelationshipEntityType.values())), (m, n) -> {
            JBLabel relationshipType = new JBLabel("Relationship type");
            relationshipType.setCopyable(true);
            return relationshipType;
        }, BcCreationDialogWrapper.getStrigValueInputFields());

        private final List<ResponseServiceType> applicableType;
        private final UiNamedComponent panel;
        private final boolean isVisible;
        private final boolean isValidate;
        private final int order;
        private final Class<? extends PanelComponent> component;
        private final Supplier<JBLabel> nameSupplier;
        private final BiFunction<BCInspection.FixWithCreationBc.BcCreationMetaData, String, JComponent> inputSupplier;
        private final BiFunction<BCInspection.FixWithCreationBc.BcCreationMetaData, String, JComponent> labelSupplier;
        private final Function<JComponent, String> valueExtractor;

        private Fields(UiNamedComponent panel, List<ResponseServiceType> applicableType, boolean isValidate, boolean isVisible, int order, Class<? extends PanelComponent> component, Supplier<JBLabel> nameSupplier, BiFunction<BCInspection.FixWithCreationBc.BcCreationMetaData, String, JComponent> input, BiFunction<BCInspection.FixWithCreationBc.BcCreationMetaData, String, JComponent> labelSupplier, Function<JComponent, String> valueExtractor) {
            this.applicableType = applicableType;
            this.panel = panel;
            this.isVisible = isVisible;
            this.order = order;
            this.nameSupplier = nameSupplier;
            this.inputSupplier = input;
            this.labelSupplier = labelSupplier;
            this.component = component;
            this.isValidate = isValidate;
            this.valueExtractor = valueExtractor;
        }

        @Override
        public String getName() {
            return this.name();
        }

        public List<ResponseServiceType> getApplicableType() {
            return this.applicableType;
        }

        public UiNamedComponent getPanel() {
            return this.panel;
        }

        public int getOrder() {
            return this.order;
        }

        public boolean isVisible() {
            return this.isVisible;
        }

        public boolean isValidate() {
            return this.isValidate;
        }

        public Supplier<JBLabel> nameSupplier() {
            return this.nameSupplier;
        }

        public BiFunction<BCInspection.FixWithCreationBc.BcCreationMetaData, String, JComponent> providerSupplier() {
            return this.inputSupplier;
        }

        public BiFunction<BCInspection.FixWithCreationBc.BcCreationMetaData, String, JComponent> labelSupplier() {
            return this.labelSupplier;
        }

        public Class<? extends PanelComponent> getComponent() {
            return this.component;
        }

        public Function<JComponent, String> getValueExtractor() {
            return this.valueExtractor;
        }
    }
}

