/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.common.cache;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.ForcefulReparseModificationTracker;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Service(value={Service.Level.PROJECT})
public final class PlatformToolsJavaLibraryModificationTracker
implements ModificationTracker,
Disposable {
    public static final Topic<FileDocumentManagerListener> TOPIC = new Topic(FileDocumentManagerListener.class, Topic.BroadcastDirection.TO_DIRECT_CHILDREN, true);
    private final ModificationTracker myProjectRootManager;
    private final ModificationTracker myDumbServiceModificationTracker;
    private final ModificationTracker myForcefulReparseModificationTracker;
    private final SimpleModificationTracker myOnContentReloadModificationTracker = new SimpleModificationTracker();

    public PlatformToolsJavaLibraryModificationTracker(final Project project) {
        this.myProjectRootManager = ProjectRootManager.getInstance((Project)project);
        this.myDumbServiceModificationTracker = DumbService.getInstance((Project)project).getModificationTracker();
        this.myForcefulReparseModificationTracker = ForcefulReparseModificationTracker.getInstance();
        MessageBusConnection connection = project.getMessageBus().connect((Disposable)this);
        connection.subscribe(TOPIC, (Object)new FileDocumentManagerListener(){
            private final GlobalSearchScope projectLibraryScope;
            {
                this.projectLibraryScope = ProjectScope.getLibrariesScope((Project)project);
            }

            public void fileWithNoDocumentChanged(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (this.projectLibraryScope.contains(file)) {
                    PlatformToolsJavaLibraryModificationTracker.this.myOnContentReloadModificationTracker.incModificationCount();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/cxbox/intellij/community/common/cache/PlatformToolsJavaLibraryModificationTracker$1", "fileWithNoDocumentChanged"));
            }
        });
    }

    public static ModificationTracker getInstance(Project project) {
        return (ModificationTracker)project.getService(PlatformToolsJavaLibraryModificationTracker.class);
    }

    @TestOnly
    public static void incModificationCount(Project project) {
        ((PlatformToolsJavaLibraryModificationTracker)project.getService(PlatformToolsJavaLibraryModificationTracker.class)).incModificationCount();
    }

    public long getModificationCount() {
        return this.myProjectRootManager.getModificationCount() + this.myDumbServiceModificationTracker.getModificationCount() + this.myForcefulReparseModificationTracker.getModificationCount() + this.myOnContentReloadModificationTracker.getModificationCount();
    }

    @TestOnly
    public void incModificationCount() {
        this.myOnContentReloadModificationTracker.incModificationCount();
    }

    public void dispose() {
    }
}

