/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.wigdet.options.actionGroups.actionGroup;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.json.psi.JsonElementVisitor;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import org.cxbox.intellij.community.common.conf.JWidget;
import org.cxbox.intellij.community.common.util.JsonElementGenerator;
import org.cxbox.intellij.community.common.util.JsonFacade;
import org.cxbox.intellij.community.common.util.QuickFixUtils;
import org.jetbrains.annotations.NotNull;

public class ActionGroupLocationInspection
extends LocalInspectionTool {
    private static final String COMMA = ",";

    public static boolean isInOptionals(@NotNull JsonObject actionGroups) {
        JsonProperty parent;
        if (actionGroups == null) {
            ActionGroupLocationInspection.$$$reportNull$$$0(0);
        }
        if (actionGroups.getParent() != null && (parent = JsonFacade.getParentOfType(actionGroups.getParent(), JsonProperty.class, true)) != null) {
            return JWidget.OPTIONS.getName().equals(parent.getName());
        }
        return false;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        PsiFile file;
        if (holder == null) {
            ActionGroupLocationInspection.$$$reportNull$$$0(1);
        }
        if (!((file = holder.getFile()) instanceof JsonFile)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                ActionGroupLocationInspection.$$$reportNull$$$0(2);
            }
            return psiElementVisitor;
        }
        final JsonFile jsonFile = (JsonFile)file;
        if (!file.getName().endsWith(".widget.json")) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                ActionGroupLocationInspection.$$$reportNull$$$0(3);
            }
            return psiElementVisitor;
        }
        final Project project = file.getProject();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (module == null) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                ActionGroupLocationInspection.$$$reportNull$$$0(4);
            }
            return psiElementVisitor;
        }
        return new JsonElementVisitor(){

            public void visitObject(@NotNull JsonObject o) {
                JsonProperty actionGroups;
                if (o == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((actionGroups = JsonFacade.getParentOfType((PsiElement)o, JsonProperty.class, true)) != null && JWidget.ACTION_GROUP_KEY.getName().equals(actionGroups.getName()) && !ActionGroupLocationInspection.isInOptionals(o)) {
                    InspectionManager manager = InspectionManager.getInstance((Project)project);
                    String errorMsg = "\"" + JWidget.ACTION_GROUP_KEY.getName() + "\" must be inside \"" + JWidget.OPTIONS.getName() + "\"";
                    holder.registerProblem(manager.createProblemDescriptor((PsiElement)jsonFile, new TextRange(actionGroups.getTextOffset() + 1, actionGroups.getTextOffset() + actionGroups.getName().length() + 1), errorMsg, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, true, new LocalQuickFix[]{new Fix(jsonFile, actionGroups, errorMsg)}));
                }
                super.visitObject(o);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "org/cxbox/intellij/community/wigdet/options/actionGroups/actionGroup/ActionGroupLocationInspection$1", "visitObject"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionGroups";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/cxbox/intellij/community/wigdet/options/actionGroups/actionGroup/ActionGroupLocationInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/cxbox/intellij/community/wigdet/options/actionGroups/actionGroup/ActionGroupLocationInspection";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isInOptionals";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }

    private record Fix(JsonFile jsonFile, JsonProperty actionGroups, String errorMsg) implements LocalQuickFix
    {
        public boolean availableInBatchMode() {
            return false;
        }

        @NotNull
        public String getName() {
            String string = this.errorMsg + ". Move actionGroups";
            if (string == null) {
                Fix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = this.errorMsg + ". Move actionGroups";
            if (string == null) {
                Fix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                Fix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                Fix.$$$reportNull$$$0(3);
            }
            JsonObject topLevelObject = JsonFacade.getTopLevelObject(this.jsonFile);
            JsonObject options = JsonFacade.safeGetPropertyValueOfType(topLevelObject, JWidget.OPTIONS);
            JsonElementGenerator json = new JsonElementGenerator(project);
            JsonObject actionGroupsObj = json.createObject(this.actionGroups.getText());
            JsonProperty optionsProp = json.createProperty(JWidget.OPTIONS.getName(), actionGroupsObj.getText());
            CodeStyleManager.getInstance((Project)project).performActionWithFormatterDisabled(() -> {
                if (topLevelObject != null) {
                    PsiElement nextSibling;
                    if (options == null) {
                        if (!topLevelObject.getPropertyList().isEmpty()) {
                            topLevelObject.addAfter((PsiElement)optionsProp, (PsiElement)topLevelObject.getPropertyList().get(topLevelObject.getPropertyList().size() - 1));
                            topLevelObject.addBefore(json.createComma(), (PsiElement)topLevelObject.getPropertyList().get(topLevelObject.getPropertyList().size() - 1));
                        }
                    } else if (options.getPropertyList().isEmpty()) {
                        options.replace((PsiElement)actionGroupsObj);
                    } else {
                        options.addBefore((PsiElement)this.actionGroups, (PsiElement)options.getPropertyList().get(0));
                        options.addAfter(json.createComma(), (PsiElement)options.getPropertyList().get(0));
                    }
                    if ((nextSibling = this.actionGroups.getNextSibling()) != null && nextSibling.getText().equals(ActionGroupLocationInspection.COMMA)) {
                        nextSibling.delete();
                    }
                    this.actionGroups.delete();
                }
            });
            CodeStyleManager.getInstance((Project)project).reformat((PsiElement)this.jsonFile.getContainingFile());
            QuickFixUtils.safeDoPostponedOperationsIfPossible(project, (PsiElement)actionGroupsObj);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/cxbox/intellij/community/wigdet/options/actionGroups/actionGroup/ActionGroupLocationInspection$Fix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/cxbox/intellij/community/wigdet/options/actionGroups/actionGroup/ActionGroupLocationInspection$Fix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

