/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.wigdet.fields.field;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.json.JsonFileType;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.cxbox.intellij.community.common.conf.JWidget;
import org.cxbox.intellij.community.common.util.JavaFacade;
import org.cxbox.intellij.community.common.util.JsonFacade;
import org.cxbox.intellij.community.common.util.ResponseServiceUtils;
import org.cxbox.intellij.community.exception.PlatformValidationException;
import org.cxbox.intellij.community.wigdet.fields.AwareResponseServiceType;
import org.cxbox.intellij.community.wigdet.fields.StandardFieldType;
import org.cxbox.intellij.community.wigdet.fields.field.generator.common.PlatformDisplayName;
import org.cxbox.intellij.community.wigdet.fields.field.generator.common.ResponseServiceWidgetNewFieldGenerator;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\r\u0010\b\u001a\u00070\u0007\u00a2\u0006\u0002\b\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0005H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u000fH\u0016J(\u0010\u0015\u001a\u00020\u00122\u000e\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00180\u00172\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u00a8\u0006\u001b"}, d2={"Lorg/cxbox/intellij/community/wigdet/fields/field/AddNewFieldFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "<init>", "()V", "availableInBatchMode", "", "getName", "", "getFamilyName", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "project", "Lcom/intellij/openapi/project/Project;", "previewDescriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "startInWriteAction", "applyFix", "", "prj", "descriptor", "doFix", "aClass", "Ljava/lang/Class;", "Lorg/cxbox/intellij/community/wigdet/fields/field/generator/common/ResponseServiceWidgetNewFieldGenerator;", "fieldNameLiteral", "Lcom/intellij/json/psi/JsonStringLiteral;", "cxbox-intellij-plugin"})
public final class AddNewFieldFix
implements LocalQuickFix {
    public boolean availableInBatchMode() {
        return false;
    }

    @NotNull
    public String getName() {
        return "Add new field";
    }

    @NotNull
    public String getFamilyName() {
        return "Add new field";
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)previewDescriptor, (String)"previewDescriptor");
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
        return intentionPreviewInfo;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project prj, @NotNull ProblemDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)prj, (String)"prj");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        JavaFacade.withPrettyException(prj, null, () -> AddNewFieldFix.applyFix$lambda$11(descriptor, prj, this));
    }

    private final void doFix(Class<? extends ResponseServiceWidgetNewFieldGenerator> aClass, Project prj, JsonStringLiteral fieldNameLiteral) {
        JavaFacade.withPrettyExceptionAndRethrow(() -> AddNewFieldFix.doFix$lambda$12(aClass, prj, fieldNameLiteral));
    }

    private static final List applyFix$lambda$11$lambda$0(AwareResponseServiceType $serviceType, StandardFieldType it) {
        return StandardFieldType.getGeneratorClz(it, $serviceType);
    }

    private static final List applyFix$lambda$11$lambda$1(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final String applyFix$lambda$11$lambda$2(Class e) {
        return e.getAnnotation(PlatformDisplayName.class).name();
    }

    private static final String applyFix$lambda$11$lambda$3(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final boolean applyFix$lambda$11$lambda$9$lambda$7$lambda$4(String $it, Class e) {
        return Intrinsics.areEqual((Object)e.getAnnotation(PlatformDisplayName.class).name(), (Object)$it);
    }

    private static final boolean applyFix$lambda$11$lambda$9$lambda$7$lambda$5(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void applyFix$lambda$11$lambda$9$lambda$7$lambda$6(JsonStringLiteral $fieldNameLiteral, Project $prj, AddNewFieldFix this$0, Ref.ObjectRef $aClass) {
        if ($fieldNameLiteral.isValid()) {
            PsiDocumentManager.getInstance((Project)$prj).commitAllDocuments();
            Object object = $aClass.element;
            Intrinsics.checkNotNull((Object)object);
            this$0.doFix((Class)object, $prj, $fieldNameLiteral);
        }
    }

    private static final Unit applyFix$lambda$11$lambda$9$lambda$7(Ref.ObjectRef $aClass, List $aClassVariants, Project $prj, JsonStringLiteral $fieldNameLiteral, AddNewFieldFix this$0, String it) {
        $aClass.element = $aClassVariants.stream().filter(arg_0 -> AddNewFieldFix.applyFix$lambda$11$lambda$9$lambda$7$lambda$5(arg_0 -> AddNewFieldFix.applyFix$lambda$11$lambda$9$lambda$7$lambda$4(it, arg_0), arg_0)).findAny().orElse(null);
        if ($aClass.element != null) {
            PsiFile[] psiFileArray = new PsiFile[]{$fieldNameLiteral.getContainingFile()};
            WriteCommandAction.writeCommandAction((Project)$prj, (PsiFile[])psiFileArray).run(() -> AddNewFieldFix.applyFix$lambda$11$lambda$9$lambda$7$lambda$6($fieldNameLiteral, $prj, this$0, $aClass));
        }
        return Unit.INSTANCE;
    }

    private static final void applyFix$lambda$11$lambda$9$lambda$8(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit applyFix$lambda$11$lambda$9(List $toList, Ref.ObjectRef $aClass, List $aClassVariants, Project $prj, JsonStringLiteral $fieldNameLiteral, AddNewFieldFix this$0, DataContext it) {
        JBPopupFactory.getInstance().createPopupChooserBuilder($toList).setSelectionMode(0).setItemChosenCallback(arg_0 -> AddNewFieldFix.applyFix$lambda$11$lambda$9$lambda$8(arg_0 -> AddNewFieldFix.applyFix$lambda$11$lambda$9$lambda$7($aClass, $aClassVariants, $prj, $fieldNameLiteral, this$0, arg_0), arg_0)).createPopup().showInBestPositionFor(it);
        return Unit.INSTANCE;
    }

    private static final void applyFix$lambda$11$lambda$10(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void applyFix$lambda$11(ProblemDescriptor $descriptor, Project $prj, AddNewFieldFix this$0) {
        Ref.ObjectRef aClass = new Ref.ObjectRef();
        PsiElement psiElement = $descriptor.getPsiElement();
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.json.psi.JsonStringLiteral");
        JsonStringLiteral fieldNameLiteral = (JsonStringLiteral)psiElement;
        JsonProperty tagProperty = JsonFacade.getParentOfType((PsiElement)fieldNameLiteral, JsonProperty.class);
        String fieldType = JWidget.getFieldType(tagProperty);
        CharSequence charSequence = fieldType;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            throw new PlatformValidationException("field <a href=\"1\">type</a> must not be null or blank", (NavigatablePsiElement)tagProperty, $prj);
        }
        PsiFile file = fieldNameLiteral.getContainingFile();
        if (file.getFileType().equals(JsonFileType.INSTANCE)) {
            AwareResponseServiceType serviceType = ResponseServiceUtils.getServiceTypeFromJsonWidgetFile(file);
            List list = StandardFieldType.getByFieldType(fieldType).map(arg_0 -> AddNewFieldFix.applyFix$lambda$11$lambda$1(arg_0 -> AddNewFieldFix.applyFix$lambda$11$lambda$0(serviceType, arg_0), arg_0)).orElse(null);
            if (list == null) {
                throw new PlatformValidationException("Cannot find generator for field  = " + JsonFacade.getValue(fieldNameLiteral), (NavigatablePsiElement)fieldNameLiteral, $prj);
            }
            List aClassVariants = list;
            if (aClassVariants.size() == 1) {
                aClass.element = aClassVariants.get(0);
                if (aClass.element != null) {
                    this$0.doFix((Class)aClass.element, $prj, fieldNameLiteral);
                }
            } else {
                List<String> toList = aClassVariants.stream().map(arg_0 -> AddNewFieldFix.applyFix$lambda$11$lambda$3(AddNewFieldFix::applyFix$lambda$11$lambda$2, arg_0)).toList();
                DataManager.getInstance().getDataContextFromFocusAsync().onSuccess(arg_0 -> AddNewFieldFix.applyFix$lambda$11$lambda$10(arg_0 -> AddNewFieldFix.applyFix$lambda$11$lambda$9(toList, aClass, aClassVariants, $prj, fieldNameLiteral, this$0, arg_0), arg_0));
            }
        }
    }

    private static final void doFix$lambda$12(Class $aClass, Project $prj, JsonStringLiteral $fieldNameLiteral) {
        ResponseServiceWidgetNewFieldGenerator responseServiceWidgetNewFieldGenerator;
        try {
            Object[] objectArray = new Object[]{$prj, $fieldNameLiteral};
            Object obj = $aClass.getConstructors()[0].newInstance(objectArray);
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.cxbox.intellij.community.wigdet.fields.field.generator.common.ResponseServiceWidgetNewFieldGenerator");
            responseServiceWidgetNewFieldGenerator = (ResponseServiceWidgetNewFieldGenerator)obj;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof PlatformValidationException) {
                throw e.getTargetException();
            }
            throw e;
        }
        catch (Exception e) {
            throw new PlatformValidationException("Cannot create generator for <a href=\"1\">field</a> = " + JsonFacade.getValue($fieldNameLiteral), (NavigatablePsiElement)$fieldNameLiteral, $prj);
        }
        ResponseServiceWidgetNewFieldGenerator generator = responseServiceWidgetNewFieldGenerator;
        generator.createField();
    }
}

