/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.wigdet.fields.field.generator;

import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.List;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.cxbox.intellij.community.common.util.DataResponseDTOUtil;
import org.cxbox.intellij.community.common.util.FieldMetaBuilderUtil;
import org.cxbox.intellij.community.common.util.FieldWithAnnotation;
import org.cxbox.intellij.community.common.util.JavaUtil;
import org.cxbox.intellij.community.common.util.SearchScopeUtil;
import org.cxbox.intellij.community.common.util.VersionAwareServiceUtils;
import org.cxbox.intellij.community.wigdet.fields.field.generator.AbstractVersionAwareWidgetNewFieldGenerator;
import org.cxbox.intellij.community.wigdet.fields.field.generator.PlatformDisplayName;
import org.cxbox.intellij.community.wigdet.fields.field.generator.TemplatesKt;
import org.jetbrains.annotations.NotNull;

@PlatformDisplayName(name="(not recommended) Enum stored in Entity as comma separated string")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J@\u0010\r\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0012H\u0002\u00a8\u0006\u0015"}, d2={"Lorg/cxbox/intellij/community/wigdet/fields/field/generator/MultipleSelectFieldCommaSeparatedGenerator;", "Lorg/cxbox/intellij/community/wigdet/fields/field/generator/AbstractVersionAwareWidgetNewFieldGenerator;", "prj", "Lcom/intellij/openapi/project/Project;", "fieldNameLiteral", "Lcom/intellij/json/psi/JsonStringLiteral;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/json/psi/JsonStringLiteral;)V", "fieldTypes", "", "", "prepareFieldCreation", "Lorg/cxbox/intellij/community/wigdet/fields/field/generator/AbstractVersionAwareWidgetNewFieldGenerator$Result;", "prepareMultipleSelect", "pkg", "persistenceVersion", "fieldName", "dtoPsiClass", "Lcom/intellij/psi/PsiClass;", "dtoMetaPsiClzFQN", "entityPsiClass", "cxbox-intellij-plugin"})
public final class MultipleSelectFieldCommaSeparatedGenerator
extends AbstractVersionAwareWidgetNewFieldGenerator {
    public MultipleSelectFieldCommaSeparatedGenerator(@NotNull Project prj, @NotNull JsonStringLiteral fieldNameLiteral) {
        Intrinsics.checkNotNullParameter((Object)prj, (String)"prj");
        Intrinsics.checkNotNullParameter((Object)fieldNameLiteral, (String)"fieldNameLiteral");
        super(prj, fieldNameLiteral);
    }

    @Override
    @NotNull
    public List<String> fieldTypes() {
        return CollectionsKt.listOf((Object)"multipleSelect");
    }

    @Override
    @NotNull
    public AbstractVersionAwareWidgetNewFieldGenerator.Result prepareFieldCreation() {
        return this.prepareMultipleSelect(this.getPrj(), this.getPkg(), this.getPersistenceVersion(), this.getFieldName(), this.getDtoPsiClz(), this.getDtoMetaPsiClzFQN(), this.getEntityPsiClz());
    }

    private final AbstractVersionAwareWidgetNewFieldGenerator.Result prepareMultipleSelect(Project prj, String pkg, String persistenceVersion, String fieldName, PsiClass dtoPsiClass, String dtoMetaPsiClzFQN, PsiClass entityPsiClass) {
        String string = JavaUtil.capitalizeFirstLetter(fieldName);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"capitalizeFirstLetter(...)");
        String capitalizeFirstLetterFieldName = string;
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)((PsiElement)dtoPsiClass));
        if (module == null) {
            throw new IllegalStateException();
        }
        GlobalSearchScope globalSearchScope = SearchScopeUtil.getModuleSearchScopeWithParentsAndChildsAndLibraries(module, prj);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getModuleSearchScopeWith\u2026ndChildsAndLibraries(...)");
        GlobalSearchScope scp = globalSearchScope;
        AbstractVersionAwareWidgetNewFieldGenerator.Result result = new AbstractVersionAwareWidgetNewFieldGenerator.Result();
        PsiClassType psiClassType = PsiType.getTypeByName((String)(pkg + ".core.dto.multivalue.MultivalueField"), (Project)prj, (GlobalSearchScope)scp);
        Intrinsics.checkNotNullExpressionValue((Object)psiClassType, (String)"getTypeByName(...)");
        PsiClassType dtoFieldType = psiClassType;
        FieldWithAnnotation it = new FieldWithAnnotation();
        boolean bl = false;
        it.setField(TemplatesKt.getBasicDtoField(fieldName, (PsiType)dtoFieldType));
        it.getAnnotations().add("@" + pkg + ".core.util.filter.SearchParameter(name = \"" + fieldName + "\", multiFieldKey = " + pkg + ".core.util.filter.provider.impl.StringValueProvider.class)");
        result.getDtoFields().add(it);
        it = new FieldWithAnnotation();
        boolean bl2 = false;
        it.setField(TemplatesKt.getDtoMetaModelFieldBasic(dtoPsiClass, pkg, fieldName, dtoFieldType));
        result.getDtoMetaModelFields().add(it);
        String enumQN = AbstractVersionAwareWidgetNewFieldGenerator.Companion.createEnum(prj, fieldName, dtoPsiClass, entityPsiClass);
        FieldWithAnnotation it2 = new FieldWithAnnotation();
        boolean bl3 = false;
        PsiClassType psiClassType2 = PsiType.getTypeByName((String)"java.lang.String", (Project)prj, (GlobalSearchScope)scp);
        Intrinsics.checkNotNullExpressionValue((Object)psiClassType2, (String)"getTypeByName(...)");
        it2.setField(TemplatesKt.getBasicEntityField(fieldName, (PsiType)psiClassType2));
        it2.getAnnotations().add("@" + persistenceVersion + ".Column /* comma separated enum keys @see " + enumQN + " */");
        result.getEntityFields().add(it2);
        result.getRowIndependentMeta().add(arg_0 -> MultipleSelectFieldCommaSeparatedGenerator.prepareMultipleSelect$lambda$3(dtoMetaPsiClzFQN, fieldName, arg_0));
        result.getRowDependentMeta().add(arg_0 -> MultipleSelectFieldCommaSeparatedGenerator.prepareMultipleSelect$lambda$4(dtoMetaPsiClzFQN, fieldName, arg_0));
        result.getRowDependentMeta().add(arg_0 -> MultipleSelectFieldCommaSeparatedGenerator.prepareMultipleSelect$lambda$5(dtoMetaPsiClzFQN, fieldName, enumQN, pkg, arg_0));
        result.getVersionAwareDoUpdate().add(arg_0 -> MultipleSelectFieldCommaSeparatedGenerator.prepareMultipleSelect$lambda$6(fieldName, dtoMetaPsiClzFQN, enumQN, arg_0));
        Function<String, String> entityToDto = arg_0 -> MultipleSelectFieldCommaSeparatedGenerator.prepareMultipleSelect$lambda$7(capitalizeFirstLetterFieldName, enumQN, dtoFieldType, arg_0);
        result.getDtoConstructorMapFormEntity().add(arg_0 -> MultipleSelectFieldCommaSeparatedGenerator.prepareMultipleSelect$lambda$8(fieldName, entityToDto, arg_0));
        result.getMapperBuilderPutLines().add(".put(" + dtoMetaPsiClzFQN + "." + fieldName + ", (m, e) -> " + entityToDto.apply("e") + ")");
        return result;
    }

    private static final String prepareMultipleSelect$lambda$3(String $dtoMetaPsiClzFQN, String $fieldName, FieldMetaBuilderUtil.RowIndependentMetaprms prms) {
        Intrinsics.checkNotNullParameter((Object)prms, (String)"prms");
        return TemplatesKt.getRowIndependentBasicEnableFilter($dtoMetaPsiClzFQN, $fieldName, prms);
    }

    private static final String prepareMultipleSelect$lambda$4(String $dtoMetaPsiClzFQN, String $fieldName, FieldMetaBuilderUtil.RowDependentMetaprms prms) {
        Intrinsics.checkNotNullParameter((Object)prms, (String)"prms");
        return TemplatesKt.getRowDependentBasicEnabled($dtoMetaPsiClzFQN, $fieldName, prms);
    }

    private static final String prepareMultipleSelect$lambda$5(String $dtoMetaPsiClzFQN, String $fieldName, String $enumQN, String $pkg, FieldMetaBuilderUtil.RowDependentMetaprms prms) {
        Intrinsics.checkNotNullParameter((Object)prms, (String)"prms");
        return prms.getFields() + ".setConcreteValues(" + $dtoMetaPsiClzFQN + "." + $fieldName + ", java.util.Arrays.stream(" + $enumQN + ".values())\n                .map(" + $enumQN + "::getValue)\n                .map(e ->  new " + $pkg + ".api.data.dictionary.SimpleDictionary(e, e))\n                .toList());";
    }

    private static final String prepareMultipleSelect$lambda$6(String $fieldName, String $dtoMetaPsiClzFQN, String $enumQN, VersionAwareServiceUtils.VersionAwareServiceDoUpdateEntityDto prms) {
        Intrinsics.checkNotNullParameter((Object)prms, (String)"prms");
        String string = JavaUtil.capitalizeFirstLetter($fieldName);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"capitalizeFirstLetter(...)");
        String camelFieldName = string;
        return "if (" + prms.getData() + ".isFieldChanged(" + $dtoMetaPsiClzFQN + "." + $fieldName + ")) {\n                " + prms.getEntity() + ".set" + camelFieldName + "(\n                    " + prms.getData() + ".get" + camelFieldName + "().getValues()\n                        .stream()\n                        .map(v -> " + $enumQN + ".getByValue(v.getValue()))\n                        .map(java.lang.Enum::name)\n                        .collect(java.util.stream.Collectors.joining(\",\",\",\",\",\"))); \n            }";
    }

    private static final String prepareMultipleSelect$lambda$7(String $capitalizeFirstLetterFieldName, String $enumQN, PsiClassType $dtoFieldType, String entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return "java.util.Optional.ofNullable(" + entity + ".get" + $capitalizeFirstLetterFieldName + "())\n                .map(el -> com.google.common.base.Splitter.on(\",\").trimResults().omitEmptyStrings().splitToList(el).stream()\n                .map(" + $enumQN + "::valueOf)\n                .collect(" + $dtoFieldType.getCanonicalText() + ".toMultivalueField(Enum::name," + $enumQN + "::getValue)))\n            .orElse(null)";
    }

    private static final String prepareMultipleSelect$lambda$8(String $fieldName, Function $entityToDto, DataResponseDTOUtil.DtoConstructorprms prms) {
        Intrinsics.checkNotNullParameter((Object)prms, (String)"prms");
        return "this." + $fieldName + " = " + $entityToDto.apply(prms.getEntity()) + ";";
    }
}

