/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.wigdet.bc.service.generator.common;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import org.cxbox.intellij.community.common.util.EnumBcUtil;
import org.cxbox.intellij.community.exception.PlatformValidationException;
import org.cxbox.intellij.community.wigdet.bc.service.generator.AbstractBcServicePsiElementGenerator;
import org.cxbox.intellij.community.wigdet.bc.service.generator.ElementGenerationContext;

public class EnumBcPsiElementGeneratorBc
extends AbstractBcServicePsiElementGenerator {
    @Override
    public PsiElement generateElement(ElementGenerationContext context) {
        PsiField anchor;
        PsiElementFactory factory = PsiElementFactory.getInstance((Project)context.module().getProject());
        Collection<PsiClass> allBcHolderWithoutCache = EnumBcUtil.getProjectBcHolderClass(context.module());
        PsiClass enumClass = allBcHolderWithoutCache.iterator().next();
        boolean isChild = context.elementBcData().parentBcEnum() != null;
        StringBuilder enumText = new StringBuilder();
        PsiField[] fields = enumClass.getFields();
        ArrayList<PsiEnumConstant> constants = new ArrayList<PsiEnumConstant>();
        for (PsiField field : fields) {
            if (!(field instanceof PsiEnumConstant)) continue;
            constants.add((PsiEnumConstant)field);
        }
        if (constants.isEmpty()) {
            anchor = null;
        } else if (isChild) {
            int i = constants.indexOf(context.elementBcData().parentBcEnum());
            anchor = fields[i];
        } else {
            anchor = fields[constants.size() - 1];
        }
        String className = enumClass.getContainingFile() instanceof PsiJavaFile ? context.elementBcData().serviceClz().getName() : context.elementBcData().serviceClz().getQualifiedName();
        if (anchor != null) {
            if (isChild) {
                enumText.append(",").append(anchor.getPrevSibling().getText()).append("\t");
            } else {
                enumText.append(",\n\t");
            }
        }
        enumText.append(context.elementBcData().bcEnumName()).append("(");
        if (isChild) {
            enumText.append(context.elementBcData().parentBcEnum().getName()).append(", ");
        }
        enumText.append(className).append(".class").append(")");
        PsiDocumentManager docMgr = PsiDocumentManager.getInstance((Project)context.module().getProject());
        Document doc = docMgr.getDocument(enumClass.getContainingFile());
        if (doc != null && anchor != null) {
            doc.replaceString(anchor.getTextRange().getEndOffset(), anchor.getTextRange().getEndOffset(), (CharSequence)enumText);
            docMgr.doPostponedOperationsAndUnblockDocument(doc);
            docMgr.commitDocument(doc);
        } else {
            enumClass.add((PsiElement)factory.createEnumConstantFromText(enumText.toString(), (PsiElement)enumClass));
        }
        PsiFile psiFile = enumClass.getContainingFile();
        if (psiFile instanceof PsiJavaFile) {
            PsiJavaFile javaFile = (PsiJavaFile)psiFile;
            PsiImportList importList = javaFile.getImportList();
            boolean alreadyImported = false;
            String serviceFullQualifiedName = context.elementBcData().serviceClz().getQualifiedName();
            if (serviceFullQualifiedName != null && importList != null) {
                alreadyImported = Arrays.stream(importList.getAllImportStatements()).anyMatch(psi -> serviceFullQualifiedName.equals(Optional.of(psi).map(PsiImportStatementBase::getImportReference).map(PsiJavaCodeReferenceElement::getQualifiedName).orElse(null)));
            }
            if (!alreadyImported && importList != null) {
                PsiImportStatement importStatement = factory.createImportStatement(context.elementBcData().serviceClz());
                importList.add((PsiElement)importStatement);
            }
        }
        return EnumBcUtil.getEnumBc(context.elementBcData().bcEnumName(), context.module().getProject(), context.module()).orElse(null);
    }

    @Override
    public PsiElement getterElement(ElementGenerationContext context) {
        return context.elementBcData().bcEnum();
    }

    @Override
    public void setterElement(ElementGenerationContext context, PsiElement element) {
        if (!(element instanceof PsiEnumConstant)) {
            throw new PlatformValidationException("Generate not available", null, new IllegalStateException("Incorrect element type, expected enum constant, actual: " + String.valueOf(element)), context.module().getProject(), MessageType.INFO, AllIcons.General.Warning);
        }
        PsiEnumConstant psiEnumConstant = (PsiEnumConstant)element;
        context.elementBcData().setBcEnum(psiEnumConstant);
    }
}

