/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.wigdet.bc.service.generator;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.cxbox.intellij.community.exception.PlatformValidationException;
import org.cxbox.intellij.community.wigdet.bc.service.TemplateProperties;
import org.cxbox.intellij.community.wigdet.bc.service.generator.ElementGenerationContext;
import org.cxbox.intellij.community.wigdet.bc.service.generator.ServicePsiElementGenerator;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public abstract class AbstractBcServicePsiElementGenerator
implements ServicePsiElementGenerator<ElementGenerationContext> {
    @Override
    public PsiElement generateElement(ElementGenerationContext context) {
        return this.createFromTemplate(context);
    }

    @Override
    public void updateCommonPropertyContext(ElementGenerationContext context) {
        Properties properties = context.properties();
        Optional.of(context).map(ElementGenerationContext::elementBcData).map(ElementGenerationContext.ElementBcData::entityClz).ifPresent(clz -> properties.setProperty(TemplateProperties.ENTITY_FQN.name(), clz.getQualifiedName()));
        Optional.of(context).map(ElementGenerationContext::elementBcData).map(ElementGenerationContext.ElementBcData::metaClz).ifPresent(clz -> properties.setProperty(TemplateProperties.META_FQN.name(), clz.getQualifiedName()));
        Optional.of(context).map(ElementGenerationContext::elementBcData).map(ElementGenerationContext.ElementBcData::dtoClz).ifPresent(clz -> properties.setProperty(TemplateProperties.DTO_FQN.name(), clz.getQualifiedName()));
        Optional.of(context).map(ElementGenerationContext::elementBcData).map(ElementGenerationContext.ElementBcData::repoClz).ifPresent(clz -> properties.setProperty(TemplateProperties.REPO_FQN.name(), clz.getQualifiedName()));
        Optional.of(context).map(ElementGenerationContext::elementBcData).map(ElementGenerationContext.ElementBcData::serviceClz).ifPresent(clz -> properties.setProperty(TemplateProperties.SERVICE_NAME.name(), clz.getName()));
        Optional.of(context).map(ElementGenerationContext::elementBcData).map(ElementGenerationContext.ElementBcData::daoClz).ifPresent(clz -> properties.setProperty(TemplateProperties.DAO_FQN.name(), clz.getName()));
        Optional.of(context).map(ElementGenerationContext::elementBcData).map(ElementGenerationContext.ElementBcData::parentBcEnum).ifPresent(clz -> properties.setProperty(TemplateProperties.PARENT_BC.name(), clz.getName()));
    }

    @Override
    public PsiElement updateElement(ElementGenerationContext context) {
        return null;
    }

    @Override
    public void setCustomProperties(ElementGenerationContext context) {
    }

    @Override
    public boolean isApplicable(ElementGenerationContext elementGenerationContext) {
        return true;
    }

    protected PsiDirectory createPackage(PsiDirectory root, String qualifiedName) {
        PsiDirectory current = root;
        for (String part : qualifiedName.split("\\.")) {
            PsiDirectory sub = current.findSubdirectory(part);
            current = sub != null ? sub : current.createSubdirectory(part);
        }
        return current;
    }

    protected VirtualFile getSourceRoot(Module module) {
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
        List sourceRoots = moduleRootManager.getSourceRoots((JpsModuleSourceRootType)JavaSourceRootType.SOURCE);
        return sourceRoots.stream().filter(sr -> sr.getName().equals("java")).findFirst().orElseGet(() -> (VirtualFile)sourceRoots.get(0));
    }

    protected PsiElement createFromTemplate(ElementGenerationContext context) {
        try {
            Properties properties = context.properties();
            String packageName = String.valueOf(properties.get(TemplateProperties.PACKAGE_NAME.name()));
            String templateName = properties.getProperty(TemplateProperties.FILE_TEMPLATE_NAME.name());
            String fileName = properties.getProperty(TemplateProperties.FILE_NAME.name());
            FileTemplate template = FileTemplateManager.getInstance((Project)context.module().getProject()).getJ2eeTemplate(templateName);
            Module module = AbstractBcServicePsiElementGenerator.getModuleForPsiPackage(JavaPsiFacade.getInstance((Project)context.module().getProject()).findPackage(packageName), context.module().getProject());
            VirtualFile sourceRoot = this.getSourceRoot(module);
            PsiDirectory psiDirectory = this.createPackage(PsiManager.getInstance((Project)module.getProject()).findDirectory(sourceRoot), packageName);
            return FileTemplateUtil.createFromTemplate((FileTemplate)template, (String)fileName, (Properties)properties, (PsiDirectory)psiDirectory);
        }
        catch (Exception e) {
            throw new PlatformValidationException("Cannot create " + context.properties().getProperty(TemplateProperties.FILE_NAME.name()), null, context.module().getProject());
        }
    }

    public static Module getModuleForPsiPackage(PsiPackage psiPackage, Project project) {
        PsiDirectory[] dirs;
        if (psiPackage == null) {
            return null;
        }
        for (PsiDirectory dir : dirs = psiPackage.getDirectories(GlobalSearchScope.projectScope((Project)project))) {
            VirtualFile vf = dir.getVirtualFile();
            Module module = ModuleUtilCore.findModuleForFile((VirtualFile)vf, (Project)project);
            if (module == null) continue;
            return module;
        }
        return null;
    }
}

