/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.common.util;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiUtil;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.cxbox.intellij.community.common.Cache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataResponseDTOUtil {
    @Nullable
    public static PsiMethod getDtoConstructorMapper(@Nullable PsiClass dtoPsiClass, @Nullable PsiClass entityPsiClass) {
        if (dtoPsiClass == null || entityPsiClass == null) {
            return null;
        }
        return Arrays.stream(dtoPsiClass.getConstructors()).filter(constructor -> {
            PsiParameterList parameterList = constructor.getParameterList();
            if (parameterList.getParameters().length != 1) {
                return false;
            }
            PsiParameter parameter = parameterList.getParameter(0);
            PsiType parameterType = parameter.getType();
            PsiClass parameterClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)parameterType);
            if (parameterClass == null) {
                return false;
            }
            PsiManager manager = parameterClass.getManager();
            return parameterClass.isInheritor(entityPsiClass, true) || manager.areElementsEquivalent((PsiElement)entityPsiClass, (PsiElement)parameterClass);
        }).findFirst().orElse(null);
    }

    public static void addLastStatementToDtoConstructorMapper(@NotNull Project project, PsiMethod dtoConstructorMapper, Function<DtoConstructorprms, PsiStatement> entityParamToStatment) {
        if (project == null) {
            DataResponseDTOUtil.$$$reportNull$$$0(0);
        }
        String entityParam = dtoConstructorMapper.getParameterList().getParameter(0).getName();
        DtoConstructorprms prms = new DtoConstructorprms();
        prms.setEntity(entityParam);
        PsiStatement statement = entityParamToStatment.apply(prms);
        JavaCodeStyleManager instance = JavaCodeStyleManager.getInstance((Project)project);
        PsiJavaToken rBrace = dtoConstructorMapper.getBody().getRBrace();
        PsiElement newStatement = dtoConstructorMapper.getBody().addBefore((PsiElement)statement, (PsiElement)rBrace);
        instance.shortenClassReferences(newStatement);
        CodeStyleManager.getInstance((Project)project).reformat((PsiElement)dtoConstructorMapper.getContainingFile());
    }

    public static void addFieldToDtoMetaModel(@NotNull Project project, @NotNull Module module, PsiClass dtoPsiClass, PsiClass dtoMetaModelClass, @Nullable String fieldName, @Nullable PsiType dtoFieldTypeByName) {
        if (project == null) {
            DataResponseDTOUtil.$$$reportNull$$$0(1);
        }
        if (module == null) {
            DataResponseDTOUtil.$$$reportNull$$$0(2);
        }
        if (fieldName != null && dtoFieldTypeByName != null) {
            PsiElementFactory dtoElementFactory = JavaPsiFacade.getElementFactory((Project)project);
            String s = "public static final " + Cache.getPlatformRootPackageWithoutDot(project, module) + ".constgen.DtoField<" + dtoPsiClass.getQualifiedName() + ", " + dtoFieldTypeByName.getCanonicalText() + "> " + fieldName + " = new " + Cache.getPlatformRootPackageWithoutDot(project, module) + ".constgen.DtoField(\"" + fieldName + "\");";
            PsiField dtoField = dtoElementFactory.createFieldFromText(s, null);
            PsiField alreadyExistingDtoField = dtoMetaModelClass.findFieldByName(fieldName, true);
            if (alreadyExistingDtoField == null) {
                PsiElement newDtoField = dtoMetaModelClass.add((PsiElement)dtoField);
                JavaCodeStyleManager instance = JavaCodeStyleManager.getInstance((Project)dtoMetaModelClass.getProject());
                instance.shortenClassReferences(newDtoField);
                CodeStyleManager.getInstance((Project)project).reformat((PsiElement)dtoMetaModelClass.getContainingFile());
            }
        }
    }

    public static void addEntityToDtoFieldMapping(@NotNull Project project, PsiMethod dtoConstructorMapper, @NotNull List<Function<DtoConstructorprms, String>> producers, PsiElementFactory entityElementFactory) {
        if (project == null) {
            DataResponseDTOUtil.$$$reportNull$$$0(3);
        }
        if (producers == null) {
            DataResponseDTOUtil.$$$reportNull$$$0(4);
        }
        if (!producers.isEmpty()) {
            producers.forEach(producer -> DataResponseDTOUtil.addLastStatementToDtoConstructorMapper(project, dtoConstructorMapper, prms -> entityElementFactory.createStatementFromText((String)producer.apply(prms), null)));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producers";
                break;
            }
        }
        objectArray2[1] = "org/cxbox/intellij/community/common/util/DataResponseDTOUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addLastStatementToDtoConstructorMapper";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addFieldToDtoMetaModel";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addEntityToDtoFieldMapping";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class DtoConstructorprms {
        private String entity;

        public String getEntity() {
            return this.entity;
        }

        public void setEntity(String entity) {
            this.entity = entity;
        }
    }
}

