/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.view.name;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import java.util.List;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.cxbox.intellij.community.common.conf.JScreen;
import org.cxbox.intellij.community.common.conf.JView;
import org.cxbox.intellij.community.common.util.JsonFacade;
import org.cxbox.intellij.community.common.util.QuickFixUtils;
import org.cxbox.intellij.community.language.SimpleNamedElement;
import org.jetbrains.annotations.NotNull;

public final class ViewIsNeverUsedInspection
extends LocalInspectionTool {
    @NotNull
    public String getShortName() {
        return "ViewIsNeverUsedInspection";
    }

    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            ViewIsNeverUsedInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            ViewIsNeverUsedInspection.$$$reportNull$$$0(1);
        }
        if (!(file instanceof JsonFile)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        JsonFile viewFile = (JsonFile)file;
        if (!file.getName().endsWith(".view.json")) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        JsonObject viewFileTopLevelObject = JsonFacade.getTopLevelObject(viewFile);
        JsonStringLiteral viewName = JsonFacade.safeGetPropertyValueOfType(viewFileTopLevelObject, JView.NAME);
        SmartList descriptors = new SmartList();
        if (viewName != null) {
            Project project = viewFile.getProject();
            Module module = ModuleUtil.findModuleForPsiElement((PsiElement)file);
            if (module == null) {
                return null;
            }
            SimpleNamedElement viewFileInjectedName = JView.getViewFileInjectedName(project, module, viewName);
            List<ImmutablePair<JsonFile, PsiElement>> allScreensByViewName = JScreen.getAllScreensByViewName(project, module, (PsiElement)viewFileInjectedName);
            if (allScreensByViewName.isEmpty()) {
                descriptors.add(manager.createProblemDescriptor((PsiElement)viewName, new TextRange(1, viewName.getValue().length() + 1), "View is never used", ProblemHighlightType.LIKE_UNUSED_SYMBOL, true, new LocalQuickFix[]{new Fix(viewName.getValue())}));
            }
        }
        return descriptors.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
        }
        objectArray[1] = "org/cxbox/intellij/community/view/name/ViewIsNeverUsedInspection";
        objectArray[2] = "checkFile";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private record Fix(String toBeDeletedViewName) implements LocalQuickFix
    {
        public boolean availableInBatchMode() {
            return false;
        }

        @NotNull
        public String getName() {
            String string = "(2) Remove unused view " + this.toBeDeletedViewName;
            if (string == null) {
                Fix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            return "Not used";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                Fix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                Fix.$$$reportNull$$$0(2);
            }
            QuickFixUtils.safeDeleteFileIfPossible(project, descriptor.getPsiElement());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/cxbox/intellij/community/view/name/ViewIsNeverUsedInspection$Fix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/cxbox/intellij/community/view/name/ViewIsNeverUsedInspection$Fix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

