/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.language;

import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import java.util.List;
import org.cxbox.intellij.community.language.SimpleSyntaxHighlighter;
import org.cxbox.intellij.community.language.SimpleUtil;
import org.cxbox.intellij.community.language.psi.SimpleProperty;
import org.jetbrains.annotations.NotNull;

public class SimpleAnnotator
implements Annotator {
    public static final String SIMPLE_PREFIX_STR = "simple";
    public static final String SIMPLE_SEPARATOR_STR = ":";

    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        String value;
        if (element == null) {
            SimpleAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            SimpleAnnotator.$$$reportNull$$$0(1);
        }
        if (!(element instanceof PsiLiteralExpression)) {
            return;
        }
        PsiLiteralExpression literalExpression = (PsiLiteralExpression)element;
        String string = value = literalExpression.getValue() instanceof String ? (String)literalExpression.getValue() : null;
        if (value == null || !value.startsWith("simple:")) {
            return;
        }
        TextRange prefixRange = TextRange.from((int)(element.getTextRange().getStartOffset() + 1), (int)SIMPLE_PREFIX_STR.length());
        TextRange separatorRange = TextRange.from((int)prefixRange.getEndOffset(), (int)SIMPLE_SEPARATOR_STR.length());
        TextRange keyRange = new TextRange(separatorRange.getEndOffset(), element.getTextRange().getEndOffset() - 1);
        String possibleProperties = value.substring(SIMPLE_PREFIX_STR.length() + SIMPLE_SEPARATOR_STR.length());
        Project project = element.getProject();
        List<SimpleProperty> properties = SimpleUtil.findProperties(project, possibleProperties);
        Annotation keyAnnotation = holder.createInfoAnnotation(prefixRange, null);
        keyAnnotation.setTextAttributes(DefaultLanguageHighlighterColors.KEYWORD);
        Annotation separatorAnnotation = holder.createInfoAnnotation(separatorRange, null);
        separatorAnnotation.setTextAttributes(SimpleSyntaxHighlighter.SEPARATOR);
        if (properties.isEmpty()) {
            Annotation badProperty = holder.createErrorAnnotation(keyRange, "Unresolved property");
            badProperty.setTextAttributes(SimpleSyntaxHighlighter.BAD_CHARACTER);
        } else {
            Annotation annotation = holder.createInfoAnnotation(keyRange, null);
            annotation.setTextAttributes(SimpleSyntaxHighlighter.VALUE);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "org/cxbox/intellij/community/language/SimpleAnnotator";
        objectArray[2] = "annotate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

