/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.wigdet.fields.field.generator;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.json.psi.JsonElement;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.StringUtils;
import org.cxbox.intellij.community.common.Cache;
import org.cxbox.intellij.community.common.conf.JWidget;
import org.cxbox.intellij.community.common.util.BcUtil;
import org.cxbox.intellij.community.common.util.ClassCommon;
import org.cxbox.intellij.community.common.util.DataResponseDTOUtil;
import org.cxbox.intellij.community.common.util.DtoConstructorUtil;
import org.cxbox.intellij.community.common.util.DtoMetaModelUtil;
import org.cxbox.intellij.community.common.util.EnumBcUtil;
import org.cxbox.intellij.community.common.util.EnumConstant;
import org.cxbox.intellij.community.common.util.FieldMetaBuilderUtil;
import org.cxbox.intellij.community.common.util.FieldWithAnnotation;
import org.cxbox.intellij.community.common.util.JavaFacade;
import org.cxbox.intellij.community.common.util.JavaUtil;
import org.cxbox.intellij.community.common.util.JsonElementGenerator;
import org.cxbox.intellij.community.common.util.JsonFacade;
import org.cxbox.intellij.community.common.util.SearchScopeUtil;
import org.cxbox.intellij.community.common.util.VersionAwareServiceUtils;
import org.cxbox.intellij.community.exception.PlatformValidationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000 p2\u00020\u0001:\u0002opB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\\\u001a\u00020]2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010^\u001a\u00020\u0005H\u0002J\u000e\u0010_\u001a\b\u0012\u0004\u0012\u00020\u00130`H&J\b\u0010a\u001a\u00020bH&J\u0006\u0010c\u001a\u00020]J\u0014\u0010d\u001a\b\u0012\u0004\u0012\u00020\u001c0`2\u0006\u0010e\u001a\u00020bJ \u0010f\u001a\u00020]2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010g\u001a\u00020%2\b\u0010*\u001a\u0004\u0018\u00010\u0013J \u0010h\u001a\u00020]2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010g\u001a\u00020%2\b\u0010*\u001a\u0004\u0018\u00010\u0013J\u000e\u0010i\u001a\u00020\u00132\u0006\u0010-\u001a\u00020\u0013J\u0010\u0010j\u001a\u0004\u0018\u00010k2\u0006\u0010/\u001a\u00020kJ\u000e\u0010l\u001a\u00020\u00132\u0006\u0010m\u001a\u00020kJ\u000e\u0010n\u001a\u00020\u00132\u0006\u0010/\u001a\u00020kR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0013X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0015\"\u0004\b\u001a\u0010\u0017R\u001a\u0010\u001b\u001a\u00020\u001cX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\u001cX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001e\"\u0004\b#\u0010 R\u001a\u0010$\u001a\u00020%X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u001a\u0010*\u001a\u00020\u0013X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\u0015\"\u0004\b,\u0010\u0017R\u001a\u0010-\u001a\u00020\u0013X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010\u0015\"\u0004\b/\u0010\u0017R\u001a\u00100\u001a\u00020\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R\u001a\u00105\u001a\u00020\u0013X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u0010\u0015\"\u0004\b7\u0010\u0017R\u001a\u00108\u001a\u000209X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=R\u001a\u0010>\u001a\u00020\u001cX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010\u001e\"\u0004\b@\u0010 R\u001a\u0010A\u001a\u00020\u0013X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010\u0015\"\u0004\bC\u0010\u0017R\u001a\u0010D\u001a\u00020\u001cX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bE\u0010\u001e\"\u0004\bF\u0010 R\u001a\u0010G\u001a\u00020HX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bI\u0010J\"\u0004\bK\u0010LR\u001a\u0010M\u001a\u00020\u001cX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bN\u0010\u001e\"\u0004\bO\u0010 R\u001a\u0010P\u001a\u00020HX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bQ\u0010J\"\u0004\bR\u0010LR\u001a\u0010S\u001a\u00020HX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bT\u0010J\"\u0004\bU\u0010LR\u001c\u0010V\u001a\u0004\u0018\u00010HX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bW\u0010J\"\u0004\bX\u0010LR\u001c\u0010Y\u001a\u0004\u0018\u00010\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bZ\u0010\u001e\"\u0004\b[\u0010 \u00a8\u0006q"}, d2={"Lorg/cxbox/intellij/community/wigdet/fields/field/generator/AbstractVersionAwareWidgetNewFieldGenerator;", "", "prj", "Lcom/intellij/openapi/project/Project;", "tagValue", "Lcom/intellij/json/psi/JsonStringLiteral;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/json/psi/JsonStringLiteral;)V", "getPrj", "()Lcom/intellij/openapi/project/Project;", "setPrj", "(Lcom/intellij/openapi/project/Project;)V", "module", "Lcom/intellij/openapi/module/Module;", "getModule", "()Lcom/intellij/openapi/module/Module;", "setModule", "(Lcom/intellij/openapi/module/Module;)V", "pkg", "", "getPkg", "()Ljava/lang/String;", "setPkg", "(Ljava/lang/String;)V", "persistenceVersion", "getPersistenceVersion", "setPersistenceVersion", "dtoPsiClz", "Lcom/intellij/psi/PsiClass;", "getDtoPsiClz", "()Lcom/intellij/psi/PsiClass;", "setDtoPsiClz", "(Lcom/intellij/psi/PsiClass;)V", "entityPsiClz", "getEntityPsiClz", "setEntityPsiClz", "keyProp", "Lcom/intellij/json/psi/JsonProperty;", "getKeyProp", "()Lcom/intellij/json/psi/JsonProperty;", "setKeyProp", "(Lcom/intellij/json/psi/JsonProperty;)V", "fieldName", "getFieldName", "setFieldName", "type", "getType", "setType", "bcJsonStringLiteral", "getBcJsonStringLiteral", "()Lcom/intellij/json/psi/JsonStringLiteral;", "setBcJsonStringLiteral", "(Lcom/intellij/json/psi/JsonStringLiteral;)V", "bc", "getBc", "setBc", "bcPsiElement", "Lcom/intellij/psi/PsiEnumConstant;", "getBcPsiElement", "()Lcom/intellij/psi/PsiEnumConstant;", "setBcPsiElement", "(Lcom/intellij/psi/PsiEnumConstant;)V", "bcEnumServiceClass", "getBcEnumServiceClass", "setBcEnumServiceClass", "dtoMetaPsiClzFQN", "getDtoMetaPsiClzFQN", "setDtoMetaPsiClzFQN", "versionAwareClass", "getVersionAwareClass", "setVersionAwareClass", "doUpdateEntityMethod", "Lcom/intellij/psi/PsiMethod;", "getDoUpdateEntityMethod", "()Lcom/intellij/psi/PsiMethod;", "setDoUpdateEntityMethod", "(Lcom/intellij/psi/PsiMethod;)V", "fieldMetaImplClass", "getFieldMetaImplClass", "setFieldMetaImplClass", "buildRowDependentMetaMethod", "getBuildRowDependentMetaMethod", "setBuildRowDependentMetaMethod", "buildRowIndependentMetaMethod", "getBuildRowIndependentMetaMethod", "setBuildRowIndependentMetaMethod", "dtoConstructorMapper", "getDtoConstructorMapper", "setDtoConstructorMapper", "dtoBeanMapper", "getDtoBeanMapper", "setDtoBeanMapper", "initAndValidate", "", "keyValue", "fieldTypes", "", "prepareFieldCreation", "Lorg/cxbox/intellij/community/wigdet/fields/field/generator/AbstractVersionAwareWidgetNewFieldGenerator$Result;", "createField", "generateCode", "result", "renameKeyTagIfNeeded", "tagProperty", "fillLabelTitleTag", "fromPrimitiveToObject", "getGenericParameterType", "Lcom/intellij/psi/PsiType;", "getFqnWithGenericFqnType", "fieldType", "getRawType", "Result", "Companion", "cxbox-intellij-plugin"})
@SourceDebugExtension(value={"SMAP\nAbstractVersionAwareWidgetNewFieldGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractVersionAwareWidgetNewFieldGenerator.kt\norg/cxbox/intellij/community/wigdet/fields/field/generator/AbstractVersionAwareWidgetNewFieldGenerator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,443:1\n1#2:444\n*E\n"})
public abstract class AbstractVersionAwareWidgetNewFieldGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Project prj;
    public Module module;
    public String pkg;
    public String persistenceVersion;
    public PsiClass dtoPsiClz;
    public PsiClass entityPsiClz;
    public JsonProperty keyProp;
    public String fieldName;
    public String type;
    public JsonStringLiteral bcJsonStringLiteral;
    public String bc;
    public PsiEnumConstant bcPsiElement;
    public PsiClass bcEnumServiceClass;
    public String dtoMetaPsiClzFQN;
    public PsiClass versionAwareClass;
    public PsiMethod doUpdateEntityMethod;
    public PsiClass fieldMetaImplClass;
    public PsiMethod buildRowDependentMetaMethod;
    public PsiMethod buildRowIndependentMetaMethod;
    @Nullable
    private PsiMethod dtoConstructorMapper;
    @Nullable
    private PsiClass dtoBeanMapper;
    @NotNull
    private static final Map<String, String> SUPPORT_TYPES_FOR_PICK_LIST_AND_MULTIVALUE;
    @NotNull
    private static final Map<String, String> PROVIDER_TYPES;

    public AbstractVersionAwareWidgetNewFieldGenerator(@NotNull Project prj, @NotNull JsonStringLiteral tagValue) {
        Intrinsics.checkNotNullParameter((Object)prj, (String)"prj");
        Intrinsics.checkNotNullParameter((Object)tagValue, (String)"tagValue");
        this.prj = prj;
        this.initAndValidate(this.prj, tagValue);
    }

    @NotNull
    public final Project getPrj() {
        return this.prj;
    }

    public final void setPrj(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"<set-?>");
        this.prj = project;
    }

    @NotNull
    public final Module getModule() {
        Module module = this.module;
        if (module != null) {
            return module;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"module");
        return null;
    }

    public final void setModule(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"<set-?>");
        this.module = module;
    }

    @NotNull
    public final String getPkg() {
        String string = this.pkg;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"pkg");
        return null;
    }

    public final void setPkg(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.pkg = string;
    }

    @NotNull
    public final String getPersistenceVersion() {
        String string = this.persistenceVersion;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"persistenceVersion");
        return null;
    }

    public final void setPersistenceVersion(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.persistenceVersion = string;
    }

    @NotNull
    public final PsiClass getDtoPsiClz() {
        PsiClass psiClass = this.dtoPsiClz;
        if (psiClass != null) {
            return psiClass;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"dtoPsiClz");
        return null;
    }

    public final void setDtoPsiClz(@NotNull PsiClass psiClass) {
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"<set-?>");
        this.dtoPsiClz = psiClass;
    }

    @NotNull
    public final PsiClass getEntityPsiClz() {
        PsiClass psiClass = this.entityPsiClz;
        if (psiClass != null) {
            return psiClass;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"entityPsiClz");
        return null;
    }

    public final void setEntityPsiClz(@NotNull PsiClass psiClass) {
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"<set-?>");
        this.entityPsiClz = psiClass;
    }

    @NotNull
    public final JsonProperty getKeyProp() {
        JsonProperty jsonProperty = this.keyProp;
        if (jsonProperty != null) {
            return jsonProperty;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"keyProp");
        return null;
    }

    public final void setKeyProp(@NotNull JsonProperty jsonProperty) {
        Intrinsics.checkNotNullParameter((Object)jsonProperty, (String)"<set-?>");
        this.keyProp = jsonProperty;
    }

    @NotNull
    public final String getFieldName() {
        String string = this.fieldName;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"fieldName");
        return null;
    }

    public final void setFieldName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.fieldName = string;
    }

    @NotNull
    public final String getType() {
        String string = this.type;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"type");
        return null;
    }

    public final void setType(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.type = string;
    }

    @NotNull
    public final JsonStringLiteral getBcJsonStringLiteral() {
        JsonStringLiteral jsonStringLiteral = this.bcJsonStringLiteral;
        if (jsonStringLiteral != null) {
            return jsonStringLiteral;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"bcJsonStringLiteral");
        return null;
    }

    public final void setBcJsonStringLiteral(@NotNull JsonStringLiteral jsonStringLiteral) {
        Intrinsics.checkNotNullParameter((Object)jsonStringLiteral, (String)"<set-?>");
        this.bcJsonStringLiteral = jsonStringLiteral;
    }

    @NotNull
    public final String getBc() {
        String string = this.bc;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"bc");
        return null;
    }

    public final void setBc(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.bc = string;
    }

    @NotNull
    public final PsiEnumConstant getBcPsiElement() {
        PsiEnumConstant psiEnumConstant = this.bcPsiElement;
        if (psiEnumConstant != null) {
            return psiEnumConstant;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"bcPsiElement");
        return null;
    }

    public final void setBcPsiElement(@NotNull PsiEnumConstant psiEnumConstant) {
        Intrinsics.checkNotNullParameter((Object)psiEnumConstant, (String)"<set-?>");
        this.bcPsiElement = psiEnumConstant;
    }

    @NotNull
    public final PsiClass getBcEnumServiceClass() {
        PsiClass psiClass = this.bcEnumServiceClass;
        if (psiClass != null) {
            return psiClass;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"bcEnumServiceClass");
        return null;
    }

    public final void setBcEnumServiceClass(@NotNull PsiClass psiClass) {
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"<set-?>");
        this.bcEnumServiceClass = psiClass;
    }

    @NotNull
    public final String getDtoMetaPsiClzFQN() {
        String string = this.dtoMetaPsiClzFQN;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"dtoMetaPsiClzFQN");
        return null;
    }

    public final void setDtoMetaPsiClzFQN(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.dtoMetaPsiClzFQN = string;
    }

    @NotNull
    public final PsiClass getVersionAwareClass() {
        PsiClass psiClass = this.versionAwareClass;
        if (psiClass != null) {
            return psiClass;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"versionAwareClass");
        return null;
    }

    public final void setVersionAwareClass(@NotNull PsiClass psiClass) {
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"<set-?>");
        this.versionAwareClass = psiClass;
    }

    @NotNull
    public final PsiMethod getDoUpdateEntityMethod() {
        PsiMethod psiMethod = this.doUpdateEntityMethod;
        if (psiMethod != null) {
            return psiMethod;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"doUpdateEntityMethod");
        return null;
    }

    public final void setDoUpdateEntityMethod(@NotNull PsiMethod psiMethod) {
        Intrinsics.checkNotNullParameter((Object)psiMethod, (String)"<set-?>");
        this.doUpdateEntityMethod = psiMethod;
    }

    @NotNull
    public final PsiClass getFieldMetaImplClass() {
        PsiClass psiClass = this.fieldMetaImplClass;
        if (psiClass != null) {
            return psiClass;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"fieldMetaImplClass");
        return null;
    }

    public final void setFieldMetaImplClass(@NotNull PsiClass psiClass) {
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"<set-?>");
        this.fieldMetaImplClass = psiClass;
    }

    @NotNull
    public final PsiMethod getBuildRowDependentMetaMethod() {
        PsiMethod psiMethod = this.buildRowDependentMetaMethod;
        if (psiMethod != null) {
            return psiMethod;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"buildRowDependentMetaMethod");
        return null;
    }

    public final void setBuildRowDependentMetaMethod(@NotNull PsiMethod psiMethod) {
        Intrinsics.checkNotNullParameter((Object)psiMethod, (String)"<set-?>");
        this.buildRowDependentMetaMethod = psiMethod;
    }

    @NotNull
    public final PsiMethod getBuildRowIndependentMetaMethod() {
        PsiMethod psiMethod = this.buildRowIndependentMetaMethod;
        if (psiMethod != null) {
            return psiMethod;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"buildRowIndependentMetaMethod");
        return null;
    }

    public final void setBuildRowIndependentMetaMethod(@NotNull PsiMethod psiMethod) {
        Intrinsics.checkNotNullParameter((Object)psiMethod, (String)"<set-?>");
        this.buildRowIndependentMetaMethod = psiMethod;
    }

    @Nullable
    public final PsiMethod getDtoConstructorMapper() {
        return this.dtoConstructorMapper;
    }

    public final void setDtoConstructorMapper(@Nullable PsiMethod psiMethod) {
        this.dtoConstructorMapper = psiMethod;
    }

    @Nullable
    public final PsiClass getDtoBeanMapper() {
        return this.dtoBeanMapper;
    }

    public final void setDtoBeanMapper(@Nullable PsiClass psiClass) {
        this.dtoBeanMapper = psiClass;
    }

    private final void initAndValidate(Project prj, JsonStringLiteral keyValue) {
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)((PsiElement)keyValue));
        if (module == null) {
            throw new PlatformValidationException("cannot determine project module for <a href=\"1\">key</a>", (NavigatablePsiElement)keyValue, prj);
        }
        this.setModule(module);
        this.setPkg(Cache.getPlatformRootPackageWithoutDot(prj, this.getModule()));
        this.setPersistenceVersion(Cache.getPersistenceVersionWithoutDot(prj, this.getModule()));
        JsonProperty jsonProperty = JsonFacade.getParentOfType((PsiElement)keyValue, JsonProperty.class);
        if (jsonProperty == null) {
            throw new PlatformValidationException("<a href=\"1\">key</a> must belong to a valid json property", (NavigatablePsiElement)keyValue, prj);
        }
        this.setKeyProp(jsonProperty);
        this.setFieldName(JavaFacade.convertToJavaIdentifier(JsonFacade.getValue(keyValue)));
        if (StringsKt.isBlank((CharSequence)((Object)StringsKt.trim((CharSequence)this.getFieldName())).toString())) {
            throw new PlatformValidationException("<a href=\"1\">key</a> must not be empty, but was key = \"" + this.getFieldName(), (NavigatablePsiElement)keyValue, prj);
        }
        String string = JWidget.getFieldType(this.getKeyProp());
        if (string == null) {
            throw new PlatformValidationException("cannot determine <a href=\"1\">field</a> type", (NavigatablePsiElement)this.getKeyProp(), prj);
        }
        this.setType(string);
        JsonStringLiteral jsonStringLiteral = BcUtil.getNearestBc((JsonElement)keyValue);
        if (jsonStringLiteral == null) {
            throw new PlatformValidationException("cannot determine bc tag or value for <a href=\"1\">key</a> in current widget", (NavigatablePsiElement)this.getKeyProp(), prj);
        }
        this.setBcJsonStringLiteral(jsonStringLiteral);
        this.setBc(JsonFacade.getValue(this.getBcJsonStringLiteral()));
        if (StringsKt.isBlank((CharSequence)((Object)StringsKt.trim((CharSequence)this.getBc())).toString())) {
            throw new PlatformValidationException("widget <a href=\"1\">bc</a> must not be empty, but was bc = \"" + this.getBc(), (NavigatablePsiElement)this.getBcJsonStringLiteral(), prj);
        }
        PsiEnumConstant psiEnumConstant = (PsiEnumConstant)EnumBcUtil.getLinkAndAutocompletionByBc(this.getBc(), prj, this.getModule()).getFirst();
        if (psiEnumConstant == null) {
            throw new PlatformValidationException("cannot determine enum where <a href=\"1\">bc</a> = " + this.getBc() + " is defined", (NavigatablePsiElement)this.getBcJsonStringLiteral(), prj);
        }
        this.setBcPsiElement(psiEnumConstant);
        PsiClass psiClass = EnumBcUtil.getBcServiceClass(this.getBcPsiElement(), prj, this.getModule());
        if (psiClass == null) {
            PsiClass psiClass2 = this.getBcPsiElement().getContainingClass();
            throw new PlatformValidationException("cannot determine Service class for <a href=\"1\">bc</a> = " + this.getBc() + " in enum = " + (psiClass2 != null ? psiClass2.getQualifiedName() : null), (NavigatablePsiElement)this.getBcPsiElement(), prj);
        }
        this.setBcEnumServiceClass(psiClass);
        PsiClass psiClass3 = JavaUtil.getAnyImplementationIfInterfaceOrElseClass(this.getBcEnumServiceClass());
        if (psiClass3 == null) {
            PsiClass psiClass4 = this.getBcPsiElement().getContainingClass();
            throw new PlatformValidationException("cannot determine Implementation of <a href=\"1\">Service class</a> = " + this.getBcEnumServiceClass().getQualifiedName() + " for bc = " + this.getBc() + " defined in enum = " + (psiClass4 != null ? psiClass4.getQualifiedName() : null), (NavigatablePsiElement)this.getBcEnumServiceClass(), prj);
        }
        this.setVersionAwareClass(psiClass3);
        PsiMethod psiMethod = VersionAwareServiceUtils.getDoUpdateEntityMethod(this.getBcEnumServiceClass());
        if (psiMethod == null) {
            PsiClass psiClass5 = this.getBcPsiElement().getContainingClass();
            throw new PlatformValidationException("cannot determine doUpdateEntity(..) method in <a href=\"1\">Service class</a> = " + this.getVersionAwareClass().getQualifiedName() + " for bc = " + this.getBc() + " defined in enum = " + (psiClass5 != null ? psiClass5.getQualifiedName() : null), (NavigatablePsiElement)this.getVersionAwareClass(), prj);
        }
        this.setDoUpdateEntityMethod(psiMethod);
        PsiClass psiClass6 = FieldMetaBuilderUtil.getFieldMetaImplClass(this.getBcEnumServiceClass(), this.getModule());
        if (psiClass6 == null) {
            PsiClass psiClass7 = this.getBcPsiElement().getContainingClass();
            throw new PlatformValidationException("cannot determine FieldMetaBuilder implementation for <a href=\"1\">Service class</a> = " + this.getVersionAwareClass().getQualifiedName() + " for bc = " + this.getBc() + " defined in enum = " + (psiClass7 != null ? psiClass7.getQualifiedName() : null), (NavigatablePsiElement)this.getVersionAwareClass(), prj);
        }
        this.setFieldMetaImplClass(psiClass6);
        PsiMethod psiMethod2 = FieldMetaBuilderUtil.getBuildRowDependentMetaMethod(this.getFieldMetaImplClass());
        if (psiMethod2 == null) {
            PsiClass psiClass8 = this.getBcPsiElement().getContainingClass();
            throw new PlatformValidationException("cannot determine buildRowDependentMeta(...) method in <a href=\"1\">FieldMetaBuilder class</a> = " + this.getFieldMetaImplClass().getQualifiedName() + " for Service class = " + this.getVersionAwareClass().getQualifiedName() + " for bc = " + this.getBc() + " defined in enum = " + (psiClass8 != null ? psiClass8.getQualifiedName() : null), (NavigatablePsiElement)this.getFieldMetaImplClass(), prj);
        }
        this.setBuildRowDependentMetaMethod(psiMethod2);
        PsiMethod psiMethod3 = FieldMetaBuilderUtil.getBuildRowIndependentMetaMethod(this.getFieldMetaImplClass());
        if (psiMethod3 == null) {
            PsiClass psiClass9 = this.getBcPsiElement().getContainingClass();
            throw new PlatformValidationException("cannot determine buildRowIndependentMeta(...) method in <a href=\"1\">FieldMetaBuilder class</a> = " + this.getFieldMetaImplClass().getQualifiedName() + " for Service class = " + this.getVersionAwareClass().getQualifiedName() + " for bc = " + this.getBc() + " defined in enum = " + (psiClass9 != null ? psiClass9.getQualifiedName() : null), (NavigatablePsiElement)this.getFieldMetaImplClass(), prj);
        }
        this.setBuildRowIndependentMetaMethod(psiMethod3);
        PsiClass psiClass10 = EnumBcUtil.getBcServiceDtoClass(this.getBcEnumServiceClass(), prj, this.getModule());
        if (psiClass10 == null) {
            PsiClass psiClass11 = this.getBcPsiElement().getContainingClass();
            throw new PlatformValidationException("cannot determine Dto of <a href=\"1\">Service class</a> = " + this.getBcEnumServiceClass().getQualifiedName() + " for bc = " + this.getBc() + " defined in enum = " + (psiClass11 != null ? psiClass11.getQualifiedName() : null), (NavigatablePsiElement)this.getBcEnumServiceClass(), prj);
        }
        this.setDtoPsiClz(psiClass10);
        this.setDtoMetaPsiClzFQN((String)DtoMetaModelUtil.syncDtoMetaModelClass(this.getDtoPsiClz(), JavaPsiFacade.getInstance((Project)prj), SearchScopeUtil.getModuleSearchScopeWithParentsAndChildsAndLibraries(this.getModule(), prj)).getFirst());
        PsiClass psiClass12 = EnumBcUtil.getBcServiceEntityClass(this.getBcEnumServiceClass(), prj, this.getModule());
        if (psiClass12 == null) {
            PsiClass psiClass13 = this.getBcPsiElement().getContainingClass();
            throw new PlatformValidationException("cannot determine <a href=\"1\">Entity</a> of Service = " + this.getBcEnumServiceClass().getQualifiedName() + " for bc = " + this.getBc() + " defined in enum = " + (psiClass13 != null ? psiClass13.getQualifiedName() : null), (NavigatablePsiElement)this.getBcEnumServiceClass(), prj);
        }
        this.setEntityPsiClz(psiClass12);
        this.dtoBeanMapper = DtoConstructorUtil.getDtoBeanMapper(this.getDtoPsiClz(), this.getEntityPsiClz());
        this.dtoConstructorMapper = DataResponseDTOUtil.getDtoConstructorMapper(this.getDtoPsiClz(), this.getEntityPsiClz());
        PsiClass psiClass14 = this.dtoBeanMapper;
        if (psiClass14 == null && (psiClass14 = this.dtoConstructorMapper) == null) {
            PsiClass psiClass15 = this.getBcPsiElement().getContainingClass();
            throw new PlatformValidationException("cannot determine mapper from Entity to <a href=\"1\">DTO</a> (neither Dto constructor(E entity) nor DtoConstructor<E, D> found) for dto " + this.getDtoPsiClz().getQualifiedName() + " and entity " + this.getEntityPsiClz().getQualifiedName() + " of Service = " + this.getBcEnumServiceClass().getQualifiedName() + " of bc = " + this.getBc() + " defined in enum = " + (psiClass15 != null ? psiClass15.getQualifiedName() : null), (NavigatablePsiElement)this.getDtoPsiClz(), prj);
        }
    }

    @NotNull
    public abstract List<String> fieldTypes();

    @NotNull
    public abstract Result prepareFieldCreation();

    public final void createField() {
        ApplicationManager.getApplication().runWriteAction(() -> AbstractVersionAwareWidgetNewFieldGenerator.createField$lambda$0(this));
    }

    @NotNull
    public final List<PsiClass> generateCode(@NotNull Result result) {
        PsiClass it;
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        PsiElementFactory javaEF = JavaPsiFacade.getElementFactory((Project)this.prj);
        this.renameKeyTagIfNeeded(this.prj, this.getKeyProp(), this.getFieldName());
        this.fillLabelTitleTag(this.prj, this.getKeyProp(), this.getFieldName());
        ClassCommon.addFieldWithAnnotaions(this.prj, this.getDtoPsiClz(), (List<FieldWithAnnotation>)result.getDtoFields());
        ClassCommon.addEnumConstant(this.prj, this.getBcPsiElement().getContainingClass(), (List<EnumConstant>)result.getBcEnumServiceConstants());
        ClassCommon.addFieldWithAnnotaions(this.prj, this.getEntityPsiClz(), (List<FieldWithAnnotation>)result.getEntityFields());
        VersionAwareServiceUtils.addMapDtoToEntityFieldIfChanged(this.prj, this.getDoUpdateEntityMethod(), (List<Function<VersionAwareServiceUtils.VersionAwareServiceDoUpdateEntityDto, String>>)result.getVersionAwareDoUpdate(), javaEF);
        ClassCommon.addFieldWithAnnotaions(this.prj, this.getVersionAwareClass(), (List<FieldWithAnnotation>)result.getVersionAwareFields());
        FieldMetaBuilderUtil.rowIndependentMetaEnableFilterForField(this.prj, this.getBuildRowIndependentMetaMethod(), (List<Function<FieldMetaBuilderUtil.RowIndependentMetaprms, String>>)result.getRowIndependentMeta(), javaEF);
        FieldMetaBuilderUtil.rowDependedMetaSetFieldEnabled(this.prj, this.getBuildRowDependentMetaMethod(), (List<Function<FieldMetaBuilderUtil.RowDependentMetaprms, String>>)result.getRowDependentMeta(), javaEF);
        PsiClass psiClass = this.dtoBeanMapper;
        if (psiClass != null) {
            it = psiClass;
            boolean bl = false;
            DtoConstructorUtil.addEntityToDtoFieldMapping(this.prj, (List<String>)result.getMapperBuilderPutLines(), it);
        }
        PsiMethod psiMethod = this.dtoConstructorMapper;
        if (psiMethod != null) {
            it = psiMethod;
            boolean bl = false;
            DataResponseDTOUtil.addEntityToDtoFieldMapping(this.prj, (PsiMethod)it, (List<Function<DataResponseDTOUtil.DtoConstructorprms, String>>)result.getDtoConstructorMapFormEntity(), javaEF);
        }
        GlobalSearchScope globalSearchScope = SearchScopeUtil.getModuleSearchScopeWithParentsAndChildsAndLibraries(this.getModule(), this.prj);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getModuleSearchScopeWith\u2026ndChildsAndLibraries(...)");
        GlobalSearchScope scp = globalSearchScope;
        if (!((Boolean)DtoMetaModelUtil.syncDtoMetaModelClass(this.getDtoPsiClz(), JavaPsiFacade.getInstance((Project)this.prj), scp).getSecond()).booleanValue()) {
            JavaFacade.showSuccessNotification(this.prj, "Success! Remember: do 'mvn clean install' before Application run (to regenerate DTO_ classes)");
        } else {
            JavaFacade.showSuccessNotification(this.prj, "Success!");
        }
        return CollectionsKt.listOf((Object)this.getDtoPsiClz());
    }

    public final void renameKeyTagIfNeeded(@NotNull Project prj, @NotNull JsonProperty tagProperty, @Nullable String fieldName) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)prj, (String)"prj");
            Intrinsics.checkNotNullParameter((Object)tagProperty, (String)"tagProperty");
            if (fieldName == null) {
                return;
            }
            JsonObject jsonObject = JsonFacade.getParentOfType((PsiElement)tagProperty, JsonObject.class);
            if (jsonObject == null) {
                return;
            }
            JsonObject fieldObject = jsonObject;
            JsonStringLiteral keyValue = JsonFacade.safeGetPropertyValueOfType(fieldObject, JWidget.FIELDS_KEY);
            JsonValue jsonValue = new JsonElementGenerator(prj).createValue("\"" + fieldName + "\"");
            Intrinsics.checkNotNullExpressionValue((Object)jsonValue, (String)"createValue(...)");
            JsonValue value = jsonValue;
            String string = JsonFacade.safeGetValueAsString((PsiElement)keyValue);
            boolean bl = string != null ? !string.equals(fieldName) : false;
            if (!bl) break block3;
            JsonStringLiteral jsonStringLiteral = keyValue;
            if (jsonStringLiteral != null) {
                jsonStringLiteral.replace((PsiElement)value);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void fillLabelTitleTag(@NotNull Project prj, @NotNull JsonProperty tagProperty, @Nullable String fieldName) {
        block15: {
            JsonValue value;
            JsonStringLiteral labelKeyValue;
            block14: {
                block13: {
                    JsonStringLiteral titleKeyValue;
                    block12: {
                        String string;
                        Intrinsics.checkNotNullParameter((Object)prj, (String)"prj");
                        Intrinsics.checkNotNullParameter((Object)tagProperty, (String)"tagProperty");
                        if (fieldName == null) {
                            return;
                        }
                        JsonObject jsonObject = JsonFacade.getParentOfType((PsiElement)tagProperty, JsonObject.class);
                        if (jsonObject == null) {
                            return;
                        }
                        JsonObject fieldObject = jsonObject;
                        titleKeyValue = JsonFacade.safeGetPropertyValueOfType(fieldObject, JWidget.TITLE);
                        labelKeyValue = JsonFacade.safeGetPropertyValueOfType(fieldObject, JWidget.LABEL);
                        String string2 = StringUtils.join((Object[])StringUtils.splitByCharacterTypeCamelCase((String)fieldName), (String)" ");
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"join(...)");
                        String string3 = string2;
                        if (((CharSequence)string3).length() > 0) {
                            String string4;
                            void it;
                            char c = string3.charAt(0);
                            StringBuilder stringBuilder = new StringBuilder();
                            boolean bl = false;
                            if (Character.isLowerCase((char)it)) {
                                Locale locale = Locale.getDefault();
                                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                                string4 = CharsKt.titlecase((char)it, (Locale)locale);
                            } else {
                                string4 = String.valueOf((char)it);
                            }
                            StringBuilder stringBuilder2 = stringBuilder.append((Object)string4);
                            String string5 = string3;
                            int n = 1;
                            String string6 = string5.substring(n);
                            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
                            string = stringBuilder2.append(string6).toString();
                        } else {
                            string = string3;
                        }
                        String titleOrLabel = "\"" + string + "\"";
                        JsonValue jsonValue = new JsonElementGenerator(prj).createValue(titleOrLabel);
                        Intrinsics.checkNotNullExpressionValue((Object)jsonValue, (String)"createValue(...)");
                        value = jsonValue;
                        if (titleKeyValue == null) break block12;
                        String string7 = JsonFacade.getValue(titleKeyValue);
                        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getValue(...)");
                        if (!StringsKt.isBlank((CharSequence)string7)) break block13;
                    }
                    JsonStringLiteral jsonStringLiteral = titleKeyValue;
                    if (jsonStringLiteral != null) {
                        jsonStringLiteral.replace((PsiElement)value);
                    }
                }
                if (labelKeyValue == null) break block14;
                String string = JsonFacade.getValue(labelKeyValue);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
                if (!StringsKt.isBlank((CharSequence)string)) break block15;
            }
            JsonStringLiteral jsonStringLiteral = labelKeyValue;
            if (jsonStringLiteral != null) {
                jsonStringLiteral.replace((PsiElement)value);
            }
        }
    }

    @NotNull
    public final String fromPrimitiveToObject(@NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (Character.isUpperCase(StringsKt.first((CharSequence)type))) {
            return type;
        }
        if (type.equals("int")) {
            return "Integer";
        }
        if (type.equals("char")) {
            return "Character";
        }
        String string = String.valueOf(StringsKt.first((CharSequence)type));
        Intrinsics.checkNotNull((Object)string, (String)"null cannot be cast to non-null type java.lang.String");
        String string2 = string.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
        String string3 = type.substring(1);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        return string2 + string3;
    }

    @Nullable
    public final PsiType getGenericParameterType(@NotNull PsiType setType) {
        Intrinsics.checkNotNullParameter((Object)setType, (String)"setType");
        if (setType instanceof PsiClassType) {
            PsiType[] psiTypeArray = ((PsiClassType)setType).getParameters();
            Intrinsics.checkNotNullExpressionValue((Object)psiTypeArray, (String)"getParameters(...)");
            PsiType[] parameters = psiTypeArray;
            if (!(parameters.length == 0)) {
                return parameters[0];
            }
        }
        return null;
    }

    @NotNull
    public final String getFqnWithGenericFqnType(@NotNull PsiType fieldType) {
        Intrinsics.checkNotNullParameter((Object)fieldType, (String)"fieldType");
        PsiType genericParameterType = this.getGenericParameterType(fieldType);
        if (genericParameterType != null) {
            String string = fieldType.getCanonicalText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalText(...)");
            String string2 = genericParameterType.getPresentableText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPresentableText(...)");
            String string3 = genericParameterType.getCanonicalText();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getCanonicalText(...)");
            return StringsKt.replace$default((String)string, (String)string2, (String)string3, (boolean)false, (int)4, null);
        }
        String string = fieldType.getCanonicalText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalText(...)");
        return string;
    }

    @NotNull
    public final String getRawType(@NotNull PsiType setType) {
        Intrinsics.checkNotNullParameter((Object)setType, (String)"setType");
        if (setType instanceof PsiClassType) {
            String string = ((PsiClassType)setType).rawType().getCanonicalText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalText(...)");
            return string;
        }
        return "";
    }

    private static final void createField$lambda$0(AbstractVersionAwareWidgetNewFieldGenerator this$0) {
        try {
            Result result = this$0.prepareFieldCreation();
            if (result.getMsgIfNotNeedFenerate() == null) {
                this$0.generateCode(result);
            } else {
                JavaFacade.showSuccessNotification(this$0.prj, result.getMsgIfNotNeedFenerate());
            }
        }
        catch (Exception e) {
            throw new PlatformValidationException("Generation not available", null, e, this$0.prj);
        }
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"String", (Object)"java.lang.String"), TuplesKt.to((Object)"LocalDateTime", (Object)"java.time.LocalDateTime"), TuplesKt.to((Object)"Long", (Object)"java.lang.Long"), TuplesKt.to((Object)"Double", (Object)"java.lang.Double"), TuplesKt.to((Object)"Enum", (Object)"Enum"), TuplesKt.to((Object)"Dictionary extension", (Object)".dictionary.Dictionary"), TuplesKt.to((Object)"Boolean", (Object)"java.lang.Boolean")};
        SUPPORT_TYPES_FOR_PICK_LIST_AND_MULTIVALUE = MapsKt.mapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to((Object)"java.lang.String", (Object)".core.util.filter.provider.impl.StringValueProvider.class"), TuplesKt.to((Object)"java.time.LocalDateTime", (Object)".core.util.filter.provider.impl.DateValueProvider.class"), TuplesKt.to((Object)"java.lang.Long", (Object)".core.util.filter.provider.impl.LongValueProvider.class"), TuplesKt.to((Object)"java.lang.Double", (Object)".core.util.filter.provider.impl.BigDecimalValueProvider.class"), TuplesKt.to((Object)"Enum", (Object)".core.util.filter.provider.impl.EnumValueProvider.class"), TuplesKt.to((Object)"Dictionary", (Object)".core.util.filter.provider.impl.DictionaryValueProvider.class"), TuplesKt.to((Object)"java.lang.Boolean", (Object)".core.util.filter.provider.impl.BooleanValueProvider.class")};
        PROVIDER_TYPES = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010J\u001e\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0006J\u000e\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0014J\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0006J\u0016\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u0006J\u0016\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0006R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006$"}, d2={"Lorg/cxbox/intellij/community/wigdet/fields/field/generator/AbstractVersionAwareWidgetNewFieldGenerator$Companion;", "", "<init>", "()V", "SUPPORT_TYPES_FOR_PICK_LIST_AND_MULTIVALUE", "", "", "getSUPPORT_TYPES_FOR_PICK_LIST_AND_MULTIVALUE", "()Ljava/util/Map;", "PROVIDER_TYPES", "getPROVIDER_TYPES", "createEnum", "project", "Lcom/intellij/openapi/project/Project;", "fieldName", "dtoPsiClass", "Lcom/intellij/psi/PsiClass;", "entityPsiClass", "suggestNonConflictingFileName", "enumDir", "Lcom/intellij/psi/PsiDirectory;", "origEnumName", "extWithDot", "getEnumDirectory", "entityDir", "isSuitableFields", "", "field", "Lcom/intellij/psi/PsiField;", "pkj", "isDictionary", "psiClass", "getProviderType", "psiType", "Lcom/intellij/psi/PsiType;", "pkg", "cxbox-intellij-plugin"})
    @SourceDebugExtension(value={"SMAP\nAbstractVersionAwareWidgetNewFieldGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractVersionAwareWidgetNewFieldGenerator.kt\norg/cxbox/intellij/community/wigdet/fields/field/generator/AbstractVersionAwareWidgetNewFieldGenerator$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,443:1\n1#2:444\n12474#3,2:445\n*S KotlinDebug\n*F\n+ 1 AbstractVersionAwareWidgetNewFieldGenerator.kt\norg/cxbox/intellij/community/wigdet/fields/field/generator/AbstractVersionAwareWidgetNewFieldGenerator$Companion\n*L\n380#1:445,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<String, String> getSUPPORT_TYPES_FOR_PICK_LIST_AND_MULTIVALUE() {
            return SUPPORT_TYPES_FOR_PICK_LIST_AND_MULTIVALUE;
        }

        @NotNull
        public final Map<String, String> getPROVIDER_TYPES() {
            return PROVIDER_TYPES;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final String createEnum(@NotNull Project project, @NotNull String fieldName, @NotNull PsiClass dtoPsiClass, @Nullable PsiClass entityPsiClass) {
            Object object;
            PsiDirectory psiDirectory;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
            Intrinsics.checkNotNullParameter((Object)dtoPsiClass, (String)"dtoPsiClass");
            PsiClass psiClass = entityPsiClass;
            if (psiClass != null) {
                PsiDirectory psiDirectory2 = psiClass.getContainingFile().getContainingDirectory();
                Intrinsics.checkNotNullExpressionValue((Object)psiDirectory2, (String)"getContainingDirectory(...)");
                psiDirectory = this.getEnumDirectory(psiDirectory2);
            } else {
                PsiDirectory psiDirectory3 = dtoPsiClass.getContainingFile().getContainingDirectory();
                Intrinsics.checkNotNullExpressionValue((Object)psiDirectory3, (String)"getContainingDirectory(...)");
                psiDirectory = this.getEnumDirectory(psiDirectory3);
            }
            PsiDirectory enumDir = psiDirectory;
            Companion companion = this;
            PsiDirectory psiDirectory4 = enumDir;
            String string = fieldName + "Enum";
            if (((CharSequence)string).length() > 0) {
                String string2;
                void it;
                char c = string.charAt(0);
                StringBuilder stringBuilder = new StringBuilder();
                PsiDirectory psiDirectory5 = psiDirectory4;
                Companion companion2 = companion;
                int n = 0;
                if (Character.isLowerCase((char)it)) {
                    Locale locale = Locale.getDefault();
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                    string2 = CharsKt.titlecase((char)it, (Locale)locale);
                } else {
                    string2 = String.valueOf((char)it);
                }
                CharSequence charSequence = string2;
                companion = companion2;
                psiDirectory4 = psiDirectory5;
                StringBuilder stringBuilder2 = stringBuilder.append((Object)charSequence);
                String string3 = string;
                n = 1;
                String string4 = string3.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                object = stringBuilder2.append(string4).toString();
            } else {
                object = string;
            }
            String enumFileName = companion.suggestNonConflictingFileName(psiDirectory4, (String)object, ".java");
            FileTemplate it = FileTemplateManager.getInstance((Project)project).getJ2eeTemplate("PlatformDictionaryEnum");
            boolean bl = false;
            PsiElement psiElement = FileTemplateUtil.createFromTemplate((FileTemplate)it, (String)enumFileName, (Properties)new Properties(), (PsiDirectory)enumDir);
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.psi.PsiClass");
            PsiClass result = (PsiClass)psiElement;
            String string5 = result.getQualifiedName();
            if (string5 == null) {
                throw new PlatformValidationException("Cannot determine qualified name of created <a href=\"1\">enum</a>", (NavigatablePsiElement)result, project);
            }
            return string5;
        }

        @NotNull
        public final String suggestNonConflictingFileName(@NotNull PsiDirectory enumDir, @NotNull String origEnumName, @NotNull String extWithDot) {
            String string;
            Intrinsics.checkNotNullParameter((Object)enumDir, (String)"enumDir");
            Intrinsics.checkNotNullParameter((Object)origEnumName, (String)"origEnumName");
            Intrinsics.checkNotNullParameter((Object)extWithDot, (String)"extWithDot");
            String enumName = null;
            Set directoryFileNames = Arrays.stream(enumDir.getFiles()).map(arg_0 -> Companion.suggestNonConflictingFileName$lambda$3(Companion::suggestNonConflictingFileName$lambda$2, arg_0)).collect(Collectors.toSet());
            for (int i = 0; i < 10000; ++i) {
                String postfix;
                String string2 = postfix = i == 0 ? "" : String.valueOf(i);
                if (directoryFileNames.contains(origEnumName + postfix + extWithDot)) continue;
                enumName = origEnumName + postfix + extWithDot;
                break;
            }
            if ((string = enumName) == null) {
                String string3 = UUID.randomUUID().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
                string = origEnumName + StringsKt.replace$default((String)string3, (String)"-", (String)"", (boolean)false, (int)4, null) + extWithDot;
            }
            return string;
        }

        @NotNull
        public final PsiDirectory getEnumDirectory(@NotNull PsiDirectory entityDir) {
            Intrinsics.checkNotNullParameter((Object)entityDir, (String)"entityDir");
            PsiDirectory psiDirectory = entityDir.findSubdirectory("enums");
            if (psiDirectory == null && (psiDirectory = entityDir.findSubdirectory("enum")) == null) {
                PsiDirectory psiDirectory2 = entityDir.createSubdirectory("enums");
                psiDirectory = psiDirectory2;
                Intrinsics.checkNotNullExpressionValue((Object)psiDirectory2, (String)"createSubdirectory(...)");
            }
            return psiDirectory;
        }

        public final boolean isSuitableFields(@NotNull PsiField field, @NotNull String pkj) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Intrinsics.checkNotNullParameter((Object)pkj, (String)"pkj");
            if (JavaFacade.isPrimitiveType(field.getType().getCanonicalText())) {
                return this.getSUPPORT_TYPES_FOR_PICK_LIST_AND_MULTIVALUE().values().contains(JavaFacade.castPrimitiveToObject(field.getType().getCanonicalText()));
            }
            if (field.getType() instanceof PsiClassType) {
                PsiType psiType = field.getType();
                Intrinsics.checkNotNull((Object)psiType, (String)"null cannot be cast to non-null type com.intellij.psi.PsiClassType");
                PsiClass psiClass = ((PsiClassType)psiType).resolve();
                if (psiClass != null) {
                    return psiClass.isEnum() || CollectionsKt.contains((Iterable)this.getSUPPORT_TYPES_FOR_PICK_LIST_AND_MULTIVALUE().values(), (Object)psiClass.getQualifiedName()) ? true : this.isDictionary(psiClass, pkj);
                }
            }
            return false;
        }

        public final boolean isDictionary(@NotNull PsiClass psiClass, @NotNull String pkj) {
            boolean bl;
            block1: {
                Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
                Intrinsics.checkNotNullParameter((Object)pkj, (String)"pkj");
                PsiClass[] psiClassArray = psiClass.getSupers();
                Intrinsics.checkNotNullExpressionValue((Object)psiClassArray, (String)"getSupers(...)");
                Object[] $this$any$iv = psiClassArray;
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    PsiClass it = (PsiClass)element$iv;
                    boolean bl2 = false;
                    if (!(pkj + Companion.getSUPPORT_TYPES_FOR_PICK_LIST_AND_MULTIVALUE().get("Dictionary extension")).equals(it.getQualifiedName())) continue;
                    bl = true;
                    break block1;
                }
                bl = false;
            }
            return bl;
        }

        @NotNull
        public final String getProviderType(@NotNull PsiType psiType, @NotNull String pkg) {
            PsiClass resolveClass;
            Intrinsics.checkNotNullParameter((Object)psiType, (String)"psiType");
            Intrinsics.checkNotNullParameter((Object)pkg, (String)"pkg");
            if (psiType instanceof PsiClassType && (resolveClass = ((PsiClassType)psiType).resolve()) != null) {
                if (resolveClass.isEnum()) {
                    String string = this.getPROVIDER_TYPES().get("Enum");
                    Intrinsics.checkNotNull((Object)string);
                    return string;
                }
                if (this.isDictionary(resolveClass, pkg)) {
                    String string = this.getPROVIDER_TYPES().get("Dictionary");
                    Intrinsics.checkNotNull((Object)string);
                    return string;
                }
                if (this.getPROVIDER_TYPES().containsKey(resolveClass.getQualifiedName())) {
                    String string = this.getPROVIDER_TYPES().get(resolveClass.getQualifiedName());
                    Intrinsics.checkNotNull((Object)string);
                    return string;
                }
            }
            return "";
        }

        private static final String suggestNonConflictingFileName$lambda$2(PsiFile obj) {
            Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
            return obj.getName();
        }

        private static final String suggestNonConflictingFileName$lambda$3(Function1 $tmp0, Object p0) {
            return (String)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R,\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00060\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR,\u0010\r\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\b0\u00060\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\n\"\u0004\b\u0010\u0010\fR,\u0010\u0011\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\b0\u00060\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\n\"\u0004\b\u0014\u0010\fR,\u0010\u0015\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\b0\u00060\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\n\"\u0004\b\u0018\u0010\fR \u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\n\"\u0004\b\u001b\u0010\fR \u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\n\"\u0004\b\u001f\u0010\fR \u0010 \u001a\b\u0012\u0004\u0012\u00020\u001d0\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\n\"\u0004\b\"\u0010\fR \u0010#\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\n\"\u0004\b%\u0010\fR \u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\n\"\u0004\b)\u0010\fR \u0010*\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\n\"\u0004\b,\u0010\fR \u0010-\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010\n\"\u0004\b/\u0010\fR\u001c\u00100\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104\u00a8\u00065"}, d2={"Lorg/cxbox/intellij/community/wigdet/fields/field/generator/AbstractVersionAwareWidgetNewFieldGenerator$Result;", "", "<init>", "()V", "rowIndependentMeta", "Ljava/util/ArrayList;", "Ljava/util/function/Function;", "Lorg/cxbox/intellij/community/common/util/FieldMetaBuilderUtil$RowIndependentMetaprms;", "", "getRowIndependentMeta", "()Ljava/util/ArrayList;", "setRowIndependentMeta", "(Ljava/util/ArrayList;)V", "rowDependentMeta", "Lorg/cxbox/intellij/community/common/util/FieldMetaBuilderUtil$RowDependentMetaprms;", "getRowDependentMeta", "setRowDependentMeta", "versionAwareDoUpdate", "Lorg/cxbox/intellij/community/common/util/VersionAwareServiceUtils$VersionAwareServiceDoUpdateEntityDto;", "getVersionAwareDoUpdate", "setVersionAwareDoUpdate", "dtoConstructorMapFormEntity", "Lorg/cxbox/intellij/community/common/util/DataResponseDTOUtil$DtoConstructorprms;", "getDtoConstructorMapFormEntity", "setDtoConstructorMapFormEntity", "mapperBuilderPutLines", "getMapperBuilderPutLines", "setMapperBuilderPutLines", "dtoFields", "Lorg/cxbox/intellij/community/common/util/FieldWithAnnotation;", "getDtoFields", "setDtoFields", "versionAwareFields", "getVersionAwareFields", "setVersionAwareFields", "dtoMetaModelFields", "getDtoMetaModelFields", "setDtoMetaModelFields", "bcEnumServiceConstants", "Lorg/cxbox/intellij/community/common/util/EnumConstant;", "getBcEnumServiceConstants", "setBcEnumServiceConstants", "entityFields", "getEntityFields", "setEntityFields", "popupEntityFields", "getPopupEntityFields", "setPopupEntityFields", "msgIfNotNeedFenerate", "getMsgIfNotNeedFenerate", "()Ljava/lang/String;", "setMsgIfNotNeedFenerate", "(Ljava/lang/String;)V", "cxbox-intellij-plugin"})
    public static final class Result {
        @NotNull
        private ArrayList<Function<FieldMetaBuilderUtil.RowIndependentMetaprms, String>> rowIndependentMeta = new ArrayList();
        @NotNull
        private ArrayList<Function<FieldMetaBuilderUtil.RowDependentMetaprms, String>> rowDependentMeta = new ArrayList();
        @NotNull
        private ArrayList<Function<VersionAwareServiceUtils.VersionAwareServiceDoUpdateEntityDto, String>> versionAwareDoUpdate = new ArrayList();
        @NotNull
        private ArrayList<Function<DataResponseDTOUtil.DtoConstructorprms, String>> dtoConstructorMapFormEntity = new ArrayList();
        @NotNull
        private ArrayList<String> mapperBuilderPutLines = new ArrayList();
        @NotNull
        private ArrayList<FieldWithAnnotation> dtoFields = new ArrayList();
        @NotNull
        private ArrayList<FieldWithAnnotation> versionAwareFields = new ArrayList();
        @NotNull
        private ArrayList<FieldWithAnnotation> dtoMetaModelFields = new ArrayList();
        @NotNull
        private ArrayList<EnumConstant> bcEnumServiceConstants = new ArrayList();
        @NotNull
        private ArrayList<FieldWithAnnotation> entityFields = new ArrayList();
        @NotNull
        private ArrayList<FieldWithAnnotation> popupEntityFields = new ArrayList();
        @Nullable
        private String msgIfNotNeedFenerate;

        @NotNull
        public final ArrayList<Function<FieldMetaBuilderUtil.RowIndependentMetaprms, String>> getRowIndependentMeta() {
            return this.rowIndependentMeta;
        }

        public final void setRowIndependentMeta(@NotNull ArrayList<Function<FieldMetaBuilderUtil.RowIndependentMetaprms, String>> arrayList) {
            Intrinsics.checkNotNullParameter(arrayList, (String)"<set-?>");
            this.rowIndependentMeta = arrayList;
        }

        @NotNull
        public final ArrayList<Function<FieldMetaBuilderUtil.RowDependentMetaprms, String>> getRowDependentMeta() {
            return this.rowDependentMeta;
        }

        public final void setRowDependentMeta(@NotNull ArrayList<Function<FieldMetaBuilderUtil.RowDependentMetaprms, String>> arrayList) {
            Intrinsics.checkNotNullParameter(arrayList, (String)"<set-?>");
            this.rowDependentMeta = arrayList;
        }

        @NotNull
        public final ArrayList<Function<VersionAwareServiceUtils.VersionAwareServiceDoUpdateEntityDto, String>> getVersionAwareDoUpdate() {
            return this.versionAwareDoUpdate;
        }

        public final void setVersionAwareDoUpdate(@NotNull ArrayList<Function<VersionAwareServiceUtils.VersionAwareServiceDoUpdateEntityDto, String>> arrayList) {
            Intrinsics.checkNotNullParameter(arrayList, (String)"<set-?>");
            this.versionAwareDoUpdate = arrayList;
        }

        @NotNull
        public final ArrayList<Function<DataResponseDTOUtil.DtoConstructorprms, String>> getDtoConstructorMapFormEntity() {
            return this.dtoConstructorMapFormEntity;
        }

        public final void setDtoConstructorMapFormEntity(@NotNull ArrayList<Function<DataResponseDTOUtil.DtoConstructorprms, String>> arrayList) {
            Intrinsics.checkNotNullParameter(arrayList, (String)"<set-?>");
            this.dtoConstructorMapFormEntity = arrayList;
        }

        @NotNull
        public final ArrayList<String> getMapperBuilderPutLines() {
            return this.mapperBuilderPutLines;
        }

        public final void setMapperBuilderPutLines(@NotNull ArrayList<String> arrayList) {
            Intrinsics.checkNotNullParameter(arrayList, (String)"<set-?>");
            this.mapperBuilderPutLines = arrayList;
        }

        @NotNull
        public final ArrayList<FieldWithAnnotation> getDtoFields() {
            return this.dtoFields;
        }

        public final void setDtoFields(@NotNull ArrayList<FieldWithAnnotation> arrayList) {
            Intrinsics.checkNotNullParameter(arrayList, (String)"<set-?>");
            this.dtoFields = arrayList;
        }

        @NotNull
        public final ArrayList<FieldWithAnnotation> getVersionAwareFields() {
            return this.versionAwareFields;
        }

        public final void setVersionAwareFields(@NotNull ArrayList<FieldWithAnnotation> arrayList) {
            Intrinsics.checkNotNullParameter(arrayList, (String)"<set-?>");
            this.versionAwareFields = arrayList;
        }

        @NotNull
        public final ArrayList<FieldWithAnnotation> getDtoMetaModelFields() {
            return this.dtoMetaModelFields;
        }

        public final void setDtoMetaModelFields(@NotNull ArrayList<FieldWithAnnotation> arrayList) {
            Intrinsics.checkNotNullParameter(arrayList, (String)"<set-?>");
            this.dtoMetaModelFields = arrayList;
        }

        @NotNull
        public final ArrayList<EnumConstant> getBcEnumServiceConstants() {
            return this.bcEnumServiceConstants;
        }

        public final void setBcEnumServiceConstants(@NotNull ArrayList<EnumConstant> arrayList) {
            Intrinsics.checkNotNullParameter(arrayList, (String)"<set-?>");
            this.bcEnumServiceConstants = arrayList;
        }

        @NotNull
        public final ArrayList<FieldWithAnnotation> getEntityFields() {
            return this.entityFields;
        }

        public final void setEntityFields(@NotNull ArrayList<FieldWithAnnotation> arrayList) {
            Intrinsics.checkNotNullParameter(arrayList, (String)"<set-?>");
            this.entityFields = arrayList;
        }

        @NotNull
        public final ArrayList<FieldWithAnnotation> getPopupEntityFields() {
            return this.popupEntityFields;
        }

        public final void setPopupEntityFields(@NotNull ArrayList<FieldWithAnnotation> arrayList) {
            Intrinsics.checkNotNullParameter(arrayList, (String)"<set-?>");
            this.popupEntityFields = arrayList;
        }

        @Nullable
        public final String getMsgIfNotNeedFenerate() {
            return this.msgIfNotNeedFenerate;
        }

        public final void setMsgIfNotNeedFenerate(@Nullable String string) {
            this.msgIfNotNeedFenerate = string;
        }
    }
}

