/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.common.util;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.fileTemplates.actions.CreateFromTemplateActionBase;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonProperty;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.lang3.tuple.Triple;
import org.cxbox.intellij.community.common.conf.JWidget;
import org.cxbox.intellij.community.common.util.JsonFacade;
import org.cxbox.intellij.community.common.util.SearchScopeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WidgetUtil {
    public static Optional<JsonProperty> getFieldsFromWidget(PsiFile widgetFile) {
        return Optional.ofNullable((JsonProperty[])JsonFacade.getChildrenOfType((PsiElement)widgetFile, JsonProperty.class)).stream().flatMap(Arrays::stream).filter(Objects::nonNull).filter(property -> JWidget.FIELDS.getName().equals(property.getName())).findFirst();
    }

    public static final class CreateWidgetFix
    implements LocalQuickFix {
        @Nullable
        private static PsiDirectory getWidgetsRootDir(@NotNull Project project, @NotNull Module module) {
            if (project == null) {
                CreateWidgetFix.$$$reportNull$$$0(0);
            }
            if (module == null) {
                CreateWidgetFix.$$$reportNull$$$0(1);
            }
            GlobalSearchScope scp = SearchScopeUtil.getModuleSearchScopeWithParentsAndChildsAndLibraries(module, module.getProject());
            List<JsonFile> allWidgetFiles = JWidget.getAllWidgetFiles(project, module);
            JsonFile secondLevelMenu = allWidgetFiles.stream().filter(w -> "SecondLevelMenu".equals(JWidget.getWidgetType(w))).findFirst().orElse(allWidgetFiles.stream().findFirst().orElse(null));
            PsiDirectory widgetExampleDir = secondLevelMenu != null ? secondLevelMenu.getContainingFile().getContainingDirectory() : null;
            PsiDirectory widgetDir = null;
            String widgetsRootDirName = "widgets";
            if (widgetExampleDir != null && widgetsRootDirName.equals(widgetExampleDir.getName())) {
                widgetDir = widgetExampleDir;
            } else if (widgetExampleDir != null && widgetExampleDir.getParentDirectory() != null && widgetsRootDirName.equals(widgetExampleDir.getParentDirectory().getName())) {
                widgetDir = widgetExampleDir.getParentDirectory();
            } else if (widgetExampleDir != null && widgetExampleDir.getParentDirectory() != null && widgetExampleDir.getParentDirectory().getParentDirectory() != null && widgetsRootDirName.equals(widgetExampleDir.getParentDirectory().getParentDirectory().getName())) {
                widgetDir = widgetExampleDir.getParentDirectory().getParentDirectory();
            }
            widgetDir = widgetDir == null ? widgetExampleDir : widgetDir;
            return widgetDir;
        }

        @NotNull
        private static Triple<FileTemplate, String, Properties> getScreenViewTemplateData(@NotNull Project project, @NotNull Module module, PsiElement viewNamePsiElement) {
            String widgetName;
            if (project == null) {
                CreateWidgetFix.$$$reportNull$$$0(2);
            }
            if (module == null) {
                CreateWidgetFix.$$$reportNull$$$0(3);
            }
            FileTemplate template = (widgetName = JsonFacade.safeGetValueAsString(viewNamePsiElement)).contains("Form") ? FileTemplateManager.getInstance((Project)project).getJ2eeTemplate("PlatformFormWidget") : (widgetName.contains("Info") ? FileTemplateManager.getInstance((Project)project).getJ2eeTemplate("PlatformInfoWidget") : (widgetName.contains("List") ? FileTemplateManager.getInstance((Project)project).getJ2eeTemplate("PlatformListWidget") : FileTemplateManager.getInstance((Project)project).getJ2eeTemplate("PlatformFormWidget")));
            Properties properties = new Properties();
            Triple triple = Triple.of((Object)template, (Object)widgetName, (Object)properties);
            if (triple == null) {
                CreateWidgetFix.$$$reportNull$$$0(4);
            }
            return triple;
        }

        public boolean availableInBatchMode() {
            return false;
        }

        @NotNull
        public String getName() {
            return "Create widget";
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            return "Create widget";
        }

        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
            if (project == null) {
                CreateWidgetFix.$$$reportNull$$$0(5);
            }
            if (previewDescriptor == null) {
                CreateWidgetFix.$$$reportNull$$$0(6);
            }
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                CreateWidgetFix.$$$reportNull$$$0(7);
            }
            return intentionPreviewInfo;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                CreateWidgetFix.$$$reportNull$$$0(8);
            }
            if (descriptor == null) {
                CreateWidgetFix.$$$reportNull$$$0(9);
            }
            try {
                PsiElement widgetNamePsiElement = descriptor.getPsiElement();
                Module module = ModuleUtil.findModuleForPsiElement((PsiElement)widgetNamePsiElement);
                if (module == null) {
                    return;
                }
                Triple<FileTemplate, String, Properties> templateData = CreateWidgetFix.getScreenViewTemplateData(project, module, widgetNamePsiElement);
                FileTemplate template = (FileTemplate)templateData.getLeft();
                Properties props = (Properties)templateData.getRight();
                String widgetName = (String)templateData.getMiddle();
                PsiDirectory widgetDir = CreateWidgetFix.getWidgetsRootDir(project, module);
                PsiElement file = FileTemplateUtil.createFromTemplate((FileTemplate)template, (String)(widgetName + ".widget.json"), (Properties)props, (PsiDirectory)widgetDir);
                if (template != null && template.isLiveTemplateEnabled() && file instanceof PsiFile) {
                    CreateFromTemplateActionBase.startLiveTemplate((PsiFile)((PsiFile)file));
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/cxbox/intellij/community/common/util/WidgetUtil$CreateWidgetFix";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "previewDescriptor";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/cxbox/intellij/community/common/util/WidgetUtil$CreateWidgetFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getScreenViewTemplateData";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generatePreview";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getWidgetsRootDir";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getScreenViewTemplateData";
                    break;
                }
                case 4: 
                case 7: {
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "generatePreview";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 7 -> new IllegalStateException(string);
            };
        }
    }
}

