/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.wigdet.bc.service.generator;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiQualifiedNamedElement;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import org.cxbox.intellij.community.common.Cache;
import org.cxbox.intellij.community.common.util.EnumBcUtil;
import org.cxbox.intellij.community.common.util.JavaUtil;
import org.cxbox.intellij.community.common.util.ResponseServiceUtils;
import org.cxbox.intellij.community.exception.PlatformValidationException;
import org.cxbox.intellij.community.wigdet.bc.common.ResponseServiceType;
import org.cxbox.intellij.community.wigdet.bc.service.ElementPostfix;
import org.cxbox.intellij.community.wigdet.bc.service.TemplateProperties;
import org.cxbox.intellij.community.wigdet.bc.service.generator.AbstractBcServiceGenerator;
import org.cxbox.intellij.community.wigdet.bc.service.generator.BcDialogCreationData;
import org.cxbox.intellij.community.wigdet.bc.service.generator.ElementGenerationContext;
import org.cxbox.intellij.community.wigdet.bc.service.generator.GenerationType;
import org.cxbox.intellij.community.wigdet.bc.service.generator.ServicePsiElementGenerator;
import org.cxbox.intellij.community.wigdet.bc.service.utils.RepositoryUtils;

public abstract class BcServiceGenerator
extends AbstractBcServiceGenerator<BcDialogCreationData, ElementGenerationContext.ElementBcData, ElementGenerationContext> {
    @Override
    public ElementGenerationContext.ElementBcData createElements(Module module, BcDialogCreationData data, NavigatablePsiElement navigatablePsiElement) throws Exception {
        Project project = module.getProject();
        ElementGenerationContext context = (ElementGenerationContext)ApplicationManager.getApplication().runReadAction(() -> this.createElementGenerationContext(module, data, navigatablePsiElement));
        return (ElementGenerationContext.ElementBcData)WriteCommandAction.runWriteCommandAction((Project)project, () -> this.createElementsService(context));
    }

    private ElementGenerationContext.ElementBcData createElementsService(ElementGenerationContext context) {
        ElementGenerationContext elementGenerationContext = context;
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        for (GenerationType<ElementGenerationContext> generationType : this.elementsToGenerate()) {
            if (indicator != null) {
                indicator.setText("Creating elements");
                indicator.setText2(generationType.type().name());
            }
            elementGenerationContext = new ElementGenerationContext(elementGenerationContext.module(), elementGenerationContext.bcDialogCreationData(), elementGenerationContext.navigatablePsiElement(), generationType, elementGenerationContext.elementBcData(), elementGenerationContext.properties());
            this.createOrUpdateElement(elementGenerationContext);
        }
        return elementGenerationContext.elementBcData();
    }

    private void fillElementBcData(Module module, BcDialogCreationData data, ElementGenerationContext.ElementBcData elementBcData, Map<ResponseServiceType, List<ResponseServiceUtils.ResponseServiceData>> responseServiceDataMap) {
        Project project = module.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        ResponseServiceUtils.ResponseServiceData responseServiceData = ResponseServiceUtils.getResponseServiceDataByClassName(project, module, data.serviceClzName());
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)module.getProject());
        if (!data.isNewService() && responseServiceData != null && !JavaUtil.isAbstractOrInterfaceClass(responseServiceData.responseServicePsiClass())) {
            Optional.of(responseServiceData).map(ResponseServiceUtils.ResponseServiceData::responseServicePsiClass).ifPresent(elementBcData::setServiceClz);
            Optional.of(responseServiceData).map(ResponseServiceUtils.ResponseServiceData::responseServiceDtoPsiClass).ifPresentOrElse(elementBcData::setDtoClz, () -> this.throwPlatformException((PsiElement)elementBcData.entityClz(), "Cannot find dto class from service: <a href = \"1\">" + elementBcData.serviceClz().getName() + "</a>"));
            Optional.of(responseServiceData).map(ResponseServiceUtils.ResponseServiceData::responseServiceEntityPsiClass).ifPresentOrElse(elementBcData::setEntityClz, () -> this.throwPlatformException((PsiElement)elementBcData.entityClz(), "Cannot find entity class from service: <a href = \"1\">" + elementBcData.serviceClz().getName() + "</a>"));
            Optional.of(responseServiceData).map(ResponseServiceUtils.ResponseServiceData::responseServicePsiClass).flatMap(rsc -> ResponseServiceUtils.getResponseServiceMetaBuilderFromFieldOrConstructor(rsc, project, module)).ifPresentOrElse(elementBcData::setMetaClz, () -> this.throwPlatformException((PsiElement)elementBcData.entityClz(), "Cannot find meta class from service: <a href = \"1\">" + elementBcData.serviceClz().getName() + "</a>"));
            Optional.of(responseServiceData).map(ResponseServiceUtils.ResponseServiceData::responseServicePsiClass).flatMap(rsc -> ResponseServiceUtils.getAnySourceResponseServiceDAO(rsc, project, module)).ifPresentOrElse(elementBcData::setDaoClz, () -> {
                if (elementBcData.serviceType().equals(ResponseServiceType.ANY_SOURCE_VERSION_AWARE_RESPONSE_SERVICE)) {
                    this.throwPlatformException((PsiElement)elementBcData.entityClz(), "Cannot find dao class from service: <a href = \"1\">" + elementBcData.serviceClz().getName() + "</a>");
                }
            });
            Optional.of(responseServiceData).map(ResponseServiceUtils.ResponseServiceData::responseServiceEntityPsiClass).map(rsc -> RepositoryUtils.findRepoByEntity(rsc, module)).ifPresent(elementBcData::setRepoClz);
        } else {
            PsiClass repoClz;
            PsiClass serviceClass;
            if (responseServiceData != null && JavaUtil.isAbstractOrInterfaceClass(responseServiceData.responseServicePsiClass())) {
                this.throwPlatformException((PsiElement)responseServiceData.responseServicePsiClass(), "Cannot create bc. Service with name: <a href=\"1\">" + responseServiceData.responseServicePsiClass().getName() + "</a> is abstract or interface");
            }
            String targetPackage = ResponseServiceUtils.findTargetPackage(module);
            String servicePackage = ResponseServiceUtils.findServicePackage(responseServiceDataMap, data.serviceType(), targetPackage);
            String dtoPackage = ResponseServiceUtils.findDtoClassPackage(responseServiceDataMap, data.serviceType(), targetPackage);
            String entityPackage = ResponseServiceUtils.findEntityClassPackage(responseServiceDataMap, data.serviceType(), targetPackage);
            Object metaName = data.serviceClzName();
            if (((String)metaName).endsWith(ElementPostfix.SERVICE.getName())) {
                metaName = ((String)metaName).substring(0, ((String)metaName).length() - ElementPostfix.SERVICE.getName().length());
            }
            metaName = (String)metaName + ElementPostfix.META.getName();
            String daoName = data.serviceClzName();
            if (daoName.endsWith(ElementPostfix.SERVICE.getName())) {
                daoName = daoName.substring(0, daoName.length() - ElementPostfix.SERVICE.getName().length());
            }
            if ((serviceClass = JavaUtil.safetyFindClass(psiFacade, servicePackage + "." + data.serviceClzName(), scope)) != null && responseServiceData == null) {
                this.throwPlatformException((PsiElement)serviceClass, "Cannot create bc. Service with name: <a href=\"1\">" + serviceClass.getName() + "</a> already exists but either does not extend ResponseService or contains errors.");
            }
            elementBcData.setServiceClz(serviceClass);
            PsiClass dtoClz = JavaUtil.safetyFindClass(psiFacade, dtoPackage + "." + data.dtoClzName(), scope);
            elementBcData.setDtoClz(dtoClz);
            PsiClass entityClz = null;
            if (dtoClz != null) {
                if (ResponseServiceUtils.isDtoInheritsDataResponseDTOResponse(dtoClz, project, module)) {
                    entityClz = ResponseServiceUtils.getEntityByDto(dtoClz, module).orElse(null);
                } else {
                    this.throwPlatformException((PsiElement)dtoClz, "Chosen DTO <a href=\"1\">" + dtoClz.getName() + "</a> not inherits DataResponseDTO </a>. Please inherits DataResponseDTO.");
                }
            }
            if (entityClz == null && dtoClz != null) {
                this.throwPlatformException((PsiElement)elementBcData.dtoClz(), "Cannot found entity from dto <a href=\"1\">" + dtoClz.getName() + "</a>. Please specify the entity in the generic.");
            }
            if (entityClz == null) {
                entityClz = JavaUtil.safetyFindClass(psiFacade, entityPackage + "." + data.entityClzName(), scope);
            }
            if (entityClz != null && !ResponseServiceUtils.isEntityInheritsBaseEntity(entityClz, project, module) && elementBcData.serviceType().equals(ResponseServiceType.VERSION_AWARE_RESPONSE_SERVICE)) {
                this.throwPlatformException((PsiElement)entityClz, "Chosen entity <a href=\"1\">" + entityClz.getName() + "</a> not inherits BaseEntity. Please inherits BaseEntity.");
            }
            elementBcData.setEntityClz(entityClz);
            if (entityClz != null) {
                repoClz = RepositoryUtils.findRepoByEntity(entityClz, module);
            } else {
                String repoPackage = ResponseServiceUtils.findRepoPackage(module, targetPackage);
                repoClz = JavaUtil.safetyFindClass(psiFacade, repoPackage + "." + JavaUtil.capitalizeFirstLetter(data.entityClzName() + ElementPostfix.REPOSITORY.getName()), scope);
            }
            elementBcData.setRepoClz(repoClz);
            elementBcData.setMetaClz(JavaUtil.safetyFindClass(psiFacade, servicePackage + "." + (String)metaName, scope));
            elementBcData.setDaoClz(JavaUtil.safetyFindClass(psiFacade, servicePackage + "." + daoName, scope));
        }
        if (data.parentBcName() != null) {
            String parentEntityFQN = null;
            String parentRepoFQN = null;
            ResponseServiceUtils.ResponseServiceData parentResponseServiceData = ResponseServiceUtils.getResponseServiceDataByBc(module.getProject(), module, data.parentBcName());
            parentEntityFQN = Optional.ofNullable(parentResponseServiceData).map(ResponseServiceUtils.ResponseServiceData::responseServiceEntityPsiClass).map(PsiClass::getQualifiedName).orElse(null);
            if (parentResponseServiceData != null && Optional.ofNullable(parentResponseServiceData.responseServiceEntityPsiClass()).map(PsiNamedElement::getName).isPresent()) {
                PsiClass parentRepo = RepositoryUtils.findRepoByEntity(parentResponseServiceData.responseServiceEntityPsiClass(), module);
                parentRepoFQN = Optional.ofNullable(parentRepo).map(PsiClass::getQualifiedName).orElse(null);
            }
            elementBcData.setParentEntityClz(JavaUtil.safetyFindClass(psiFacade, parentEntityFQN, scope));
            elementBcData.setParentRepoClz(JavaUtil.safetyFindClass(psiFacade, parentRepoFQN, scope));
        }
        elementBcData.setNewService(data.isNewService());
    }

    public void throwPlatformException(PsiElement element, String content) {
        throw new PlatformValidationException(content, JavaUtil.getNavigatableElement(element), null, element.getProject(), MessageType.INFO, AllIcons.General.Warning);
    }

    public Properties createCommonProperties(Module module, BcDialogCreationData bcDialogCreationData, Map<ResponseServiceType, List<ResponseServiceUtils.ResponseServiceData>> responseServiceData) {
        Properties properties = new Properties();
        ResponseServiceType responseServiceType = bcDialogCreationData.serviceType();
        String platformRootPackageWithoutDot = Cache.getPlatformRootPackageWithoutDot(module.getProject(), module);
        String targetPackage = ResponseServiceUtils.findTargetPackage(module);
        Collection<PsiClass> allBcHolderWithoutCache = EnumBcUtil.getProjectBcHolderClass(module);
        PsiClass enumClass = allBcHolderWithoutCache.iterator().next();
        Boolean isRepository = RepositoryUtils.isContainRepository(module);
        properties.setProperty(TemplateProperties.PLATFORM_PACKAGE_NAME.name(), platformRootPackageWithoutDot);
        properties.setProperty(TemplateProperties.PACKAGE_NAME.name(), targetPackage);
        properties.setProperty(TemplateProperties.PERSISTENCE_PACKAGE_NAME.name(), Cache.getPersistenceVersionWithoutDot(module.getProject(), module));
        properties.setProperty(TemplateProperties.OLD_API.name(), String.valueOf(!ResponseServiceUtils.isNewApi(module.getProject(), module)));
        properties.setProperty(TemplateProperties.ENTITY_PACKAGE.name(), ResponseServiceUtils.findEntityClassPackage(responseServiceData, responseServiceType, targetPackage));
        properties.setProperty(TemplateProperties.REPO_PACKAGE.name(), ResponseServiceUtils.findRepoPackage(module, targetPackage));
        properties.setProperty(TemplateProperties.DTO_PACKAGE.name(), ResponseServiceUtils.findDtoClassPackage(responseServiceData, responseServiceType, targetPackage));
        properties.setProperty(TemplateProperties.SERVICE_PACKAGE.name(), ResponseServiceUtils.findServicePackage(responseServiceData, responseServiceType, targetPackage));
        properties.setProperty(TemplateProperties.META_PACKAGE.name(), ResponseServiceUtils.findServicePackage(responseServiceData, responseServiceType, targetPackage));
        properties.setProperty(TemplateProperties.DAO_PACKAGE.name(), ResponseServiceUtils.findServicePackage(responseServiceData, responseServiceType, targetPackage));
        properties.setProperty(TemplateProperties.BC_NAME.name(), bcDialogCreationData.bcName());
        properties.setProperty(TemplateProperties.BC_CLASS_FQN.name(), enumClass.getQualifiedName());
        properties.setProperty(TemplateProperties.IS_OLD_PLATFORM.name(), String.valueOf(!platformRootPackageWithoutDot.equals("org.cxbox")));
        properties.setProperty(TemplateProperties.JPA_DAO_FQN.name(), platformRootPackageWithoutDot + ".model.core.dao.JpaDao");
        properties.setProperty(TemplateProperties.IS_PERSISTENCE_REPOSITORY.name(), String.valueOf(isRepository));
        properties.setProperty(TemplateProperties.REPO_NAME.name(), JavaUtil.capitalizeFirstLetter(bcDialogCreationData.entityClzName() + ElementPostfix.REPOSITORY.getName()));
        properties.setProperty(TemplateProperties.IS_META_SORT_ENABLED.name(), String.valueOf(ResponseServiceUtils.isMetaAvailableSort(module.getProject(), module)));
        if (bcDialogCreationData.parentBcName() != null) {
            ResponseServiceUtils.ResponseServiceData parentResponseServiceData = ResponseServiceUtils.getResponseServiceDataByBc(module.getProject(), module, bcDialogCreationData.parentBcName());
            properties.setProperty(TemplateProperties.PARENT_VERSION_AWARE_CLASS.name(), String.valueOf(Optional.ofNullable(parentResponseServiceData).map(ResponseServiceUtils.ResponseServiceData::responseServicePsiClass).map(psc -> ResponseServiceUtils.isVersionAwareResponseService(psc, module.getProject(), module)).orElse(false)));
            if (parentResponseServiceData != null && Optional.ofNullable(parentResponseServiceData.responseServiceEntityPsiClass()).map(PsiNamedElement::getName).isPresent()) {
                PsiClass parentEntity = Optional.of(parentResponseServiceData.responseServiceEntityPsiClass()).orElse(null);
                PsiClass parentRepo = RepositoryUtils.findRepoByEntity(parentResponseServiceData.responseServiceEntityPsiClass(), ModuleUtilCore.findModuleForPsiElement((PsiElement)parentEntity));
                if (isRepository.booleanValue() && ResponseServiceType.VERSION_AWARE_RESPONSE_SERVICE.equals(responseServiceType) && parentRepo != null && parentRepo.getName() != null) {
                    properties.setProperty(TemplateProperties.PARENT_REPO_FQN.name(), parentRepo.getQualifiedName());
                    properties.setProperty(TemplateProperties.PARENT_REPO_NAME_VAR.name(), JavaUtil.deCapitalizeFirstLetter(parentRepo.getName()));
                }
                if (isRepository.booleanValue() && ResponseServiceType.VERSION_AWARE_RESPONSE_SERVICE.equals(responseServiceType) && parentRepo == null) {
                    properties.setProperty(TemplateProperties.PARENT_REPO_NAME_VAR.name(), JavaUtil.deCapitalizeFirstLetter(parentResponseServiceData.responseServiceEntityPsiClass().getName() + ElementPostfix.REPOSITORY.getName()));
                    properties.setProperty(TemplateProperties.PARENT_REPO_NAME.name(), JavaUtil.capitalizeFirstLetter(parentEntity.getName()) + ElementPostfix.REPOSITORY.getName());
                    properties.setProperty(TemplateProperties.PARENT_REPO_FQN.name(), ResponseServiceUtils.findRepoPackage(module, targetPackage) + "." + parentEntity.getName() + ElementPostfix.REPOSITORY.getName());
                }
                properties.setProperty(TemplateProperties.PARENT_ENTITY_NAME.name(), parentEntity.getName());
                if (parentEntity.getName() != null) {
                    properties.setProperty(TemplateProperties.PARENT_ENTITY_TABLE.name(), JavaUtil.toUpperSnakeCase(parentEntity.getName()));
                    properties.setProperty(TemplateProperties.PARENT_ENTITY_FQN.name(), Optional.of(parentEntity).map(PsiClass::getQualifiedName).orElse(null));
                    Optional.of(parentEntity).map(PsiQualifiedNamedElement::getName).map(JavaUtil::deCapitalizeFirstLetter).ifPresent(name -> properties.setProperty(TemplateProperties.PARENT_ENTITY_NAME.name(), (String)name));
                    properties.setProperty(TemplateProperties.SETTER_PARENT_ENTITY.name(), "set" + JavaUtil.capitalizeFirstLetter(parentEntity.getName()));
                    properties.setProperty(TemplateProperties.GETTER_PARENT_ENTITY.name(), "get" + JavaUtil.capitalizeFirstLetter(parentEntity.getName()));
                }
            }
        }
        return properties;
    }

    public ElementGenerationContext createElementGenerationContext(Module module, BcDialogCreationData data, NavigatablePsiElement navigatablePsiElement) {
        Map<ResponseServiceType, List<ResponseServiceUtils.ResponseServiceData>> responseServiceData = ResponseServiceUtils.collectServicesToMapByResponseType(module);
        ElementGenerationContext.ElementBcData elementBcData = new ElementGenerationContext.ElementBcData().setServiceType(data.serviceType()).setBcEnumName(data.bcName()).setParentBcEnum(data.parentBcName());
        this.fillElementBcData(module, data, elementBcData, responseServiceData);
        return new ElementGenerationContext(module, data, navigatablePsiElement, null, elementBcData, this.createCommonProperties(module, data, responseServiceData));
    }

    private ElementGenerationContext createOrUpdateElement(ElementGenerationContext elementGenerationContext) {
        ServicePsiElementGenerator<ElementGenerationContext> factory = elementGenerationContext.type().factory();
        if (factory == null) {
            return elementGenerationContext;
        }
        if (factory.isApplicable(elementGenerationContext)) {
            Function<ElementGenerationContext, PsiElement> operation = factory.getterElement(elementGenerationContext) == null ? factory::generateElement : factory::updateElement;
            PsiElement createdElement = this.performOperation(factory, elementGenerationContext, operation);
            if (createdElement != null) {
                factory.setterElement(elementGenerationContext, createdElement);
            }
        }
        return elementGenerationContext;
    }

    private PsiElement performOperation(ServicePsiElementGenerator<ElementGenerationContext> factory, ElementGenerationContext elementGenerationContext, Function<ElementGenerationContext, PsiElement> operation) {
        ElementGenerationContext context = (ElementGenerationContext)ApplicationManager.getApplication().runReadAction(() -> {
            factory.updateCommonPropertyContext(elementGenerationContext);
            factory.setCustomProperties(elementGenerationContext);
            return elementGenerationContext;
        });
        if (factory.isApplicable(context)) {
            return operation.apply(context);
        }
        return null;
    }
}

