/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.macro;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.macro.MacroBase;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonNumberLiteral;
import com.intellij.json.psi.JsonObject;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.cxbox.intellij.community.common.conf.JView;
import org.cxbox.intellij.community.common.util.JsonFacade;
import org.cxbox.intellij.community.liveTemplate.PlatformWidgetFieldsContext;

public class WidgetPositionTagMacro
extends MacroBase {
    public WidgetPositionTagMacro() {
        super("widgetPositionTagMacro", "widgetPositionTagMacro()");
    }

    private WidgetPositionTagMacro(String name, String description) {
        super(name, description);
    }

    protected Result calculateResult(Expression[] prms, ExpressionContext context, boolean quick) {
        PsiFile containingFile = context.getPsiElementAtStartOffset().getContainingFile();
        if (!(containingFile instanceof JsonFile)) {
            return null;
        }
        PsiElement psiElementAtStartOffset = context.getPsiElementAtStartOffset();
        JsonObject currentTemplate = JsonFacade.getNextSiblingOfType(psiElementAtStartOffset, JsonObject.class);
        JsonObject previousWidget = JsonFacade.getPrevSiblingOfType((PsiElement)currentTemplate, JsonObject.class);
        JsonObject nextWidget = JsonFacade.getNextSiblingOfType((PsiElement)currentTemplate, JsonObject.class);
        JsonNumberLiteral previousWidgetPosition = JsonFacade.safeGetPropertyValueOfType(previousWidget, JView.WIDGETS_WIDGET_POSITION);
        JsonNumberLiteral nextWidgetPosition = JsonFacade.safeGetPropertyValueOfType(nextWidget, JView.WIDGETS_WIDGET_POSITION);
        Double prev = JsonFacade.safeGetValueAsDouble((PsiElement)previousWidgetPosition);
        Double next = JsonFacade.safeGetValueAsDouble((PsiElement)nextWidgetPosition);
        if (next != null && prev != null) {
            double v = next + prev;
            return new TextResult(String.valueOf(Math.round(v / 2.0)));
        }
        if (next == null && prev != null) {
            return new TextResult(String.valueOf(Math.round(prev + 1.0)));
        }
        if (next != null && prev == null) {
            return new TextResult(String.valueOf(Math.max(Math.round(next - 1.0), 0L)));
        }
        if (next == null && prev == null) {
            return new TextResult(String.valueOf(Math.round(0.0f)));
        }
        return new TextResult("0");
    }

    public boolean isAcceptableInContext(TemplateContextType context) {
        return context instanceof PlatformWidgetFieldsContext;
    }
}

