/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.java.postAction;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiMethodPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import java.util.Objects;
import java.util.stream.Stream;
import org.cxbox.intellij.community.common.Cache;
import org.cxbox.intellij.community.common.util.DtoMetaModelUtil;
import org.cxbox.intellij.community.common.util.JavaExpressionUtil;
import org.cxbox.intellij.community.common.util.QuickFixUtils;
import org.cxbox.intellij.community.common.util.ResponseServiceUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DrillDownAndWaitUntilInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final String METHOD_NAME = "drillDownAndWaitUntil";
    private static final String CLASS_QUALIFIED_NAME = ".core.dto.rowmeta.PostAction";
    private static final ElementPattern<PsiMethodCallExpression> DRILL_DOWN_AND_WAIT_UTIL_PATTERN = StandardPatterns.or((ElementPattern[])((ElementPattern[])Stream.of(Cache.PLATFORM_1, "org.cxbox").map(prefix -> PsiJavaPatterns.psiExpression().methodCall((ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName(METHOD_NAME)).definedInClass(prefix + CLASS_QUALIFIED_NAME).withParameterCount(4))).toArray(ElementPattern[]::new)));

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            DrillDownAndWaitUntilInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            DrillDownAndWaitUntilInspection.$$$reportNull$$$0(1);
        }
        return new JavaElementVisitor(){

            public void visitCallExpression(@NotNull PsiCallExpression callExpression) {
                PsiExpression metaModalDto;
                PsiClass dtoMetaModel;
                PsiClass dto;
                Module module;
                if (callExpression == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)callExpression)) == null) {
                    return;
                }
                if (DRILL_DOWN_AND_WAIT_UTIL_PATTERN.accepts((Object)callExpression) && (dto = DrillDownAndWaitUntilInspection.this.getDto(callExpression, module)) != null && ((dtoMetaModel = DrillDownAndWaitUntilInspection.this.getDtoFromMetaModelArg(callExpression, dto)) == null || !Objects.equals(dtoMetaModel.getQualifiedName(), dto.getQualifiedName())) && (metaModalDto = JavaExpressionUtil.getArgumentByIndex(callExpression, 2)) != null) {
                    holder.registerProblem(holder.getManager().createProblemDescriptor((PsiElement)metaModalDto.getContainingFile(), metaModalDto.getTextRange(), DrillDownAndWaitUntilInspection.this.getServiceName(callExpression) + " related to another DTO " + dto.getName(), ProblemHighlightType.GENERIC_ERROR, true, new LocalQuickFix[]{new Fix((PsiReferenceExpression)metaModalDto, dto, callExpression)}));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "org/cxbox/intellij/community/java/postAction/DrillDownAndWaitUntilInspection$1", "visitCallExpression"));
            }
        };
    }

    private PsiClass getDto(PsiCallExpression arg, Module module) {
        String serviceName = this.getServiceName(arg);
        return ResponseServiceUtils.getAllResponseServiceData(arg.getProject(), module).stream().filter(Objects::nonNull).filter(service -> service.responseServicePsiClass().getName() != null && service.responseServicePsiClass().getName().equals(serviceName)).map(ResponseServiceUtils.ResponseServiceData::responseServiceDtoPsiClass).findFirst().orElse(null);
    }

    private String getServiceName(PsiCallExpression arg) {
        PsiEnumConstant psiEnumConst;
        PsiElement psiElement;
        PsiReferenceExpression psiReferenceExpression;
        PsiElement enumConst;
        PsiExpression secondArg = JavaExpressionUtil.getArgumentByIndex(arg, 1);
        if (secondArg instanceof PsiReferenceExpression && (enumConst = (psiReferenceExpression = (PsiReferenceExpression)secondArg).resolve()) != null && (psiElement = enumConst.getOriginalElement()) instanceof PsiEnumConstant && (psiEnumConst = (PsiEnumConstant)psiElement).getArgumentList() != null && psiEnumConst.getArgumentList().getExpressions().length > 0 && psiEnumConst.getArgumentList().getExpressions()[0].getOriginalElement().getChildren().length > 0) {
            return psiEnumConst.getArgumentList().getExpressions()[0].getOriginalElement().getChildren()[0].getText();
        }
        return null;
    }

    @Nullable
    private PsiClass getDtoFromMetaModelArg(@NotNull PsiCallExpression callExpression, @NotNull PsiClass dto) {
        PsiFile psiFile;
        PsiExpression metaModelFromArgs;
        if (callExpression == null) {
            DrillDownAndWaitUntilInspection.$$$reportNull$$$0(2);
        }
        if (dto == null) {
            DrillDownAndWaitUntilInspection.$$$reportNull$$$0(3);
        }
        if ((metaModelFromArgs = JavaExpressionUtil.getArgumentByIndex(callExpression, 2)) != null && dto.getContainingFile() != null && (psiFile = dto.getContainingFile()) instanceof PsiJavaFile) {
            PsiJavaFile psiJavaFile = (PsiJavaFile)psiFile;
            return DtoMetaModelUtil.getDtoFromMetaModel(metaModelFromArgs);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dto";
                break;
            }
        }
        objectArray2[1] = "org/cxbox/intellij/community/java/postAction/DrillDownAndWaitUntilInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getDtoFromMetaModelArg";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public record Fix(PsiReferenceExpression field, PsiClass dto, PsiCallExpression pce) implements LocalQuickFix
    {
        public boolean availableInBatchMode() {
            return false;
        }

        @NotNull
        public String getName() {
            return "Replacing DTO and calling autocompletion";
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            return "Replacing DTO and calling autocompletion";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                Fix.$$$reportNull$$$0(0);
            }
            if (descriptor == null) {
                Fix.$$$reportNull$$$0(1);
            }
            PsiElementFactory factory = PsiElementFactory.getInstance((Project)project);
            if (this.field != null) {
                FileEditor fileEditor;
                FileEditor[] editors;
                PsiExpression newExpression = factory.createExpressionFromText(this.dto.getQualifiedName() + "_.", null);
                PsiElement newField = this.field.getOriginalElement().replace((PsiElement)newExpression);
                VirtualFile virtualFile = this.pce.getContainingFile().getVirtualFile();
                if (virtualFile != null && (editors = FileEditorManager.getInstance((Project)project).getEditors(virtualFile)).length > 0 && (fileEditor = editors[0]) instanceof TextEditor) {
                    TextEditor textEditor = (TextEditor)fileEditor;
                    Editor editor = textEditor.getEditor();
                    ApplicationManager.getApplication().invokeLater(() -> {
                        CaretModel caretModel = editor.getCaretModel();
                        caretModel.moveToOffset(newField.getTextRange().getEndOffset());
                        QuickFixUtils.safeInvokeAutocompleteAndDoPostponedOperations(project, newField);
                    });
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "descriptor";
                    break;
                }
            }
            objectArray[1] = "org/cxbox/intellij/community/java/postAction/DrillDownAndWaitUntilInspection$Fix";
            objectArray[2] = "applyFix";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

