/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.common.util;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.List;
import org.cxbox.intellij.community.java.searchParameter.reference.commentEntityName.FullyNameInCommentInspection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiCommentUtil {
    @Nullable
    public static String getCommentWithPrefixesAndFullyName(@NotNull PsiElement dtoPsiField, @NotNull List<String> prefixes) {
        PsiClass dtoClass;
        if (dtoPsiField == null) {
            PsiCommentUtil.$$$reportNull$$$0(0);
        }
        if (prefixes == null) {
            PsiCommentUtil.$$$reportNull$$$0(1);
        }
        PsiClass psiClass = dtoClass = dtoPsiField instanceof PsiClass ? (PsiClass)dtoPsiField : (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)dtoPsiField, PsiClass.class);
        if (dtoClass != null) {
            ArrayList<PsiElement> children = new ArrayList<PsiElement>(List.of(dtoClass.getContainingFile().getChildren()));
            for (PsiElement child : children) {
                if (child instanceof PsiClass) {
                    for (PsiElement childFromList : child.getChildren()) {
                        boolean result = PsiCommentUtil.checkElement(childFromList, prefixes);
                        if (!result) continue;
                        return FullyNameInCommentInspection.getCommentFromMultiComment(childFromList.getText());
                    }
                    continue;
                }
                boolean result = PsiCommentUtil.checkElement(child, prefixes);
                if (!result) continue;
                return FullyNameInCommentInspection.getCommentFromMultiComment(child.getText());
            }
        }
        return null;
    }

    private static boolean checkElement(@NotNull PsiElement element, @NotNull List<String> prefixes) {
        if (element == null) {
            PsiCommentUtil.$$$reportNull$$$0(2);
        }
        if (prefixes == null) {
            PsiCommentUtil.$$$reportNull$$$0(3);
        }
        if (element instanceof PsiComment && prefixes.stream().anyMatch(prefix -> element.getText().contains((CharSequence)prefix))) {
            return true;
        }
        if (element instanceof PsiModifierList) {
            PsiModifierList psiModifierList = (PsiModifierList)element;
            for (PsiElement childFromList : psiModifierList.getChildren()) {
                String commentText;
                if (!(childFromList instanceof PsiComment) || !prefixes.stream().anyMatch(prefix -> childFromList.getText().contains((CharSequence)prefix)) || (commentText = FullyNameInCommentInspection.getCommentFromMultiComment(element.getText())) == null) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containCommitWithPrefixes(@NotNull PsiElement dtoPsiField, @NotNull List<String> prefixes) {
        PsiClass dtoClass;
        if (dtoPsiField == null) {
            PsiCommentUtil.$$$reportNull$$$0(4);
        }
        if (prefixes == null) {
            PsiCommentUtil.$$$reportNull$$$0(5);
        }
        PsiClass psiClass = dtoClass = dtoPsiField instanceof PsiClass ? (PsiClass)dtoPsiField : (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)dtoPsiField, PsiClass.class);
        if (dtoClass != null) {
            ArrayList<PsiElement> children = new ArrayList<PsiElement>(List.of(dtoClass.getContainingFile().getChildren()));
            for (PsiElement child : children) {
                if (child instanceof PsiClass) {
                    for (PsiElement childFromList : child.getChildren()) {
                        boolean result = PsiCommentUtil.checkElement(childFromList, prefixes);
                        if (!result) continue;
                        return true;
                    }
                    continue;
                }
                boolean result = PsiCommentUtil.checkElement(child, prefixes);
                if (!result) continue;
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dtoPsiField";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefixes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "org/cxbox/intellij/community/common/util/PsiCommentUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getCommentWithPrefixesAndFullyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkElement";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "containCommitWithPrefixes";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

