/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.language;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import org.cxbox.intellij.community.language.SimpleElementFactory;
import org.cxbox.intellij.community.language.psi.SimpleProperty;
import org.cxbox.intellij.community.language.psi.SimpleTypes;

public class SimplePsiImplUtil {
    public static String getName(SimpleProperty element) {
        return SimplePsiImplUtil.getKey(element);
    }

    public static PsiElement setName(SimpleProperty element, String newName) {
        ASTNode keyNode = element.getNode().findChildByType(SimpleTypes.KEY);
        if (keyNode != null) {
            SimpleProperty property = SimpleElementFactory.createProperty(element.getProject(), newName);
            ASTNode newKeyNode = property.getFirstChild().getNode();
            element.getNode().replaceChild(keyNode, newKeyNode);
        }
        return element;
    }

    public static PsiElement getNameIdentifier(SimpleProperty element) {
        ASTNode keyNode = element.getNode().findChildByType(SimpleTypes.KEY);
        if (keyNode != null) {
            return keyNode.getPsi();
        }
        return null;
    }

    public static String getKey(SimpleProperty element) {
        ASTNode keyNode = element.getNode().findChildByType(SimpleTypes.KEY);
        if (keyNode != null) {
            return keyNode.getText().replaceAll("\\\\ ", " ");
        }
        return null;
    }

    public static String getValue(SimpleProperty element) {
        ASTNode valueNode = element.getNode().findChildByType(SimpleTypes.VALUE);
        if (valueNode != null) {
            return valueNode.getText();
        }
        return null;
    }
}

