/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.wigdet.name;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import org.cxbox.intellij.community.common.conf.JWidget;
import org.cxbox.intellij.community.common.util.JsonFacade;
import org.cxbox.intellij.community.common.util.QuickFixUtils;
import org.jetbrains.annotations.NotNull;

public final class WidgetNameDiffersFromFileNameInspection
extends LocalInspectionTool {
    @NotNull
    public String getShortName() {
        return "WidgetNameDiffersFromFileNameInspection";
    }

    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            WidgetNameDiffersFromFileNameInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            WidgetNameDiffersFromFileNameInspection.$$$reportNull$$$0(1);
        }
        if (!(file instanceof JsonFile)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        JsonFile widgetFile = (JsonFile)file;
        if (!file.getName().endsWith(".widget.json")) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        JsonObject widgetFileTopLevelObject = JsonFacade.getTopLevelObject(widgetFile);
        JsonStringLiteral widgetName = JsonFacade.safeGetPropertyValueOfType(widgetFileTopLevelObject, JWidget.NAME);
        SmartList descriptors = new SmartList();
        String widgetNameValue = JsonFacade.safeGetValueAsString((PsiElement)widgetName);
        if (widgetName != null && !file.getContainingFile().getName().equals(widgetNameValue + ".widget.json")) {
            descriptors.add(manager.createProblemDescriptor((PsiElement)widgetName, new TextRange(1, widgetNameValue.length() + 1), "File name should be equal to name + \".widget.json\" postfix", ProblemHighlightType.GENERIC_ERROR, true, new LocalQuickFix[]{new QuickFixUtils.RenameFileFixWithText(widgetNameValue + ".widget.json", "(1) Rename File")}));
        }
        return descriptors.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
        }
        objectArray[1] = "org/cxbox/intellij/community/wigdet/name/WidgetNameDiffersFromFileNameInspection";
        objectArray[2] = "checkFile";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

