/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.common.util;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import java.util.List;
import org.cxbox.intellij.community.common.util.EnumConstant;
import org.cxbox.intellij.community.common.util.FieldWithAnnotation;
import org.jetbrains.annotations.NotNull;

public class ClassCommon {
    public static void addEnumConstant(@NotNull Project project, PsiClass dtoPsiClass, @NotNull List<EnumConstant> fieldAndAnnotationsList) {
        if (project == null) {
            ClassCommon.$$$reportNull$$$0(0);
        }
        if (fieldAndAnnotationsList == null) {
            ClassCommon.$$$reportNull$$$0(1);
        }
        for (EnumConstant field : fieldAndAnnotationsList) {
            String fieldString = field.getText();
            if (fieldString == null) continue;
            JavaCodeStyleManager instance = JavaCodeStyleManager.getInstance((Project)dtoPsiClass.getProject());
            PsiElementFactory dtoElementFactory = JavaPsiFacade.getElementFactory((Project)project);
            PsiEnumConstant dtoField = dtoElementFactory.createEnumConstantFromText(fieldString, null);
            PsiField alreadyExistingDtoField = dtoPsiClass.findFieldByName(dtoField.getName(), true);
            if (alreadyExistingDtoField != null) continue;
            PsiEnumConstant newPsiField = field.getAfter() != null ? (PsiEnumConstant)dtoPsiClass.addAfter((PsiElement)dtoField, (PsiElement)field.getAfter()) : (PsiEnumConstant)dtoPsiClass.add((PsiElement)dtoField);
            instance.shortenClassReferences((PsiElement)newPsiField);
        }
    }

    public static void addFieldWithAnnotaions(@NotNull Project project, PsiClass dtoPsiClass, @NotNull List<FieldWithAnnotation> fieldAndAnnotationsList) {
        if (project == null) {
            ClassCommon.$$$reportNull$$$0(2);
        }
        if (fieldAndAnnotationsList == null) {
            ClassCommon.$$$reportNull$$$0(3);
        }
        for (FieldWithAnnotation field : fieldAndAnnotationsList) {
            String fieldString = field.getField();
            List<String> annotations = field.getAnnotations();
            if (fieldString == null) continue;
            JavaCodeStyleManager instance = JavaCodeStyleManager.getInstance((Project)dtoPsiClass.getProject());
            PsiElementFactory dtoElementFactory = JavaPsiFacade.getElementFactory((Project)project);
            PsiField dtoField = dtoElementFactory.createFieldFromText(fieldString, null);
            PsiField alreadyExistingDtoField = dtoPsiClass.findFieldByName(dtoField.getName(), true);
            if (alreadyExistingDtoField != null) continue;
            PsiField newPsiField = (PsiField)dtoPsiClass.add((PsiElement)dtoField);
            PsiModifierList modifierList = newPsiField.getModifierList();
            annotations.forEach(annotationText -> {
                if (modifierList != null && annotationText != null) {
                    PsiAnnotation annotationFromText = dtoElementFactory.createAnnotationFromText(annotationText, (PsiElement)dtoPsiClass);
                    PsiElement annotationPsiElement = modifierList.addAfter((PsiElement)annotationFromText, null);
                    instance.shortenClassReferences(annotationPsiElement);
                }
            });
            instance.shortenClassReferences((PsiElement)newPsiField);
            CodeStyleManager.getInstance((Project)project).reformat((PsiElement)dtoPsiClass.getContainingFile());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldAndAnnotationsList";
                break;
            }
        }
        objectArray2[1] = "org/cxbox/intellij/community/common/util/ClassCommon";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addEnumConstant";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addFieldWithAnnotaions";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

