/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.view.name;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import org.cxbox.intellij.community.common.conf.JView;
import org.cxbox.intellij.community.common.util.JsonFacade;
import org.cxbox.intellij.community.common.util.QuickFixUtils;
import org.jetbrains.annotations.NotNull;

public final class ViewNameDiffersFromFileNameInspection
extends LocalInspectionTool {
    @NotNull
    public String getShortName() {
        return "ViewNameDiffersFromFileNameInspection";
    }

    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            ViewNameDiffersFromFileNameInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            ViewNameDiffersFromFileNameInspection.$$$reportNull$$$0(1);
        }
        if (!(file instanceof JsonFile)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        JsonFile viewFile = (JsonFile)file;
        if (!file.getName().endsWith(".view.json")) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        JsonObject viewFileTopLevelObject = JsonFacade.getTopLevelObject(viewFile);
        JsonStringLiteral viewName = JsonFacade.safeGetPropertyValueOfType(viewFileTopLevelObject, JView.NAME);
        SmartList descriptors = new SmartList();
        String viewNameValue = JsonFacade.safeGetValueAsString((PsiElement)viewName);
        if (viewName != null && !file.getContainingFile().getName().equals(viewNameValue + ".view.json")) {
            descriptors.add(manager.createProblemDescriptor((PsiElement)viewName, new TextRange(1, viewNameValue.length() + 1), "File name should be equal to name + \".view.json\" postfix", ProblemHighlightType.GENERIC_ERROR, true, new LocalQuickFix[]{new QuickFixUtils.RenameFileFixWithText(viewNameValue + ".view.json", "(1) Rename File")}));
        }
        return descriptors.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
        }
        objectArray[1] = "org/cxbox/intellij/community/view/name/ViewNameDiffersFromFileNameInspection";
        objectArray[2] = "checkFile";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

