/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.screen.view;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.fileTemplates.actions.CreateFromTemplateActionBase;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.lang3.tuple.Triple;
import org.cxbox.intellij.community.common.conf.JScreen;
import org.cxbox.intellij.community.common.conf.JView;
import org.cxbox.intellij.community.common.util.JsonFacade;
import org.cxbox.intellij.community.screen.view.ViewNameReferenceContributor;
import org.jetbrains.annotations.NotNull;

public final class ViewNameInspection
extends LocalInspectionTool {
    @NotNull
    public String getShortName() {
        return "ViewNameInspection";
    }

    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            ViewNameInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            ViewNameInspection.$$$reportNull$$$0(1);
        }
        if (!(file instanceof JsonFile)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        if (!file.getName().endsWith(".screen.json")) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        Project project = file.getProject();
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)file);
        if (module == null) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        SmartList descriptors = new SmartList();
        Arrays.stream(file.getChildren()).filter(Objects::nonNull).forEach(arg_0 -> this.lambda$checkFile$0(manager, (List)descriptors, project, module, arg_0));
        return descriptors.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    private void extracted(@NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> descriptors, @NotNull PsiElement c, @NotNull Project project, @NotNull Module module) {
        if (manager == null) {
            ViewNameInspection.$$$reportNull$$$0(2);
        }
        if (descriptors == null) {
            ViewNameInspection.$$$reportNull$$$0(3);
        }
        if (c == null) {
            ViewNameInspection.$$$reportNull$$$0(4);
        }
        if (project == null) {
            ViewNameInspection.$$$reportNull$$$0(5);
        }
        if (module == null) {
            ViewNameInspection.$$$reportNull$$$0(6);
        }
        if (ViewNameReferenceContributor.Holder.SCREEN_VIEW_NAME_PATTERN.accepts((Object)c)) {
            Optional link = (Optional)JView.getLinkAndAutocompletionByViewName(((JsonStringLiteral)c).getValue(), project, module).getFirst();
            if (link.isEmpty() && !"hiddenView".equals(JsonFacade.safeGetValueAsString(c))) {
                descriptors.add(manager.createProblemDescriptor(c, new TextRange(1, ((JsonStringLiteral)c).getValue().length() + 1), "Incorrect value. Use autocomplete to provide correct one", ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, true, new LocalQuickFix[]{new CreateViewFix()}));
            }
        } else {
            Arrays.stream(c.getChildren()).forEach(c2 -> this.extracted(manager, descriptors, (PsiElement)c2, project, module));
        }
    }

    private /* synthetic */ void lambda$checkFile$0(InspectionManager manager, List descriptors, Project project, Module module, PsiElement c) {
        this.extracted(manager, descriptors, c, project, module);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        objectArray2[1] = "org/cxbox/intellij/community/screen/view/ViewNameInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkFile";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "extracted";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class CreateViewFix
    implements LocalQuickFix {
        private CreateViewFix() {
        }

        @NotNull
        private static Triple<FileTemplate, String, Properties> getScreenViewTemplateData(@NotNull Project project, @NotNull Module module, PsiElement viewNamePsiElement) {
            if (project == null) {
                CreateViewFix.$$$reportNull$$$0(0);
            }
            if (module == null) {
                CreateViewFix.$$$reportNull$$$0(1);
            }
            FileTemplate template = FileTemplateManager.getInstance((Project)project).getJ2eeTemplate("PlatformViewTab");
            String viewName = JsonFacade.safeGetValueAsString(viewNamePsiElement);
            JsonFile screenFile = (JsonFile)viewNamePsiElement.getContainingFile();
            String screenName = JScreen.getScreenName(screenFile);
            Integer level = JScreen.getScreenViewLevel(viewNamePsiElement);
            String tabsWidgetName = JScreen.getLevelToTabsWidgetName(project, module).getOrDefault(level, "CHANGE_ME").replace(".widget.json", "");
            Properties properties = new Properties();
            properties.setProperty("screen", screenName);
            properties.setProperty("tabsWidget", tabsWidgetName);
            Triple triple = Triple.of((Object)template, (Object)viewName, (Object)properties);
            if (triple == null) {
                CreateViewFix.$$$reportNull$$$0(2);
            }
            return triple;
        }

        public boolean availableInBatchMode() {
            return false;
        }

        @NotNull
        public String getName() {
            return "Create view";
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            return "Create view";
        }

        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
            if (project == null) {
                CreateViewFix.$$$reportNull$$$0(3);
            }
            if (previewDescriptor == null) {
                CreateViewFix.$$$reportNull$$$0(4);
            }
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                CreateViewFix.$$$reportNull$$$0(5);
            }
            return intentionPreviewInfo;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                CreateViewFix.$$$reportNull$$$0(6);
            }
            if (descriptor == null) {
                CreateViewFix.$$$reportNull$$$0(7);
            }
            try {
                PsiElement viewNamePsiElement = descriptor.getPsiElement();
                Module module = ModuleUtil.findModuleForPsiElement((PsiElement)viewNamePsiElement);
                if (module == null) {
                    return;
                }
                Triple<FileTemplate, String, Properties> templateData = CreateViewFix.getScreenViewTemplateData(project, module, viewNamePsiElement);
                FileTemplate template = (FileTemplate)templateData.getLeft();
                Properties props = (Properties)templateData.getRight();
                String viewName = (String)templateData.getMiddle();
                PsiDirectory screenDirectory = viewNamePsiElement.getContainingFile().getContainingDirectory();
                PsiDirectory viewSubDir = screenDirectory.findSubdirectory("views");
                viewSubDir = viewSubDir == null ? screenDirectory.findSubdirectory("view") : viewSubDir;
                viewSubDir = viewSubDir == null ? screenDirectory.createSubdirectory("views") : viewSubDir;
                PsiElement file = FileTemplateUtil.createFromTemplate((FileTemplate)template, (String)(viewName + ".view.json"), (Properties)props, (PsiDirectory)viewSubDir);
                if (template != null && template.isLiveTemplateEnabled() && file instanceof PsiFile) {
                    CreateFromTemplateActionBase.startLiveTemplate((PsiFile)((PsiFile)file));
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/cxbox/intellij/community/screen/view/ViewNameInspection$CreateViewFix";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "previewDescriptor";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/cxbox/intellij/community/screen/view/ViewNameInspection$CreateViewFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getScreenViewTemplateData";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generatePreview";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getScreenViewTemplateData";
                    break;
                }
                case 2: 
                case 5: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "generatePreview";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 5 -> new IllegalStateException(string);
            };
        }
    }
}

