/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.spell;

import com.google.common.base.CaseFormat;
import com.intellij.spellchecker.dictionary.Dictionary;
import com.intellij.spellchecker.dictionary.RuntimeDictionaryProvider;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.cxbox.intellij.community.common.Cache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PlatformSpell
implements Dictionary {
    PlatformSpell() {
    }

    @NotNull
    public String getName() {
        return "Platform name variants";
    }

    @Nullable
    public Boolean contains(@NotNull String word) {
        if (word == null) {
            PlatformSpell.$$$reportNull$$$0(0);
        }
        return this.getWords().contains(word);
    }

    @NotNull
    public Set<String> getWords() {
        HashSet<String> result = new HashSet<String>();
        String platform1 = Cache.PLATFORM_1.split("\\.")[1];
        String platform2 = "org.cxbox".split("\\.")[1];
        result.addAll(this.getVariants(platform1));
        result.addAll(this.getVariants(platform2));
        HashSet<String> hashSet = result;
        if (hashSet == null) {
            PlatformSpell.$$$reportNull$$$0(1);
        }
        return hashSet;
    }

    private Set<String> getVariants(String platform1) {
        HashSet<String> result = new HashSet<String>();
        result.add(platform1);
        result.add(CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, platform1));
        result.add(CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, platform1));
        result.add(CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, platform1));
        result.add(CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_HYPHEN, platform1));
        result.add(CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, platform1));
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "word";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/cxbox/intellij/community/spell/PlatformSpell";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/cxbox/intellij/community/spell/PlatformSpell";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getWords";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    public static class PlatformSpellProvider
    implements RuntimeDictionaryProvider {
        public Dictionary[] getDictionaries() {
            return List.of(new PlatformSpell()).toArray(new PlatformSpell[0]);
        }
    }
}

