/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.action;

import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAwareAction;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ShowDocumentationAction
extends DumbAwareAction {
    private final String urlString;
    private final String alternativeUrlString;

    public ShowDocumentationAction(Icon icon, String urlString, String alternativeUrlString) {
        super(icon);
        this.urlString = urlString;
        this.alternativeUrlString = alternativeUrlString;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowDocumentationAction.$$$reportNull$$$0(0);
        }
        boolean plural = false;
        boolean enabled = false;
        boolean paths = false;
        DataContext dataContext = e.getDataContext();
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor != null && FileDocumentManager.getInstance().getFile(editor.getDocument()) != null) {
            enabled = true;
        }
        e.getPresentation().setEnabled(enabled);
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            e.getPresentation().setVisible(enabled);
        } else {
            e.getPresentation().setVisible(true);
        }
        e.getPresentation().setText("Show Documentation");
        if (paths) {
            e.getPresentation().setEnabledAndVisible(false);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowDocumentationAction.$$$reportNull$$$0(1);
        }
        if (this.checkUrl(this.urlString)) {
            BrowserUtil.open((String)this.urlString);
        } else if (this.checkUrl(this.alternativeUrlString)) {
            BrowserUtil.open((String)this.alternativeUrlString);
        } else {
            BrowserUtil.open((String)this.urlString);
        }
    }

    public boolean checkUrl(String urlString) {
        try {
            URL url = new URL(urlString);
            HttpURLConnection.setFollowRedirects(false);
            HttpURLConnection huc = (HttpURLConnection)url.openConnection();
            huc.setConnectTimeout(1000);
            huc.setReadTimeout(1000);
            int responseCode = huc.getResponseCode();
            return 200 == responseCode;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "org/cxbox/intellij/community/action/ShowDocumentationAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

