/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.screen.navigation;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.cxbox.intellij.community.common.conf.JScreen;
import org.cxbox.intellij.community.common.util.JsonFacade;
import org.jetbrains.annotations.NotNull;

public class ChildViewNameDuplicateInspection
extends LocalInspectionTool {
    private static final String STANDARD_TYPE = "standard";

    @NotNull
    public static List<JsonArray> getAllChild(@NotNull JsonArray array) {
        if (array == null) {
            ChildViewNameDuplicateInspection.$$$reportNull$$$0(0);
        }
        ArrayList<JsonArray> result = new ArrayList<JsonArray>();
        result.addAll(array.getValueList().stream().map(child -> {
            JsonArray jsonArray = JsonFacade.safeGetPropertyValueOfType((JsonObject)child, JScreen.CHILD);
            if (jsonArray != null) {
                result.add(jsonArray);
                return ChildViewNameDuplicateInspection.getAllChild(jsonArray);
            }
            return null;
        }).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).toList());
        ArrayList<JsonArray> arrayList = result;
        if (arrayList == null) {
            ChildViewNameDuplicateInspection.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    public static List<JsonArray> getMenu(@NotNull JsonFile jsonFile) {
        if (jsonFile == null) {
            ChildViewNameDuplicateInspection.$$$reportNull$$$0(2);
        }
        List<JsonArray> list = Optional.ofNullable(JScreen.getScreenNavigation(jsonFile)).stream().filter(navigation -> {
            JsonStringLiteral type = JsonFacade.safeGetPropertyValueOfType(navigation, JScreen.TYPE);
            if (type == null) {
                return false;
            }
            return STANDARD_TYPE.equals(type.getValue());
        }).map(navigation -> JsonFacade.safeGetPropertyValueOfType(navigation, JScreen.MENU)).filter(Objects::nonNull).toList();
        if (list == null) {
            ChildViewNameDuplicateInspection.$$$reportNull$$$0(3);
        }
        return list;
    }

    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            ChildViewNameDuplicateInspection.$$$reportNull$$$0(4);
        }
        if (manager == null) {
            ChildViewNameDuplicateInspection.$$$reportNull$$$0(5);
        }
        if (!(file instanceof JsonFile)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        JsonFile jsonFile = (JsonFile)file;
        if (!file.getName().endsWith(".screen.json")) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (module == null) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        SmartList descriptors = new SmartList();
        List<JsonValue> menu = ChildViewNameDuplicateInspection.getMenu(jsonFile).stream().map(array -> {
            List<JsonArray> allChild = ChildViewNameDuplicateInspection.getAllChild(array);
            allChild.add((JsonArray)array);
            return allChild;
        }).flatMap(Collection::stream).map(JsonArray::getValueList).flatMap(Collection::stream).toList();
        this.getDuplicate(menu).forEach(arg_0 -> ChildViewNameDuplicateInspection.lambda$checkFile$4((List)descriptors, manager, file, arg_0));
        return descriptors.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    @NotNull
    private List<JsonStringLiteral> getDuplicate(@NotNull List<JsonValue> jsonValues) {
        if (jsonValues == null) {
            ChildViewNameDuplicateInspection.$$$reportNull$$$0(6);
        }
        HashMap map = new HashMap();
        jsonValues.forEach(n -> {
            JsonStringLiteral viewNameValue = JsonFacade.safeGetPropertyValueOfType((JsonObject)n, JScreen.VIEW_NAME);
            if (viewNameValue != null) {
                if (!map.containsKey(viewNameValue.getValue())) {
                    map.put(viewNameValue.getValue(), new ArrayList());
                }
                ((List)map.get(viewNameValue.getValue())).add(viewNameValue);
            }
        });
        List<JsonStringLiteral> list = map.values().stream().filter(jsonObjects -> jsonObjects.size() > 1).flatMap(Collection::stream).filter(Objects::nonNull).toList();
        if (list == null) {
            ChildViewNameDuplicateInspection.$$$reportNull$$$0(7);
        }
        return list;
    }

    private static /* synthetic */ void lambda$checkFile$4(List descriptors, InspectionManager manager, PsiFile file, JsonStringLiteral value) {
        descriptors.add(manager.createProblemDescriptor((PsiElement)file, new TextRange(value.getTextOffset() + 1, value.getTextOffset() + value.getTextLength() - 1), "There must be unique \"viewName\" within one \"child\"", ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, true, new LocalQuickFix[0]));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 1: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/cxbox/intellij/community/screen/navigation/ChildViewNameDuplicateInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsonFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsonValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/cxbox/intellij/community/screen/navigation/ChildViewNameDuplicateInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllChild";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMenu";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDuplicate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAllChild";
                break;
            }
            case 1: 
            case 3: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getMenu";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDuplicate";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 7 -> new IllegalStateException(string);
        };
    }
}

