/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.wigdet.fields.field.commonProps.key;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.cxbox.intellij.community.common.conf.JWidget;
import org.cxbox.intellij.community.common.util.JsonFacade;
import org.cxbox.intellij.community.common.util.QuickFixUtils;
import org.jetbrains.annotations.NotNull;

public final class FieldKeyDuplicateInspection
extends LocalInspectionTool {
    @NotNull
    public String getShortName() {
        return "FieldKeyDuplicateInspection";
    }

    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            FieldKeyDuplicateInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            FieldKeyDuplicateInspection.$$$reportNull$$$0(1);
        }
        if (!(file instanceof JsonFile)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        JsonFile widgetFile = (JsonFile)file;
        if (!file.getName().endsWith("widget.json")) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        List<Triple<String, JsonObject, JsonArray>> widgetFields = JWidget.getWidgetFields(widgetFile);
        Map<JsonArray, List<Triple>> groupByLevel = widgetFields.stream().collect(Collectors.groupingBy(Triple::getRight));
        ArrayList problemLayoutFieldKeys = new ArrayList();
        groupByLevel.forEach((level, levelFields) -> {
            HashMap<String, List> widgetFieldsKeyToObjectsList = new HashMap<String, List>();
            levelFields.forEach(triple -> {
                String fieldKey = (String)triple.getLeft();
                JsonObject fieldObject = (JsonObject)triple.getMiddle();
                List current = widgetFieldsKeyToObjectsList.getOrDefault(fieldKey, new ArrayList());
                current.add(fieldObject);
                widgetFieldsKeyToObjectsList.put(fieldKey, current);
            });
            widgetFieldsKeyToObjectsList.forEach((k, v) -> {
                if (v.size() > 1) {
                    List<JsonStringLiteral> duplicateKeys = v.stream().skip(1L).map(o -> JsonFacade.safeGetPropertyValueOfType(o, JWidget.FIELDS_KEY)).toList();
                    problemLayoutFieldKeys.addAll(duplicateKeys);
                }
            });
        });
        SmartList descriptors = new SmartList();
        problemLayoutFieldKeys.forEach(arg_0 -> FieldKeyDuplicateInspection.lambda$checkFile$4((List)descriptors, manager, arg_0));
        return descriptors.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    private boolean excludeCompositeFieldBlock(Pair<String, JsonObject> pair) {
        return ((JsonObject)pair.getValue()).findProperty("fields") == null;
    }

    private static /* synthetic */ void lambda$checkFile$4(List descriptors, InspectionManager manager, JsonStringLiteral layoutFieldKey) {
        descriptors.add(manager.createProblemDescriptor((PsiElement)layoutFieldKey, new TextRange(1, layoutFieldKey.getValue().length() + 1), "Delete duplicate fields tag", ProblemHighlightType.GENERIC_ERROR, true, new LocalQuickFix[]{new Fix()}));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
        }
        objectArray[1] = "org/cxbox/intellij/community/wigdet/fields/field/commonProps/key/FieldKeyDuplicateInspection";
        objectArray[2] = "checkFile";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class Fix
    implements LocalQuickFix {
        private Fix() {
        }

        public boolean availableInBatchMode() {
            return false;
        }

        @NotNull
        public String getName() {
            return "Delete duplicate fields tag";
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            return "Undefined";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                Fix.$$$reportNull$$$0(0);
            }
            if (descriptor == null) {
                Fix.$$$reportNull$$$0(1);
            }
            PsiElement element = descriptor.getPsiElement();
            JsonObject fieldKeyObject = JsonFacade.getParentOfType(element, JsonObject.class);
            CodeStyleManager.getInstance((Project)project).performActionWithFormatterDisabled(() -> {
                if (fieldKeyObject != null) {
                    JsonObject prevFieldKeyObject = (JsonObject)JsonFacade.getPrevSiblingOfType((PsiElement)fieldKeyObject, JWidget.FIELDS.arrayItemType());
                    JsonArray fields = JsonFacade.getParentOfType((PsiElement)fieldKeyObject, JWidget.FIELDS.valueType());
                    if (fields != null && prevFieldKeyObject != null && prevFieldKeyObject.getNextSibling() != fieldKeyObject) {
                        fields.deleteChildRange(prevFieldKeyObject.getNextSibling(), (PsiElement)fieldKeyObject);
                    } else {
                        fieldKeyObject.delete();
                    }
                }
                QuickFixUtils.safeDoPostponedOperationsIfPossible(project, element);
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "descriptor";
                    break;
                }
            }
            objectArray[1] = "org/cxbox/intellij/community/wigdet/fields/field/commonProps/key/FieldKeyDuplicateInspection$Fix";
            objectArray[2] = "applyFix";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

