/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.common.util;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.daemon.impl.quickfix.RenameFileFix;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.json.JsonLanguage;
import com.intellij.json.psi.JsonBooleanLiteral;
import com.intellij.json.psi.JsonElementGenerator;
import com.intellij.json.psi.JsonNullLiteral;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.lang.Language;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuickFixUtils {
    public static void safeDeleteFileIfPossible(@NotNull Project project, PsiElement element) {
        PsiFile containingFile;
        VirtualFile virtualFile;
        if (project == null) {
            QuickFixUtils.$$$reportNull$$$0(0);
        }
        if ((virtualFile = (containingFile = element.getContainingFile()).getVirtualFile()) != null) {
            try {
                QuickFixUtils.safeDoPostponedOperationsIfPossible(project, element);
                WriteAction.run(() -> virtualFile.delete((Object)element));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void clearJavaLiteralValueAndInvokeAutoCompleteIfPossible(@NotNull Project project, PsiElement element) {
        if (project == null) {
            QuickFixUtils.$$$reportNull$$$0(1);
        }
        if (element.isValid() && element.isWritable() && element instanceof PsiLiteralExpression) {
            PsiLiteralExpression psiLiteralExpression = (PsiLiteralExpression)element;
            PsiLiteralExpression replacement = (PsiLiteralExpression)JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText("\"\"", element);
            CodeStyleManager.getInstance((Project)project).performActionWithFormatterDisabled(() -> psiLiteralExpression.replace((PsiElement)replacement));
            QuickFixUtils.safeInvokeAutocompleteAndDoPostponedOperations(project, element);
        }
    }

    public static void clearJsonStringLiteralValueAndInvokeAutoCompliteIfPossible(@NotNull Project project, PsiElement element) {
        if (project == null) {
            QuickFixUtils.$$$reportNull$$$0(2);
        }
        if (element.isValid() && element.isWritable() && element instanceof JsonStringLiteral) {
            JsonStringLiteral replacement = new JsonElementGenerator(project).createStringLiteral("");
            AtomicReference replace = new AtomicReference();
            CodeStyleManager.getInstance((Project)project).performActionWithFormatterDisabled(() -> replace.set(element.replace((PsiElement)replacement)));
            QuickFixUtils.safeInvokeAutocompleteAndDoPostponedOperations(project, (PsiElement)replace.get());
        }
    }

    public static void changeNullToEmptyJsonStringLiteralValueAndInvokeAutoCompliteIfPossible(@NotNull Project project, PsiElement element) {
        if (project == null) {
            QuickFixUtils.$$$reportNull$$$0(3);
        }
        if (element.isValid() && element.isWritable() && element instanceof JsonNullLiteral) {
            JsonStringLiteral replacement = new JsonElementGenerator(project).createStringLiteral("");
            AtomicReference replace = new AtomicReference();
            CodeStyleManager.getInstance((Project)project).performActionWithFormatterDisabled(() -> replace.set(element.replace((PsiElement)replacement)));
            QuickFixUtils.safeInvokeAutocompleteAndDoPostponedOperationsWithMoveCaretRight(project, (PsiElement)replace.get());
        }
    }

    public static void safeInvokeAutocompleteAndDoPostponedOperationsWithMoveCaretRight(@NotNull Project project, @Nullable PsiElement element) {
        FileEditor fileEditor;
        EditorEx editor;
        VirtualFile virtualFile;
        if (project == null) {
            QuickFixUtils.$$$reportNull$$$0(4);
        }
        if (element != null && (virtualFile = element.getContainingFile().getVirtualFile()) != null && (editor = EditorUtil.getEditorEx((FileEditor)(fileEditor = FileEditorManager.getInstance((Project)project).getSelectedEditor(virtualFile)))) != null) {
            QuickFixUtils.moveCaretRight((Editor)editor);
            ApplicationUtil.showDialogAfterWriteAction(() -> new CodeCompletionHandlerBase(CompletionType.BASIC).invokeCompletion(project, (Editor)editor));
            PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument((Document)editor.getDocument());
        }
    }

    private static void moveCaretRight(@NotNull Editor editor) {
        int documentLength;
        CaretModel caretModel;
        int offset;
        if (editor == null) {
            QuickFixUtils.$$$reportNull$$$0(5);
        }
        if ((offset = (caretModel = editor.getCaretModel()).getOffset()) < (documentLength = editor.getDocument().getTextLength())) {
            caretModel.moveToOffset(offset + 1);
        }
    }

    public static void safeInvokeAutocompleteAndDoPostponedOperations(@NotNull Project project, @Nullable PsiElement element) {
        FileEditor fileEditor;
        EditorEx editor;
        VirtualFile virtualFile;
        if (project == null) {
            QuickFixUtils.$$$reportNull$$$0(6);
        }
        if (element != null && (virtualFile = element.getContainingFile().getVirtualFile()) != null && (editor = EditorUtil.getEditorEx((FileEditor)(fileEditor = FileEditorManager.getInstance((Project)project).getSelectedEditor(virtualFile)))) != null) {
            ApplicationUtil.showDialogAfterWriteAction(() -> new CodeCompletionHandlerBase(CompletionType.BASIC).invokeCompletion(project, (Editor)editor));
            PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument((Document)editor.getDocument());
        }
    }

    public static void changeJavaLiteralValueAndInvokeAutoCompleteIfPossible(@NotNull Project project, PsiElement element, String newValue, int offSetForCaret, PsiFile file) {
        if (project == null) {
            QuickFixUtils.$$$reportNull$$$0(7);
        }
        if (element.isValid() && element.isWritable() && element instanceof PsiLiteralExpression) {
            PsiLiteralExpression psiLiteralExpression = (PsiLiteralExpression)element;
            PsiLiteralExpression replacement = (PsiLiteralExpression)JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText(newValue, element);
            CodeStyleManager.getInstance((Project)project).performActionWithFormatterDisabled(() -> psiLiteralExpression.replace((PsiElement)replacement));
            QuickFixUtils.invokeAutoCompleteIfPossible(project, offSetForCaret, file);
        }
    }

    private static void invokeAutoCompleteIfPossible(@NotNull Project project, int offSetForCaret, PsiFile file) {
        FileEditor fileEditor;
        EditorEx editorEx;
        VirtualFile virtualFile;
        if (project == null) {
            QuickFixUtils.$$$reportNull$$$0(8);
        }
        if ((virtualFile = file.getVirtualFile()) != null && (editorEx = EditorUtil.getEditorEx((FileEditor)(fileEditor = FileEditorManager.getInstance((Project)project).getSelectedEditor(virtualFile)))) != null) {
            CaretModel caretModel = editorEx.getCaretModel();
            caretModel.moveToOffset(offSetForCaret);
            ApplicationUtil.showDialogAfterWriteAction(() -> new CodeCompletionHandlerBase(CompletionType.BASIC).invokeCompletion(project, (Editor)editorEx));
            PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument((Document)editorEx.getDocument());
        }
    }

    public static void safeReplaceJsonStringLiteralValueWithText(@NotNull Project project, @Nullable PsiElement element, @NotNull String text) {
        if (project == null) {
            QuickFixUtils.$$$reportNull$$$0(9);
        }
        if (text == null) {
            QuickFixUtils.$$$reportNull$$$0(10);
        }
        if (element != null && element.isValid() && element.isWritable() && element instanceof JsonStringLiteral) {
            JsonStringLiteral replacement = new JsonElementGenerator(project).createStringLiteral(text);
            CodeStyleManager.getInstance((Project)project).performActionWithFormatterDisabled(() -> element.replace((PsiElement)replacement));
            QuickFixUtils.safeDoPostponedOperationsIfPossible(project, element);
        }
    }

    public static void safeReplaceJsonBooleanLiteralValueWithText(@NotNull Project project, @Nullable PsiElement element, @NotNull Boolean value) {
        PsiFileFactory fileFactory;
        PsiFile fileTrue;
        JsonBooleanLiteral replacement;
        if (project == null) {
            QuickFixUtils.$$$reportNull$$$0(11);
        }
        if (value == null) {
            QuickFixUtils.$$$reportNull$$$0(12);
        }
        if (element != null && element.isValid() && element.isWritable() && (replacement = (JsonBooleanLiteral)PsiTreeUtil.findChildOfType((PsiElement)(fileTrue = (fileFactory = PsiFileFactory.getInstance((Project)project)).createFileFromText((Language)JsonLanguage.INSTANCE, (CharSequence)value.toString())), JsonBooleanLiteral.class)) != null) {
            CodeStyleManager.getInstance((Project)project).performActionWithFormatterDisabled(() -> element.replace((PsiElement)replacement));
            QuickFixUtils.safeDoPostponedOperationsIfPossible(project, element);
        }
    }

    public static void safeDoPostponedOperationsIfPossible(@NotNull Project project, PsiElement element) {
        FileEditor fileEditor;
        EditorEx editor;
        VirtualFile virtualFile;
        if (project == null) {
            QuickFixUtils.$$$reportNull$$$0(13);
        }
        if ((virtualFile = element.getContainingFile().getVirtualFile()) != null && (editor = EditorUtil.getEditorEx((FileEditor)(fileEditor = FileEditorManager.getInstance((Project)project).getSelectedEditor(virtualFile)))) != null) {
            PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument((Document)editor.getDocument());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        objectArray2[1] = "org/cxbox/intellij/community/common/util/QuickFixUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "safeDeleteFileIfPossible";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "clearJavaLiteralValueAndInvokeAutoCompleteIfPossible";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "clearJsonStringLiteralValueAndInvokeAutoCompliteIfPossible";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "changeNullToEmptyJsonStringLiteralValueAndInvokeAutoCompliteIfPossible";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "safeInvokeAutocompleteAndDoPostponedOperationsWithMoveCaretRight";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "moveCaretRight";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "safeInvokeAutocompleteAndDoPostponedOperations";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "changeJavaLiteralValueAndInvokeAutoCompleteIfPossible";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "invokeAutoCompleteIfPossible";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "safeReplaceJsonStringLiteralValueWithText";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "safeReplaceJsonBooleanLiteralValueWithText";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "safeDoPostponedOperationsIfPossible";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public record ClearJsonPsiLiteralValueAndCallAutocompletionFix(String msg, PsiElement element) implements LocalQuickFix
    {
        public boolean availableInBatchMode() {
            return false;
        }

        @NotNull
        public String getName() {
            String string = this.msg;
            if (string == null) {
                ClearJsonPsiLiteralValueAndCallAutocompletionFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = this.msg;
            if (string == null) {
                ClearJsonPsiLiteralValueAndCallAutocompletionFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                ClearJsonPsiLiteralValueAndCallAutocompletionFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                ClearJsonPsiLiteralValueAndCallAutocompletionFix.$$$reportNull$$$0(3);
            }
            QuickFixUtils.clearJsonStringLiteralValueAndInvokeAutoCompliteIfPossible(project, this.element);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/cxbox/intellij/community/common/util/QuickFixUtils$ClearJsonPsiLiteralValueAndCallAutocompletionFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/cxbox/intellij/community/common/util/QuickFixUtils$ClearJsonPsiLiteralValueAndCallAutocompletionFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    public record ClearJavaPsiLiteralValueAndCallAutocompletionFix(String msg, PsiElement element) implements LocalQuickFix
    {
        public boolean availableInBatchMode() {
            return false;
        }

        @NotNull
        public String getName() {
            String string = this.msg;
            if (string == null) {
                ClearJavaPsiLiteralValueAndCallAutocompletionFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = this.msg;
            if (string == null) {
                ClearJavaPsiLiteralValueAndCallAutocompletionFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                ClearJavaPsiLiteralValueAndCallAutocompletionFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                ClearJavaPsiLiteralValueAndCallAutocompletionFix.$$$reportNull$$$0(3);
            }
            QuickFixUtils.clearJavaLiteralValueAndInvokeAutoCompleteIfPossible(project, descriptor.getPsiElement());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/cxbox/intellij/community/common/util/QuickFixUtils$ClearJavaPsiLiteralValueAndCallAutocompletionFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/cxbox/intellij/community/common/util/QuickFixUtils$ClearJavaPsiLiteralValueAndCallAutocompletionFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    public static class RenameFileFixWithText
    extends RenameFileFix {
        private final String text;

        public RenameFileFixWithText(@NotNull String newFileName, @Nullable String text) {
            if (newFileName == null) {
                RenameFileFixWithText.$$$reportNull$$$0(0);
            }
            super(newFileName);
            this.text = text;
        }

        @NotNull
        public String getText() {
            String string = this.text != null ? this.text : CodeInsightBundle.message((String)"rename.file.fix", (Object[])new Object[0]);
            if (string == null) {
                RenameFileFixWithText.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newFileName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/cxbox/intellij/community/common/util/QuickFixUtils$RenameFileFixWithText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/cxbox/intellij/community/common/util/QuickFixUtils$RenameFileFixWithText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

