/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.common.util;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerConfigurationImpl;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.util.DirectoryUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.cxbox.intellij.community.common.Cache;
import org.cxbox.intellij.community.common.util.ClassCommon;
import org.cxbox.intellij.community.common.util.FieldWithAnnotation;
import org.cxbox.intellij.community.exception.PlatformValidationException;
import org.cxbox.intellij.community.wigdet.fields.field.generator.TemplatesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class DtoMetaModelUtil {
    @NotNull
    public static Pair<String, Boolean> syncDtoMetaModelClass(@NotNull PsiClass dtoPsiClass, @NotNull JavaPsiFacade javaPsiFacade, @NotNull GlobalSearchScope scp) {
        if (dtoPsiClass == null) {
            DtoMetaModelUtil.$$$reportNull$$$0(0);
        }
        if (javaPsiFacade == null) {
            DtoMetaModelUtil.$$$reportNull$$$0(1);
        }
        if (scp == null) {
            DtoMetaModelUtil.$$$reportNull$$$0(2);
        }
        @NotNull Project project = dtoPsiClass.getProject();
        PsiClass dtoMetaPsiClz = DtoMetaModelUtil.getOrGenerateMetaModelClass(dtoPsiClass);
        Module module = DtoMetaModelUtil.findModule(dtoMetaPsiClz, project);
        String pkg = Cache.getPlatformRootPackageWithoutDot(project, module);
        ApplicationManager.getApplication().runWriteAction(() -> Arrays.stream(dtoPsiClass.getFields()).forEach(field -> {
            ArrayList<FieldWithAnnotation> dtoMetaModelFields = new ArrayList<FieldWithAnnotation>();
            PsiType patt3833$temp = field.getType();
            if (patt3833$temp instanceof PsiClassType) {
                PsiClassType type = (PsiClassType)patt3833$temp;
                String dtoField = TemplatesKt.getDtoMetaModelFieldBasic(dtoPsiClass, pkg, field.getName(), type);
                FieldWithAnnotation fieldWithAnnotation = new FieldWithAnnotation();
                fieldWithAnnotation.setField(dtoField);
                dtoMetaModelFields.add(fieldWithAnnotation);
                ClassCommon.addFieldWithAnnotaions(project, dtoMetaPsiClz, dtoMetaModelFields);
            }
        }));
        Pair pair = Pair.pair((Object)Objects.requireNonNull(dtoMetaPsiClz.getQualifiedName()), (Object)true);
        if (pair == null) {
            DtoMetaModelUtil.$$$reportNull$$$0(3);
        }
        return pair;
    }

    @Nullable
    public static PsiClass getDtoFromMetaModel(@NotNull PsiExpression metaModelField) {
        if (metaModelField == null) {
            DtoMetaModelUtil.$$$reportNull$$$0(4);
        }
        try {
            PsiField psiField;
            PsiReferenceExpression ref;
            PsiElement psiElement;
            if (metaModelField instanceof PsiReferenceExpression && (psiElement = (ref = (PsiReferenceExpression)metaModelField).resolve()) instanceof PsiField && (psiElement = (psiField = (PsiField)psiElement).getParent()) instanceof PsiClass) {
                PsiClass psiClass = (PsiClass)psiElement;
                Project prj = psiClass.getProject();
                JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)prj);
                String metaDtoFqn = psiClass.getQualifiedName();
                if (metaDtoFqn != null) {
                    String dtoFqn = metaDtoFqn.substring(0, metaDtoFqn.lastIndexOf("_"));
                    return javaPsiFacade.findClass(dtoFqn, GlobalSearchScope.allScope((Project)prj));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @NotNull
    private static PsiClass getOrGenerateMetaModelClass(@NotNull PsiClass dtoPsiClass) {
        PsiClass dtoMetaPsiClz;
        PsiClass aClass;
        if (dtoPsiClass == null) {
            DtoMetaModelUtil.$$$reportNull$$$0(5);
        }
        if ((aClass = DtoMetaModelUtil.findMetaModelClass(dtoPsiClass)) != null) {
            PsiClass psiClass = aClass;
            if (psiClass == null) {
                DtoMetaModelUtil.$$$reportNull$$$0(6);
            }
            return psiClass;
        }
        PsiClass psiClass = dtoMetaPsiClz = DtoMetaModelUtil.generateDtoMetaModelClass(dtoPsiClass, "PlatformEmptyDTO_");
        if (psiClass == null) {
            DtoMetaModelUtil.$$$reportNull$$$0(7);
        }
        return psiClass;
    }

    private static PsiClass findMetaModelClass(PsiClass dtoPsiClass) {
        PsiFile[] files = FilenameIndex.getFilesByName((Project)dtoPsiClass.getProject(), (String)(dtoPsiClass.getName() + "_.java"), (GlobalSearchScope)GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)DtoMetaModelUtil.findModule(dtoPsiClass, dtoPsiClass.getProject())));
        if (files.length == 0) {
            return null;
        }
        PsiJavaFile psiFile = (PsiJavaFile)files[0];
        PsiClass[] classes = psiFile.getClasses();
        if (classes.length == 0) {
            return null;
        }
        return classes[0];
    }

    @NotNull
    private static PsiClass generateDtoMetaModelClass(@NotNull PsiClass dtoPsiClass, @NotNull String templateName) throws PlatformValidationException {
        PsiClass psiClass;
        String genPath;
        if (dtoPsiClass == null) {
            DtoMetaModelUtil.$$$reportNull$$$0(8);
        }
        if (templateName == null) {
            DtoMetaModelUtil.$$$reportNull$$$0(9);
        }
        Project project = dtoPsiClass.getProject();
        Module tagetModule = DtoMetaModelUtil.findModule(dtoPsiClass, project);
        CompilerConfiguration config = CompilerConfiguration.getInstance((Project)project);
        if (!config.getAnnotationProcessingConfiguration(tagetModule).isEnabled()) {
            CompilerConfigurationImpl compilerConfiguration = (CompilerConfigurationImpl)CompilerConfiguration.getInstance((Project)project);
            compilerConfiguration.getDefaultProcessorProfile().setEnabled(true);
        }
        if ((genPath = CompilerPaths.getAnnotationProcessorsGenerationPath((Module)tagetModule, (boolean)false)) == null) {
            throw new PlatformValidationException("Please, enable 'java annotation processing' and specify production gen path. Auto add field is not available till this is done", null, project);
        }
        PsiDirectory generatedSourcesPsiDir = (PsiDirectory)ApplicationManager.getApplication().runWriteAction(() -> {
            String fixUpSeparators = genPath.replace(File.separatorChar, '/');
            return DirectoryUtil.mkdirs((PsiManager)PsiManager.getInstance((Project)project), (String)fixUpSeparators);
        });
        PsiDirectory dtoMetaClassDir = (PsiDirectory)ApplicationManager.getApplication().runWriteAction(() -> DtoMetaModelUtil.createPackageDirsIfNeeded(dtoPsiClass, generatedSourcesPsiDir));
        DtoMetaModelUtil.addGeneratedSourcesDirToProjectStructureIfNeeded(tagetModule, dtoMetaClassDir, generatedSourcesPsiDir);
        PsiClass dtoMetaModelClass = DtoMetaModelUtil.findMetaModelClass(dtoPsiClass);
        if (dtoMetaModelClass != null) {
            PsiClass psiClass2 = dtoMetaModelClass;
            if (psiClass2 == null) {
                DtoMetaModelUtil.$$$reportNull$$$0(10);
            }
            return psiClass2;
        }
        try {
            FileTemplate template = FileTemplateManager.getInstance((Project)dtoPsiClass.getProject()).getJ2eeTemplate(templateName);
            Properties props = DtoMetaModelUtil.getProperties(dtoPsiClass);
            psiClass = (PsiClass)FileTemplateUtil.createFromTemplate((FileTemplate)template, (String)(dtoPsiClass.getContainingFile().getName().replace(".java", "") + "_.java"), (Properties)props, (PsiDirectory)dtoMetaClassDir);
        }
        catch (Exception e) {
            throw new PlatformValidationException("DTO_ creation for <a href=\"1\">class</a> from template " + templateName + " was not successfull. Auto add field is not available", (NavigatablePsiElement)dtoPsiClass, e, project);
        }
        if (psiClass == null) {
            DtoMetaModelUtil.$$$reportNull$$$0(11);
        }
        return psiClass;
    }

    @NotNull
    private static Module findModule(@NotNull PsiClass dtoPsiClass, Project project) {
        if (dtoPsiClass == null) {
            DtoMetaModelUtil.$$$reportNull$$$0(12);
        }
        String fileName = dtoPsiClass.getContainingFile().getName();
        Module[] modules = ModuleManager.getInstance((Project)project).getModules();
        Module tagetModule = null;
        for (Module module : modules) {
            GlobalSearchScope moduleScope = module.getModuleScope();
            Collection virtualFilesByName = FilenameIndex.getVirtualFilesByName((String)fileName, (GlobalSearchScope)moduleScope);
            if (virtualFilesByName.isEmpty()) continue;
            tagetModule = module;
        }
        if (tagetModule == null) {
            throw new PlatformValidationException("DTO_ creation for  <a href=\"1\">class</a> was not successfull. Target folder not found. Auto add field is not available", (NavigatablePsiElement)dtoPsiClass, project);
        }
        Module module = tagetModule;
        if (module == null) {
            DtoMetaModelUtil.$$$reportNull$$$0(13);
        }
        return module;
    }

    @NotNull
    private static Properties getProperties(@NotNull PsiClass dtoPsiClass) {
        if (dtoPsiClass == null) {
            DtoMetaModelUtil.$$$reportNull$$$0(14);
        }
        Properties props = new Properties();
        props.setProperty("SHORT_CLASS_NAME", dtoPsiClass.getName());
        Properties properties = props;
        if (properties == null) {
            DtoMetaModelUtil.$$$reportNull$$$0(15);
        }
        return properties;
    }

    private static void addGeneratedSourcesDirToProjectStructureIfNeeded(Module finalTagetModule, PsiDirectory dtoMetaClassDir, PsiDirectory generatedSourcesPsiDir) {
        ModuleRootModificationUtil.modifyModel((Module)finalTagetModule, modifiableRootModel -> {
            Optional<SourceFolder> isAdded;
            ContentEntry generatedContentRoot = DtoMetaModelUtil.findContentEntry((ModuleRootModel)modifiableRootModel, dtoMetaClassDir.getVirtualFile());
            if (generatedContentRoot != null && (isAdded = Arrays.stream(generatedContentRoot.getSourceFolders()).filter(e -> e.getFile() != null && Objects.equals(e.getFile().getUrl(), dtoMetaClassDir.getVirtualFile().getUrl())).findFirst()).isEmpty()) {
                JavaSourceRootProperties sourceRootProperties = JpsJavaExtensionService.getInstance().createSourceRootProperties("");
                sourceRootProperties.setForGeneratedSources(true);
                generatedContentRoot.addSourceFolder(generatedSourcesPsiDir.getVirtualFile(), (JpsModuleSourceRootType)JavaSourceRootType.SOURCE, (JpsElement)sourceRootProperties);
                return true;
            }
            return false;
        });
    }

    @Nullable
    private static ContentEntry findContentEntry(@NotNull ModuleRootModel model, @NotNull VirtualFile vFile) {
        ContentEntry[] contentEntries;
        if (model == null) {
            DtoMetaModelUtil.$$$reportNull$$$0(16);
        }
        if (vFile == null) {
            DtoMetaModelUtil.$$$reportNull$$$0(17);
        }
        for (ContentEntry contentEntry : contentEntries = model.getContentEntries()) {
            VirtualFile contentEntryFile = contentEntry.getFile();
            if (contentEntryFile == null || !VfsUtilCore.isAncestor((VirtualFile)contentEntryFile, (VirtualFile)vFile, (boolean)false)) continue;
            return contentEntry;
        }
        return null;
    }

    private static PsiDirectory createPackageDirsIfNeeded(@NotNull PsiClass dtoPsiClass, @NotNull PsiDirectory parentPkgDir) {
        if (dtoPsiClass == null) {
            DtoMetaModelUtil.$$$reportNull$$$0(18);
        }
        if (parentPkgDir == null) {
            DtoMetaModelUtil.$$$reportNull$$$0(19);
        }
        String dtoFQN = dtoPsiClass.getQualifiedName();
        String[] split = dtoFQN.split("\\.");
        for (int i = 0; i < split.length - 1; ++i) {
            String pkg = split[i];
            PsiDirectory pkgDir = parentPkgDir.findSubdirectory(pkg);
            if (pkgDir == null) {
                pkgDir = parentPkgDir.createSubdirectory(pkg);
            }
            parentPkgDir = pkgDir;
        }
        return parentPkgDir;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 6, 7, 10, 11, 13, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dtoPsiClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaPsiFacade";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scp";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/cxbox/intellij/community/common/util/DtoMetaModelUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaModelField";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateName";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentPkgDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/cxbox/intellij/community/common/util/DtoMetaModelUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "syncDtoMetaModelClass";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrGenerateMetaModelClass";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "generateDtoMetaModelClass";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "findModule";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "syncDtoMetaModelClass";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 15: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDtoFromMetaModel";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getOrGenerateMetaModelClass";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "generateDtoMetaModelClass";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findModule";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getProperties";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findContentEntry";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createPackageDirsIfNeeded";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 6, 7, 10, 11, 13, 15 -> new IllegalStateException(string);
        };
    }
}

