/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.exception;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.ui.awt.RelativePoint;
import java.awt.MouseInfo;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00060\u0001j\u0002`\u0002B#\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nB/\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\n\u0010\u000b\u001a\u00060\fj\u0002`\r\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\u000eJ\u0006\u0010!\u001a\u00020\"J\u0010\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020%H\u0002R\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 \u00a8\u0006&"}, d2={"Lorg/cxbox/intellij/community/exception/PlatformValidationException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "text", "", "psiElement", "Lcom/intellij/psi/NavigatablePsiElement;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Ljava/lang/String;Lcom/intellij/psi/NavigatablePsiElement;Lcom/intellij/openapi/project/Project;)V", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "(Ljava/lang/String;Lcom/intellij/psi/NavigatablePsiElement;Ljava/lang/Exception;Lcom/intellij/openapi/project/Project;)V", "origException", "", "getOrigException", "()Ljava/lang/Throwable;", "setOrigException", "(Ljava/lang/Throwable;)V", "getText", "()Ljava/lang/String;", "setText", "(Ljava/lang/String;)V", "getPsiElement", "()Lcom/intellij/psi/NavigatablePsiElement;", "setPsiElement", "(Lcom/intellij/psi/NavigatablePsiElement;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "setProject", "(Lcom/intellij/openapi/project/Project;)V", "showPopupWithLinks", "", "showPopup", "popup", "Lcom/intellij/openapi/ui/popup/Balloon;", "cxbox-intellij-plugin"})
public final class PlatformValidationException
extends RuntimeException {
    @Nullable
    private Throwable origException;
    @NotNull
    private String text;
    @Nullable
    private NavigatablePsiElement psiElement;
    @NotNull
    private Project project;

    @Nullable
    public final Throwable getOrigException() {
        return this.origException;
    }

    public final void setOrigException(@Nullable Throwable throwable) {
        this.origException = throwable;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    public final void setText(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.text = string;
    }

    @Nullable
    public final NavigatablePsiElement getPsiElement() {
        return this.psiElement;
    }

    public final void setPsiElement(@Nullable NavigatablePsiElement navigatablePsiElement) {
        this.psiElement = navigatablePsiElement;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public final void setProject(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"<set-?>");
        this.project = project;
    }

    public PlatformValidationException(@NotNull String text, @Nullable NavigatablePsiElement psiElement, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.text = text;
        this.psiElement = psiElement;
        this.project = project;
    }

    public PlatformValidationException(@NotNull String text, @Nullable NavigatablePsiElement psiElement, @NotNull Exception e, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.text = text;
        this.psiElement = psiElement;
        this.origException = e;
        this.project = project;
    }

    public final void showPopupWithLinks() {
        if (!StringsKt.contains$default((CharSequence)this.text, (CharSequence)"href", (boolean)false, (int)2, null) && this.psiElement != null) {
            this.text = this.text + ". <a href=\"1\">See</a>";
        }
        Ref.ObjectRef stackTracePopup = new Ref.ObjectRef();
        if (this.origException != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            Throwable throwable = this.origException;
            Intrinsics.checkNotNull((Object)throwable);
            throwable.printStackTrace(pw);
            String string = sw.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String stackTraceString = string;
            StackTraceElement[] stackTraceElementArray = this.getStackTrace();
            Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
            if (!(((Object[])stackTraceElementArray).length == 0)) {
                this.text = StringsKt.trimIndent((String)(" \n                          " + this.text + "  <p>(<a href=\"stackTraceLink\">Open Stack Trace</a>)</p>"));
            }
            stackTracePopup.element = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(stackTraceString, MessageType.INFO, PlatformValidationException::showPopupWithLinks$lambda$0).setHideOnLinkClick(true).createBalloon();
        }
        Balloon balloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(this.text, MessageType.INFO, arg_0 -> PlatformValidationException.showPopupWithLinks$lambda$1(this, stackTracePopup, arg_0)).setHideOnLinkClick(true).createBalloon();
        Intrinsics.checkNotNullExpressionValue((Object)balloon, (String)"createBalloon(...)");
        Balloon popup = balloon;
        this.showPopup(popup);
    }

    private final void showPopup(Balloon popup) {
        if (MouseInfo.getPointerInfo().getLocation() != null) {
            popup.show(new RelativePoint(MouseInfo.getPointerInfo().getLocation()), Balloon.Position.atRight);
        }
        JFrame jFrame = WindowManager.getInstance().getFrame(this.project);
        popup.showInCenterOf((JComponent)(jFrame != null ? jFrame.getRootPane() : null));
    }

    private static final void showPopupWithLinks$lambda$0(HyperlinkEvent e) {
    }

    private static final void showPopupWithLinks$lambda$1(PlatformValidationException this$0, Ref.ObjectRef $stackTracePopup, HyperlinkEvent e) {
        block0: {
            block1: {
                if (!Intrinsics.areEqual((Object)e.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) break block0;
                if (!Intrinsics.areEqual((Object)e.getDescription(), (Object)"stackTraceLink")) break block1;
                Object object = $stackTracePopup.element;
                Intrinsics.checkNotNull((Object)object);
                this$0.showPopup((Balloon)object);
                break block0;
            }
            NavigatablePsiElement navigatablePsiElement = this$0.psiElement;
            if (navigatablePsiElement == null) break block0;
            navigatablePsiElement.navigate(true);
        }
    }
}

