/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.wigdet.options.actionGroups;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.Optional;
import org.cxbox.intellij.community.common.util.JavaFacade;
import org.cxbox.intellij.community.common.util.TextRangeUtil;
import org.cxbox.intellij.community.wigdet.options.actionGroups.action.ActionKeyReferenceContributor;
import org.cxbox.intellij.community.wigdet.options.actionGroups.action.ActionKeyReferenceProvider;
import org.cxbox.intellij.community.wigdet.options.actionGroups.action.generator.AddCustomOrStandardActionGenerator;
import org.cxbox.intellij.community.wigdet.options.actionGroups.actionGroup.ActionGroupKeyReferenceProvider;
import org.jetbrains.annotations.NotNull;

public final class ActionOrActionGroupInspection
extends LocalInspectionTool {
    @NotNull
    public String getShortName() {
        return "ActionOrActionGroupInspection";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            ActionOrActionGroupInspection.$$$reportNull$$$0(0);
        }
        final InspectionManager manager = holder.getManager();
        final Project project = holder.getProject();
        final Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)holder.getFile());
        if (module == null) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                ActionOrActionGroupInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        return new PsiElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (ActionKeyReferenceContributor.Holder.ACTION_FIELD_REF_PATTERN.accepts((Object)element)) {
                    if (!(element instanceof JsonStringLiteral)) {
                        return;
                    }
                    JsonStringLiteral actionLiteral = (JsonStringLiteral)element;
                    if (ActionOrActionGroupInspection.this.existsActionOrGroupJavaImplementation(actionLiteral, project, module)) {
                        return;
                    }
                    holder.registerProblem(manager.createProblemDescriptor(element.getParent(), TextRangeUtil.getTextRangeWithoutBrunch(element.getTextRangeInParent()), "Action/ActionGroup java implementation not found. If the action exists, download the sources and documentation of the project", ProblemHighlightType.WARNING, true, new LocalQuickFix[]{new Fix("Add an action", actionLiteral)}));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/cxbox/intellij/community/wigdet/options/actionGroups/ActionOrActionGroupInspection$1", "visitElement"));
            }
        };
    }

    private boolean existsActionOrGroupJavaImplementation(JsonStringLiteral element, Project project, Module module) {
        Optional first = (Optional)ActionKeyReferenceProvider.getLinkAndAutocompletionByActionName(element, project, module).getFirst();
        Optional second = (Optional)ActionGroupKeyReferenceProvider.getLinkAndAutocompletionByActionGroupName(element, project, module).getFirst();
        return !first.isEmpty() || !second.isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/cxbox/intellij/community/wigdet/options/actionGroups/ActionOrActionGroupInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/cxbox/intellij/community/wigdet/options/actionGroups/ActionOrActionGroupInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    record Fix(String msg, JsonStringLiteral lit) implements LocalQuickFix
    {
        public boolean availableInBatchMode() {
            return false;
        }

        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
            if (project == null) {
                Fix.$$$reportNull$$$0(0);
            }
            if (previewDescriptor == null) {
                Fix.$$$reportNull$$$0(1);
            }
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                Fix.$$$reportNull$$$0(2);
            }
            return intentionPreviewInfo;
        }

        @NotNull
        public String getName() {
            String string = this.msg;
            if (string == null) {
                Fix.$$$reportNull$$$0(3);
            }
            return string;
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            return "Add action";
        }

        public void applyFix(@NotNull Project prj, @NotNull ProblemDescriptor descriptor) {
            if (prj == null) {
                Fix.$$$reportNull$$$0(4);
            }
            if (descriptor == null) {
                Fix.$$$reportNull$$$0(5);
            }
            JavaFacade.withPrettyException(prj, null, () -> new AddCustomOrStandardActionGenerator(prj, this.lit).createAction());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "previewDescriptor";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/cxbox/intellij/community/wigdet/options/actionGroups/ActionOrActionGroupInspection$Fix";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prj";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/cxbox/intellij/community/wigdet/options/actionGroups/ActionOrActionGroupInspection$Fix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generatePreview";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "generatePreview";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

