/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.view.widgets.widgetname;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import java.util.List;
import java.util.Optional;
import org.cxbox.intellij.community.common.conf.JView;
import org.cxbox.intellij.community.common.conf.JWidget;
import org.cxbox.intellij.community.common.util.JsonFacade;
import org.cxbox.intellij.community.common.util.WidgetUtil;
import org.jetbrains.annotations.NotNull;

public final class ViewWidgetNameInspection
extends LocalInspectionTool {
    @NotNull
    public String getShortName() {
        return "ViewWidgetNameInspection";
    }

    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            ViewWidgetNameInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            ViewWidgetNameInspection.$$$reportNull$$$0(1);
        }
        if (!(file instanceof JsonFile)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        JsonFile viewFile = (JsonFile)file;
        if (!file.getName().endsWith("view.json")) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        Project project = file.getProject();
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)file);
        if (module == null) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        JsonArray viewFileWidgetsArray = JsonFacade.safeGetPropertyValueOfType(JsonFacade.getTopLevelObject(viewFile), JView.WIDGETS);
        List<JsonValue> viewFileWidgetsObjects = JsonFacade.getChildrenOfTypeAsList((PsiElement)viewFileWidgetsArray, JView.WIDGETS.arrayItemType());
        SmartList descriptors = new SmartList();
        viewFileWidgetsObjects.forEach(arg_0 -> ViewWidgetNameInspection.lambda$checkFile$0(project, module, (List)descriptors, manager, arg_0));
        return descriptors.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    private static /* synthetic */ void lambda$checkFile$0(Project project, Module module, List descriptors, InspectionManager manager, JsonObject viewWidgetObject) {
        JsonStringLiteral viewWidgetName = JsonFacade.safeGetPropertyValueOfType(viewWidgetObject, JView.WIDGETS_WIDGET_NAME);
        if (viewWidgetName == null) {
            return;
        }
        Optional link = (Optional)JWidget.getLinkAndAutocompletionByWidgetName(viewWidgetName.getValue(), project, module).getFirst();
        if (link.isEmpty()) {
            descriptors.add(manager.createProblemDescriptor((PsiElement)viewWidgetName, new TextRange(1, viewWidgetName.getValue().length() + 1), "Incorrect value. Use autocomplete to provide correct one", ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, true, new LocalQuickFix[]{new WidgetUtil.CreateWidgetFix()}));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
        }
        objectArray[1] = "org/cxbox/intellij/community/view/widgets/widgetname/ViewWidgetNameInspection";
        objectArray[2] = "checkFile";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

