/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.javaToMetaRefs.widgetName;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.search.GlobalSearchScope;
import org.cxbox.intellij.community.common.conf.JWidget;
import org.cxbox.intellij.community.common.util.QuickFixUtils;
import org.cxbox.intellij.community.javaToMetaRefs.widgetName.reference.JavaWidgetNameReferenceContributor;
import org.jetbrains.annotations.NotNull;

public final class WhenConfirmWithCustomWidgetThenTypeRestrictedInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final String VALID_WIDGET_FAMILY = "FormPopup";

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            WhenConfirmWithCustomWidgetThenTypeRestrictedInspection.$$$reportNull$$$0(0);
        }
        return new JavaElementVisitor(this){

            public void visitLiteralExpression(@NotNull PsiLiteralExpression element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitLiteralExpression(element);
                if (!JavaWidgetNameReferenceContributor.Holder.CONFIRM_WITH_CUSTOM_WIDGET_JAVA_WIDGET_NAME_REF_PATTERN.accepts((Object)element)) {
                    return;
                }
                String originalText = element.getText();
                String value = originalText.replace("\"", "");
                if (element == null) {
                    return;
                }
                Project project = element.getProject();
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
                if (module == null) {
                    return;
                }
                String type = JWidget.getWidgetType(JWidget.getWidgetByName(value, GlobalSearchScope.moduleScope((Module)module), project, module).orElse(null));
                if (type == null || !type.endsWith(WhenConfirmWithCustomWidgetThenTypeRestrictedInspection.VALID_WIDGET_FAMILY)) {
                    holder.registerProblem(holder.getManager().createProblemDescriptor((PsiElement)element, new TextRange(1, value.length() + 1), "The widget has type '" + type + "', that is not from expected type family 'FormPopup'. E.g. type.endsWith(typeFamily) != true", ProblemHighlightType.WARNING, true, new LocalQuickFix[]{new QuickFixUtils.ClearJavaPsiLiteralValueAndCallAutocompletionFix("Select value with autocompletionFormPopup", (PsiElement)element)}));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/cxbox/intellij/community/javaToMetaRefs/widgetName/WhenConfirmWithCustomWidgetThenTypeRestrictedInspection$1", "visitLiteralExpression"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/cxbox/intellij/community/javaToMetaRefs/widgetName/WhenConfirmWithCustomWidgetThenTypeRestrictedInspection", "buildVisitor"));
    }
}

