/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.java.searchParameter.reference;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiReference;
import java.util.Optional;
import java.util.stream.Stream;
import org.cxbox.intellij.community.common.util.QuickFixUtils;
import org.cxbox.intellij.community.java.searchParameter.reference.SearchParameterAnnotationReferenceContributor;
import org.cxbox.intellij.community.java.searchParameter.reference.SearchParameterAnnotationReferenceProvider;
import org.jetbrains.annotations.NotNull;

public class SearchParameterAnnotationCorrectEndingInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            SearchParameterAnnotationCorrectEndingInspection.$$$reportNull$$$0(0);
        }
        return new JavaElementVisitor(this){

            public void visitLiteralExpression(@NotNull PsiLiteralExpression element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitLiteralExpression(element);
                if (!SearchParameterAnnotationReferenceContributor.Holder.DTO_SEARCH_PARAM_NAME_ATTR_PATTERN.accepts((Object)element)) {
                    return;
                }
                String value = element.getText().replace("\"", "");
                if (value.isEmpty()) {
                    return;
                }
                Optional<PsiReference> hasCorrectEnding = Stream.of(element.getReferences()).filter(e -> {
                    SearchParameterAnnotationReferenceProvider.ReferenceLinkFromSearchParameter ref;
                    return e instanceof SearchParameterAnnotationReferenceProvider.ReferenceLinkFromSearchParameter && (ref = (SearchParameterAnnotationReferenceProvider.ReferenceLinkFromSearchParameter)((Object)e)).isCorrectEnding();
                }).findFirst();
                boolean hasCorrectPath = Stream.of(element.getReferences()).allMatch(e -> {
                    SearchParameterAnnotationReferenceProvider.ReferenceLinkFromSearchParameter ref;
                    return e instanceof SearchParameterAnnotationReferenceProvider.ReferenceLinkFromSearchParameter && (ref = (SearchParameterAnnotationReferenceProvider.ReferenceLinkFromSearchParameter)((Object)e)).isCorrectPathPart();
                });
                if (hasCorrectPath && hasCorrectEnding.isEmpty()) {
                    holder.registerProblem(holder.getManager().createProblemDescriptor((PsiElement)element, new TextRange(1, value.length() + 1), "Incorrect path end - it should be Hibernate Basic Type (e.g. field with explicit or implicit @Column). Use autocomplete to provide correct one", ProblemHighlightType.ERROR, true, new LocalQuickFix[]{new Fix("Select value with autocompletion", "\"" + value + ".\"", element.getTextRange().getEndOffset(), element.getContainingFile())}));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/cxbox/intellij/community/java/searchParameter/reference/SearchParameterAnnotationCorrectEndingInspection$1", "visitLiteralExpression"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/cxbox/intellij/community/java/searchParameter/reference/SearchParameterAnnotationCorrectEndingInspection", "buildVisitor"));
    }

    public record Fix(String msg, String newValue, int offSetForCaret, PsiFile file) implements LocalQuickFix
    {
        public boolean availableInBatchMode() {
            return false;
        }

        @NotNull
        public String getName() {
            String string = this.msg;
            if (string == null) {
                Fix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = this.msg;
            if (string == null) {
                Fix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                Fix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                Fix.$$$reportNull$$$0(3);
            }
            QuickFixUtils.changeJavaLiteralValueAndInvokeAutoCompleteIfPossible(project, descriptor.getPsiElement(), this.newValue, this.offSetForCaret, this.file);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/cxbox/intellij/community/java/searchParameter/reference/SearchParameterAnnotationCorrectEndingInspection$Fix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/cxbox/intellij/community/java/searchParameter/reference/SearchParameterAnnotationCorrectEndingInspection$Fix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

