/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.java.requiredArgsConstructor;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.cxbox.intellij.community.common.util.AnnotationUtil;
import org.cxbox.intellij.community.common.util.JavaUtil;
import org.cxbox.intellij.community.common.util.PsiClassUtil;
import org.cxbox.intellij.community.common.util.ResponseServiceUtils;
import org.cxbox.intellij.community.common.util.SearchScopeUtil;
import org.cxbox.intellij.community.exception.PlatformValidationException;
import org.cxbox.intellij.community.java.requiredArgsConstructor.RequiredArgsConstructorFieldsExistsConfig;
import org.cxbox.intellij.community.wigdet.fields.field.generator.common.TemplatesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RequiredArgsConstructorAvailableForMigrationInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final Integer ARGUMENTS_COUNT_IN_PARENT_CLASS_CONSTRUCTOR = 4;
    private static final Integer ARGUMENTS_FOR_CHECK_FOR_NULL = 2;
    private static final Integer META_INDEX_IN_SUPER_CONSTRUCTOR_FOR_ANY_SOURCE_VERSION_AWARE_RESPONSE_SERVICE = 2;
    private static final Integer META_INDEX_IN_SUPER_CONSTRUCTOR_FOR_VERSION_AWARE_RESPONSE_SERVICE = 3;
    private static final Integer DAO_INDEX_IN_SUPER_CONSTRUCTOR = 3;

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RequiredArgsConstructorAvailableForMigrationInspection.$$$reportNull$$$0(0);
        }
        return new JavaElementVisitor(this){

            public void visitClass(@NotNull PsiClass aClass) {
                PsiMethod constructorWithSuperWithNullThirdParam;
                if (aClass == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (RequiredArgsConstructorFieldsExistsConfig.VERSION_AWARE_RESPONSE_SERVICE_OR_ANY_SOURCE_VERSION_AWARE_RESPONSE_SERVICE.accepts((Object)aClass.getSuperClass()) && RequiredArgsConstructorAvailableForMigrationInspection.ancestorClassHasConstructorWithoutArgs(aClass) && (constructorWithSuperWithNullThirdParam = (PsiMethod)Arrays.stream(aClass.getConstructors()).filter(RequiredArgsConstructorAvailableForMigrationInspection::isConstructorWithSuperCallWithThirdParamIsNull).findFirst().orElse(null)) != null && RequiredArgsConstructorAvailableForMigrationInspection.constructorHasOnlyFieldsImplementedInConstructorFromArguments(constructorWithSuperWithNullThirdParam, aClass) && aClass.getNameIdentifier() != null) {
                    holder.registerProblem(holder.getManager().createProblemDescriptor((PsiElement)aClass, aClass.getNameIdentifier().getTextRangeInParent(), "Incorrect value. Use autocomplete to provide correct one", ProblemHighlightType.WEAK_WARNING, true, new LocalQuickFix[]{new Fix(constructorWithSuperWithNullThirdParam, aClass)}));
                }
                super.visitClass(aClass);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/cxbox/intellij/community/java/requiredArgsConstructor/RequiredArgsConstructorAvailableForMigrationInspection$1", "visitClass"));
            }
        };
    }

    private static boolean isConstructorWithSuperCallWithThirdParamIsNull(@NotNull PsiMethod constructorMethod) {
        if (constructorMethod == null) {
            RequiredArgsConstructorAvailableForMigrationInspection.$$$reportNull$$$0(1);
        }
        return Optional.of(constructorMethod).stream().filter(PsiMethod::isConstructor).map(method -> method.getBody()).filter(Objects::nonNull).map(PsiCodeBlock::getStatements).flatMap(Arrays::stream).anyMatch(RequiredArgsConstructorAvailableForMigrationInspection::isCallingLineConstructorWithSuperCallWithThirdParamIsNull);
    }

    private static boolean isCallingLineConstructorWithSuperCallWithThirdParamIsNull(@NotNull PsiStatement constructorStatement) {
        if (constructorStatement == null) {
            RequiredArgsConstructorAvailableForMigrationInspection.$$$reportNull$$$0(2);
        }
        return Optional.of(constructorStatement).stream().filter(statement -> statement instanceof PsiExpressionStatement).map(statement -> (PsiExpressionStatement)statement).filter(RequiredArgsConstructorAvailableForMigrationInspection::isConstructorFromResponseService).anyMatch(RequiredArgsConstructorAvailableForMigrationInspection::hasThirdArgumentIsNullIfClassInheritorOfVersionAwareResponseService);
    }

    private static boolean hasThirdArgumentIsNullIfClassInheritorOfVersionAwareResponseService(@NotNull PsiExpressionStatement constructorExpression) {
        PsiElement psiElement;
        if (constructorExpression == null) {
            RequiredArgsConstructorAvailableForMigrationInspection.$$$reportNull$$$0(3);
        }
        if ((psiElement = constructorExpression.getFirstChild()) instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression expression = (PsiMethodCallExpression)psiElement;
            if (ResponseServiceUtils.ANY_SOURCE_VERSION_AWARE_RESPONSE_SERVICE_PATTERN.accepts((Object)PsiTreeUtil.getParentOfType((PsiElement)constructorExpression, PsiClass.class))) {
                return true;
            }
            if (expression.getArgumentList().getExpressionCount() != ARGUMENTS_COUNT_IN_PARENT_CLASS_CONSTRUCTOR.intValue()) {
                return false;
            }
            PsiExpression thirdArg = expression.getArgumentList().getExpressions()[ARGUMENTS_FOR_CHECK_FOR_NULL];
            return thirdArg == null || "null".equals(thirdArg.getText());
        }
        return false;
    }

    private static boolean isConstructorFromResponseService(@NotNull PsiExpressionStatement constructorExpression) {
        PsiElement psiElement;
        if (constructorExpression == null) {
            RequiredArgsConstructorAvailableForMigrationInspection.$$$reportNull$$$0(4);
        }
        if ((psiElement = constructorExpression.getFirstChild()) instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression expression = (PsiMethodCallExpression)psiElement;
            return Optional.of(expression).stream().map(PsiElement::getFirstChild).filter(Objects::nonNull).map(PsiElement::getReference).filter(Objects::nonNull).map(PsiReference::resolve).map(element -> {
                PsiMethod method;
                return element instanceof PsiMethod ? (method = (PsiMethod)element) : null;
            }).filter(Objects::nonNull).filter(PsiMethod::isConstructor).map(method -> (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)method, PsiClass.class)).allMatch(arg_0 -> RequiredArgsConstructorFieldsExistsConfig.VERSION_AWARE_RESPONSE_SERVICE_OR_ANY_SOURCE_VERSION_AWARE_RESPONSE_SERVICE.accepts(arg_0));
        }
        return false;
    }

    private static boolean constructorHasOnlyFieldsImplementedInConstructorFromArguments(@NotNull PsiMethod constructor, @NotNull PsiClass aClass) {
        List<PsiStatement> statementWithoutCallingSuperConstructor;
        if (constructor == null) {
            RequiredArgsConstructorAvailableForMigrationInspection.$$$reportNull$$$0(5);
        }
        if (aClass == null) {
            RequiredArgsConstructorAvailableForMigrationInspection.$$$reportNull$$$0(6);
        }
        return (statementWithoutCallingSuperConstructor = Optional.ofNullable(constructor.getBody()).stream().map(PsiCodeBlock::getStatements).flatMap(Arrays::stream).filter(psiStatement -> !RequiredArgsConstructorAvailableForMigrationInspection.isCallingLineConstructorWithSuperCallWithThirdParamIsNull(psiStatement)).toList()).isEmpty() || statementWithoutCallingSuperConstructor.stream().allMatch(psiStatement -> RequiredArgsConstructorAvailableForMigrationInspection.isLeftPartExpressionWithThisFieldInClass(psiStatement, aClass) && RequiredArgsConstructorAvailableForMigrationInspection.isRightPartExpressionWithThisIsInConstrictorParameters(psiStatement, constructor));
    }

    private static boolean isLeftPartExpressionWithThisFieldInClass(@NotNull PsiStatement statement, @NotNull PsiClass aClass) {
        if (statement == null) {
            RequiredArgsConstructorAvailableForMigrationInspection.$$$reportNull$$$0(7);
        }
        if (aClass == null) {
            RequiredArgsConstructorAvailableForMigrationInspection.$$$reportNull$$$0(8);
        }
        return RequiredArgsConstructorAvailableForMigrationInspection.getPsiElementByReferenceFromLeftPartExpressionWithThisFieldInClass(statement).stream().map(element -> (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class)).filter(Objects::nonNull).map(PsiClass::getQualifiedName).filter(Objects::nonNull).anyMatch(clzFQN -> clzFQN.equals(aClass.getQualifiedName()));
    }

    private static Optional<PsiElement> getPsiElementByReferenceFromLeftPartExpressionWithThisFieldInClass(@NotNull PsiStatement statement) {
        if (statement == null) {
            RequiredArgsConstructorAvailableForMigrationInspection.$$$reportNull$$$0(9);
        }
        return Optional.of(statement).stream().map(PsiElement::getFirstChild).filter(Objects::nonNull).map(PsiElement::getFirstChild).filter(Objects::nonNull).map(PsiElement::getReference).filter(Objects::nonNull).map(PsiReference::resolve).filter(Objects::nonNull).findFirst();
    }

    private static boolean isRightPartExpressionWithThisIsInConstrictorParameters(@NotNull PsiStatement statement, @NotNull PsiMethod constructor) {
        if (statement == null) {
            RequiredArgsConstructorAvailableForMigrationInspection.$$$reportNull$$$0(10);
        }
        if (constructor == null) {
            RequiredArgsConstructorAvailableForMigrationInspection.$$$reportNull$$$0(11);
        }
        return Optional.of(statement).stream().map(PsiElement::getFirstChild).filter(Objects::nonNull).map(PsiElement::getLastChild).filter(Objects::nonNull).map(PsiElement::getReference).filter(Objects::nonNull).map(PsiReference::resolve).filter(Objects::nonNull).map(PsiElement::getParent).filter(Objects::nonNull).anyMatch(element -> element == constructor.getParameterList());
    }

    @Nullable
    private static PsiExpressionStatement getPsiExpressionStatementWithSuperConstructor(@NotNull PsiMethod constructor) {
        if (constructor == null) {
            RequiredArgsConstructorAvailableForMigrationInspection.$$$reportNull$$$0(12);
        }
        return Optional.ofNullable(constructor.getBody()).stream().map(PsiCodeBlock::getStatements).flatMap(Arrays::stream).map(statement -> {
            PsiExpressionStatement expression;
            return statement instanceof PsiExpressionStatement ? (expression = (PsiExpressionStatement)statement) : null;
        }).filter(Objects::nonNull).filter(RequiredArgsConstructorAvailableForMigrationInspection::hasThirdArgumentIsNullIfClassInheritorOfVersionAwareResponseService).findFirst().orElse(null);
    }

    private static Optional<PsiClass> getArgumentFromSuperConstructorByIndex(@NotNull PsiMethod constructor, int index) {
        List<PsiClass> classesFromArguments;
        if (constructor == null) {
            RequiredArgsConstructorAvailableForMigrationInspection.$$$reportNull$$$0(13);
        }
        if ((classesFromArguments = Optional.ofNullable(RequiredArgsConstructorAvailableForMigrationInspection.getPsiExpressionStatementWithSuperConstructor(constructor)).stream().map(psiStatement -> {
            PsiMethodCallExpression methodCallExpression;
            PsiElement patt0$temp = psiStatement.getFirstChild();
            return patt0$temp instanceof PsiMethodCallExpression ? (methodCallExpression = (PsiMethodCallExpression)patt0$temp) : null;
        }).filter(Objects::nonNull).map(methodCallExpression -> methodCallExpression.getArgumentList().getExpressions()).flatMap(Arrays::stream).map(element -> RequiredArgsConstructorAvailableForMigrationInspection.isNullOrExpressionWirhNull(element) ? null : element.getFirstChild()).map(element -> element != null ? element.getFirstChild() : null).map(element -> element != null ? element.getReference() : null).map(reference -> reference != null ? reference.resolve() : null).map(element -> {
            PsiClass clz;
            return element instanceof PsiClass ? (clz = (PsiClass)element) : null;
        }).toList()).size() > index) {
            return classesFromArguments.get(index) == null ? Optional.empty() : Optional.of(classesFromArguments.get(index));
        }
        return Optional.empty();
    }

    private static boolean isNullOrExpressionWirhNull(@Nullable PsiExpression expression) {
        return expression == null || "null".equals(expression.getText());
    }

    private static boolean ancestorClassHasConstructorWithoutArgs(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            RequiredArgsConstructorAvailableForMigrationInspection.$$$reportNull$$$0(14);
        }
        return Optional.ofNullable(psiClass.getSuperClass()).stream().filter(arg_0 -> RequiredArgsConstructorFieldsExistsConfig.VERSION_AWARE_RESPONSE_SERVICE_OR_ANY_SOURCE_VERSION_AWARE_RESPONSE_SERVICE.accepts(arg_0)).map(PsiClass::getConstructors).flatMap(Arrays::stream).anyMatch(constructor -> constructor.getParameterList().getParameters().length == 0);
    }

    private static Optional<PsiField> createNewField(@NotNull PsiElementFactory psiElementFactory, @NotNull PsiClass clz, @NotNull PsiMethod constructor, int indexInSuperConstructor, @NotNull String fieldName) {
        if (psiElementFactory == null) {
            RequiredArgsConstructorAvailableForMigrationInspection.$$$reportNull$$$0(15);
        }
        if (clz == null) {
            RequiredArgsConstructorAvailableForMigrationInspection.$$$reportNull$$$0(16);
        }
        if (constructor == null) {
            RequiredArgsConstructorAvailableForMigrationInspection.$$$reportNull$$$0(17);
        }
        if (fieldName == null) {
            RequiredArgsConstructorAvailableForMigrationInspection.$$$reportNull$$$0(18);
        }
        return RequiredArgsConstructorAvailableForMigrationInspection.getArgumentFromSuperConstructorByIndex(constructor, indexInSuperConstructor).stream().map(clzFromConstructor -> TemplatesKt.getShortFieldForResponseService(clzFromConstructor, fieldName)).map(text -> psiElementFactory.createFieldFromText(text, (PsiElement)clz)).findFirst();
    }

    private static boolean hasFieldOrGetterByName(@NotNull PsiClass clz, @NotNull PsiClass ancestorClass, @NotNull String fieldName) {
        if (clz == null) {
            RequiredArgsConstructorAvailableForMigrationInspection.$$$reportNull$$$0(19);
        }
        if (ancestorClass == null) {
            RequiredArgsConstructorAvailableForMigrationInspection.$$$reportNull$$$0(20);
        }
        if (fieldName == null) {
            RequiredArgsConstructorAvailableForMigrationInspection.$$$reportNull$$$0(21);
        }
        return JavaUtil.getPsiClassFromFieldOrGetter(clz, ancestorClass, fieldName) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructorMethod";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructorStatement";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructorExpression";
                break;
            }
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructor";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElementFactory";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clz";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestorClass";
                break;
            }
        }
        objectArray2[1] = "org/cxbox/intellij/community/java/requiredArgsConstructor/RequiredArgsConstructorAvailableForMigrationInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isConstructorWithSuperCallWithThirdParamIsNull";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isCallingLineConstructorWithSuperCallWithThirdParamIsNull";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "hasThirdArgumentIsNullIfClassInheritorOfVersionAwareResponseService";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isConstructorFromResponseService";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "constructorHasOnlyFieldsImplementedInConstructorFromArguments";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isLeftPartExpressionWithThisFieldInClass";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getPsiElementByReferenceFromLeftPartExpressionWithThisFieldInClass";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "isRightPartExpressionWithThisIsInConstrictorParameters";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "getPsiExpressionStatementWithSuperConstructor";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "getArgumentFromSuperConstructorByIndex";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "ancestorClassHasConstructorWithoutArgs";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "createNewField";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "hasFieldOrGetterByName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public record Fix(PsiMethod constructor, PsiClass clz) implements LocalQuickFix
    {
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                Fix.$$$reportNull$$$0(0);
            }
            if (descriptor == null) {
                Fix.$$$reportNull$$$0(1);
            }
            PsiElementFactory psiElementFactory = PsiElementFactory.getInstance((Project)project);
            try {
                PsiAnnotation annotationFromText;
                PsiElement addedAnnotation;
                if (!this.clz.hasAnnotation("lombok.RequiredArgsConstructor") && (addedAnnotation = AnnotationUtil.addAnnotation(project, this.clz, annotationFromText = PsiElementFactory.getInstance((Project)project).createAnnotationFromText("@RequiredArgsConstructor", (PsiElement)this.clz))) != null) {
                    PsiClassUtil.addImportByPsiClassFQN(project, "lombok.RequiredArgsConstructor", this.clz);
                }
                Optional.ofNullable(this.constructor.getBody()).stream().map(PsiCodeBlock::getStatements).flatMap(Arrays::stream).filter(psiStatement -> RequiredArgsConstructorAvailableForMigrationInspection.isLeftPartExpressionWithThisFieldInClass(psiStatement, this.clz) && RequiredArgsConstructorAvailableForMigrationInspection.isRightPartExpressionWithThisIsInConstrictorParameters(psiStatement, this.constructor)).map(RequiredArgsConstructorAvailableForMigrationInspection::getPsiElementByReferenceFromLeftPartExpressionWithThisFieldInClass).map(element -> {
                    PsiField field;
                    Object patt0$temp = element.orElse(null);
                    return patt0$temp instanceof PsiField ? (field = (PsiField)patt0$temp) : null;
                }).filter(Objects::nonNull).map(field -> {
                    PsiAnnotation annotation;
                    if (field.hasAnnotation("org.springframework.beans.factory.annotation.Autowired") && (annotation = field.getAnnotation("org.springframework.beans.factory.annotation.Autowired")) != null) {
                        annotation.delete();
                    }
                    return field;
                }).map(field -> {
                    if (!field.getModifierList().hasExplicitModifier("final")) {
                        field.getModifierList().setModifierProperty("final", true);
                    }
                    return field;
                }).forEach(field -> {
                    if (!field.getModifierList().hasExplicitModifier("private")) {
                        field.getModifierList().setModifierProperty("private", true);
                    }
                });
                AtomicBoolean isAddedField = new AtomicBoolean(false);
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.constructor.getContainingFile());
                if (module == null) {
                    return;
                }
                GlobalSearchScope scp = SearchScopeUtil.getModuleSearchScopeWithParentsAndChildsAndLibraries(module, project);
                if (RequiredArgsConstructorFieldsExistsConfig.ANY_SOURCE_VERSION_AWARE_RESPONSE_SERVICE_PATTERN.accepts((Object)this.clz.getSuperClass())) {
                    PsiClass ancestorClass = JavaUtil.getPsiClassByFqnPrefixWithoutPlatformRootPackage(project, scp, ".core.crudma.impl.AnySourceVersionAwareResponseService");
                    if (ancestorClass != null) {
                        if (!RequiredArgsConstructorAvailableForMigrationInspection.hasFieldOrGetterByName(this.clz, ancestorClass, "meta")) {
                            RequiredArgsConstructorAvailableForMigrationInspection.createNewField(psiElementFactory, this.clz, this.constructor, META_INDEX_IN_SUPER_CONSTRUCTOR_FOR_ANY_SOURCE_VERSION_AWARE_RESPONSE_SERVICE, "meta").ifPresent(meta -> {
                                PsiElement addedMeta = this.clz.add((PsiElement)meta);
                                CodeStyleManager.getInstance((Project)this.clz.getProject()).reformat(addedMeta);
                                isAddedField.set(true);
                            });
                        }
                        if (!RequiredArgsConstructorAvailableForMigrationInspection.hasFieldOrGetterByName(this.clz, ancestorClass, "dao")) {
                            RequiredArgsConstructorAvailableForMigrationInspection.createNewField(psiElementFactory, this.clz, this.constructor, DAO_INDEX_IN_SUPER_CONSTRUCTOR, "dao").ifPresent(dao -> {
                                PsiElement addedDao = this.clz.add((PsiElement)dao);
                                CodeStyleManager.getInstance((Project)this.clz.getProject()).reformat(addedDao);
                                isAddedField.set(true);
                            });
                        }
                    }
                } else {
                    PsiClass ancestorClass = JavaUtil.getPsiClassByFqnPrefixWithoutPlatformRootPackage(project, scp, ".core.crudma.impl.VersionAwareResponseService");
                    if (ancestorClass != null && !RequiredArgsConstructorAvailableForMigrationInspection.hasFieldOrGetterByName(this.clz, ancestorClass, "meta")) {
                        RequiredArgsConstructorAvailableForMigrationInspection.createNewField(psiElementFactory, this.clz, this.constructor, META_INDEX_IN_SUPER_CONSTRUCTOR_FOR_VERSION_AWARE_RESPONSE_SERVICE, "meta").ifPresent(meta -> {
                            PsiElement addedMeta = this.clz.add((PsiElement)meta);
                            CodeStyleManager.getInstance((Project)this.clz.getProject()).reformat(addedMeta);
                            isAddedField.set(true);
                        });
                    }
                }
                if (isAddedField.get()) {
                    if (RequiredArgsConstructorFieldsExistsConfig.ANY_SOURCE_VERSION_AWARE_RESPONSE_SERVICE_PATTERN.accepts((Object)this.clz.getSuperClass())) {
                        AnnotationUtil.addSuppressWarningsAnnotationWithNewValue(project, this.clz, RequiredArgsConstructorFieldsExistsConfig.ANNOTATION_JAVA_LANG_SUPPRESS_WARNINGS_ATTRIBUTE_VALUE_NEW_VALUE_LIST_FOR_ANY_SOURCE);
                    } else {
                        AnnotationUtil.addSuppressWarningsAnnotationWithNewValue(project, this.clz, RequiredArgsConstructorFieldsExistsConfig.ANNOTATION_JAVA_LANG_SUPPRESS_WARNINGS_ATTRIBUTE_VALUE_NEW_VALUE_LIST_FOR_VERSION_AWARE);
                    }
                    PsiClassUtil.addImportByPsiClassFQN(project, "lombok.Getter", this.clz);
                }
                this.constructor.delete();
            }
            catch (Exception e) {
                PlatformValidationException platformValidationException = new PlatformValidationException("Error updating the file", (NavigatablePsiElement)this.constructor, project);
                platformValidationException.showPopupWithLinks();
                throw platformValidationException;
            }
        }

        @IntentionName
        @NotNull
        public String getName() {
            String string = super.getName();
            if (string == null) {
                Fix.$$$reportNull$$$0(2);
            }
            return string;
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            return "Transfer the class to the new API. Using @RequiredArgsConstructor";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/cxbox/intellij/community/java/requiredArgsConstructor/RequiredArgsConstructorAvailableForMigrationInspection$Fix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/cxbox/intellij/community/java/requiredArgsConstructor/RequiredArgsConstructorAvailableForMigrationInspection$Fix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

