/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.injection;

import com.intellij.lang.Language;
import com.intellij.lang.injection.general.Injection;
import com.intellij.lang.injection.general.LanguageInjectionContributor;
import com.intellij.lang.injection.general.SimpleInjection;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiMethodPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.compiled.ClsMethodImpl;
import com.intellij.psi.util.PsiUtil;
import org.cxbox.intellij.community.common.Cache;
import org.cxbox.intellij.community.common.util.FieldMetaBuilderUtil;
import org.cxbox.intellij.community.common.util.JavaUtil;
import org.cxbox.intellij.community.common.util.PsiMethodPatternExt;
import org.cxbox.intellij.community.language.SimpleLanguage;
import org.jetbrains.annotations.NotNull;

public final class SimpleLangToPlatformActionGroupInjector
implements LanguageInjectionContributor {
    public static final String ACTION_PKG_WITHOUT_PLATFORM_PREFIX = ".core.service.action";
    @NotNull
    public static final ElementPattern<PsiLiteral> ACTION_GROUP_KEY_PATTERN = StandardPatterns.or((ElementPattern[])new ElementPattern[]{JavaUtil.PsiJavaElementPatternFacade.psiLiteralString().methodCallParameter(0, (ElementPattern)((PsiMethodPattern)PsiMethodPatternExt.psiMethod().withName("addGroup")).withParameterCount(4))});
    private static final Logger LOG = Logger.getInstance(SimpleLangToPlatformActionGroupInjector.class);

    public static boolean isActionGroupNamedElement(PsiElement context) {
        if (!(context instanceof PsiLiteralExpression)) {
            return false;
        }
        if (!(context.getContext() instanceof PsiExpressionList)) {
            return false;
        }
        PsiElement psiElement = context.getContext().getContext();
        if (!(psiElement instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression mCall = (PsiMethodCallExpression)psiElement;
        if (!ACTION_GROUP_KEY_PATTERN.accepts((Object)context)) {
            return false;
        }
        PsiMethod psiMethod = mCall.resolveMethod();
        if (psiMethod == null) {
            return false;
        }
        PsiClass targetClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)psiMethod.getReturnType());
        if (targetClass == null) {
            return false;
        }
        String returnTypeQN = targetClass.getQualifiedName();
        if (returnTypeQN == null || !returnTypeQN.startsWith(Cache.PLATFORM_1 + ACTION_PKG_WITHOUT_PLATFORM_PREFIX) && !returnTypeQN.startsWith("org.cxbox.core.service.action")) {
            return false;
        }
        Project project = context.getProject();
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)context);
        if (module == null) {
            return false;
        }
        PsiMethod actionBuilderAddGroupMethod = FieldMetaBuilderUtil.getActionBuilderAddGroupMethod(project, module);
        if (actionBuilderAddGroupMethod != null) {
            try {
                if (psiMethod instanceof ClsMethodImpl) {
                    ClsMethodImpl orig = (ClsMethodImpl)psiMethod;
                    PsiMethod decompiled = orig.getSourceMirrorMethod();
                    psiMethod = decompiled != null ? decompiled : psiMethod;
                }
            }
            catch (Exception e) {
                LOG.warn("Decompiling unavailale");
            }
            return psiMethod.equals((Object)actionBuilderAddGroupMethod);
        }
        return false;
    }

    public Injection getInjection(@NotNull PsiElement context) {
        if (context == null) {
            SimpleLangToPlatformActionGroupInjector.$$$reportNull$$$0(0);
        }
        if (SimpleLangToPlatformActionGroupInjector.isActionGroupNamedElement(context)) {
            return new SimpleInjection((Language)SimpleLanguage.INSTANCE, "", "", null);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/cxbox/intellij/community/injection/SimpleLangToPlatformActionGroupInjector", "getInjection"));
    }
}

