/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.common.util;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Arrays;
import java.util.Objects;
import org.cxbox.intellij.community.exception.PlatformValidationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiClassUtil {
    @Nullable
    public static PsiElement addImportByPsiClass(@NotNull Project project, @NotNull PsiClass importClass, @NotNull PsiClass classForAddingImports) {
        if (project == null) {
            PsiClassUtil.$$$reportNull$$$0(0);
        }
        if (importClass == null) {
            PsiClassUtil.$$$reportNull$$$0(1);
        }
        if (classForAddingImports == null) {
            PsiClassUtil.$$$reportNull$$$0(2);
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        PsiImportStatement importStatement = elementFactory.createImportStatement(importClass);
        PsiFile psiFile = classForAddingImports.getContainingFile();
        if (psiFile instanceof PsiJavaFile) {
            PsiJavaFile psiJavaFile = (PsiJavaFile)psiFile;
            PsiImportList importList = psiJavaFile.getImportList();
            if (importList != null) {
                if (importClass.getQualifiedName() != null) {
                    if (Arrays.stream(importList.getImportStatements()).map(PsiImportStatement::getQualifiedName).filter(Objects::nonNull).noneMatch(importClass.getQualifiedName()::equals)) {
                        return importList.add((PsiElement)importStatement);
                    }
                }
            } else {
                return psiJavaFile.addBefore((PsiElement)importStatement, (PsiElement)classForAddingImports);
            }
        }
        return null;
    }

    @Nullable
    public static PsiElement addImportByPsiClassFQN(@NotNull Project project, @NotNull String importClassFQN, @NotNull PsiClass classForAddingImports) {
        if (project == null) {
            PsiClassUtil.$$$reportNull$$$0(3);
        }
        if (importClassFQN == null) {
            PsiClassUtil.$$$reportNull$$$0(4);
        }
        if (classForAddingImports == null) {
            PsiClassUtil.$$$reportNull$$$0(5);
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        PsiClass importClass = JavaPsiFacade.getInstance((Project)project).findClass(importClassFQN, GlobalSearchScope.allScope((Project)project));
        if (importClass == null) {
            PlatformValidationException platformValidationException = new PlatformValidationException("The import class " + importClassFQN + " was not found.", (NavigatablePsiElement)classForAddingImports, project);
            platformValidationException.showPopupWithLinks();
            throw platformValidationException;
        }
        PsiImportStatement importStatement = elementFactory.createImportStatement(importClass);
        PsiFile psiFile = classForAddingImports.getContainingFile();
        if (psiFile instanceof PsiJavaFile) {
            PsiJavaFile psiJavaFile = (PsiJavaFile)psiFile;
            PsiImportList importList = psiJavaFile.getImportList();
            if (importList != null) {
                if (importClass.getQualifiedName() != null) {
                    if (Arrays.stream(importList.getImportStatements()).map(PsiImportStatement::getQualifiedName).filter(Objects::nonNull).noneMatch(importClass.getQualifiedName()::equals)) {
                        return importList.add((PsiElement)importStatement);
                    }
                }
            } else {
                return psiJavaFile.addBefore((PsiElement)importStatement, (PsiElement)classForAddingImports);
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importClass";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classForAddingImports";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importClassFQN";
                break;
            }
        }
        objectArray2[1] = "org/cxbox/intellij/community/common/util/PsiClassUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addImportByPsiClass";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addImportByPsiClassFQN";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

