/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.common.util;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.ConstantExpressionUtil;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.cxbox.intellij.community.injection.SimpleLangToPlatformActionInjector;
import org.cxbox.intellij.community.language.SimpleNamedElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaExpressionUtil {
    @Nullable
    public static PsiEnumConstant ifEnumNameCallThenEnumConst(@Nullable PsiExpression e) {
        PsiReferenceExpression expr;
        PsiExpression psiExpression;
        PsiMethodCallExpression call;
        if (e instanceof PsiMethodCallExpression && "name".equals((call = (PsiMethodCallExpression)e).getMethodExpression().getReferenceName()) && (psiExpression = call.getMethodExpression().getQualifierExpression()) instanceof PsiReferenceExpression && (psiExpression = (expr = (PsiReferenceExpression)psiExpression).resolve()) instanceof PsiEnumConstant) {
            PsiEnumConstant enumConst = (PsiEnumConstant)psiExpression;
            return enumConst;
        }
        return null;
    }

    @Nullable
    public static PsiExpressionList getCallArgumentList(@Nullable PsiElement psi) {
        PsiExpressionList psiExpressionList;
        PsiElement parent;
        PsiElement psiElement = parent = psi == null ? null : psi.getParent();
        if (parent instanceof PsiCallExpression) {
            PsiCallExpression psiCallExpression = (PsiCallExpression)parent;
            return psiCallExpression.getArgumentList();
        }
        if (parent instanceof PsiAnonymousClass) {
            PsiAnonymousClass psiAnonymousClass = (PsiAnonymousClass)parent;
            psiExpressionList = psiAnonymousClass.getArgumentList();
        } else {
            psiExpressionList = null;
        }
        return psiExpressionList;
    }

    @Nullable
    public static PsiExpression getArgumentByIndex(@NotNull PsiCallExpression callExpression, int index) {
        PsiExpressionList callArgumentList;
        if (callExpression == null) {
            JavaExpressionUtil.$$$reportNull$$$0(0);
        }
        if ((callArgumentList = JavaExpressionUtil.getCallArgumentList(callExpression)) != null && callArgumentList.getExpressions().length >= index) {
            return callArgumentList.getExpressions()[index];
        }
        return null;
    }

    @Nullable
    public static PsiExpressionList getCallArgumentList(@NotNull PsiCallExpression callExpression) {
        if (callExpression == null) {
            JavaExpressionUtil.$$$reportNull$$$0(1);
        }
        return callExpression.getArgumentList() == null ? null : callExpression.getArgumentList();
    }

    @Nullable
    public static PsiExpression getFirstCallArg(PsiExpressionList argList) {
        return argList.isEmpty() ? null : argList.getExpressions()[0];
    }

    @NotNull
    public static String computeSecondCallArgToString(PsiExpressionList argList, Project project) {
        String str;
        Object object;
        PsiClassType stringType = PsiType.getTypeByName((String)"java.lang.String", (Project)project, (GlobalSearchScope)GlobalSearchScope.EMPTY_SCOPE);
        return argList.getExpressions().length >= 2 && (object = ConstantExpressionUtil.computeCastTo((PsiExpression)argList.getExpressions()[1], (PsiType)stringType)) instanceof String ? (str = (String)object) : "";
    }

    public static Pair<Optional<? extends PsiElement>, List<Pair<String, LookupElement>>> getRefIfKeyIsString(@NotNull String value, @NotNull Project project, @NotNull Module module, List<Pair<PsiExpression, String>> args) {
        if (value == null) {
            JavaExpressionUtil.$$$reportNull$$$0(2);
        }
        if (project == null) {
            JavaExpressionUtil.$$$reportNull$$$0(3);
        }
        if (module == null) {
            JavaExpressionUtil.$$$reportNull$$$0(4);
        }
        List<Pair> refVars = args.stream().filter(e -> e.getFirst() instanceof PsiLiteralExpression).map(e -> new Pair((Object)((PsiLiteralExpression)e.getFirst()), (Object)((String)e.getSecond()))).toList();
        List<Pair> vars = refVars.stream().filter(e -> ((PsiLiteralExpression)e.getFirst()).getValue() instanceof String).map(e -> new Pair((Object)((String)((PsiLiteralExpression)e.getFirst()).getValue()), (Object)LookupElementBuilder.create((String)((String)((PsiLiteralExpression)e.getFirst()).getValue())).withTypeText((String)e.getSecond()).withIcon(AllIcons.Nodes.Method))).toList();
        Optional<SimpleNamedElement> ref = refVars.stream().filter(e -> Objects.equals(((PsiLiteralExpression)e.getFirst()).getValue(), value)).map(e -> SimpleLangToPlatformActionInjector.getInjectedNameIdentifierOwner(project, module, (PsiElement)e.getFirst())).filter(Objects::nonNull).findFirst();
        return new Pair(ref, vars);
    }

    public static Pair<Optional<? extends PsiElement>, List<Pair<String, LookupElement>>> getRefIfKeyIsEnumNameCall(@NotNull String value, List<Pair<PsiExpression, String>> args) {
        if (value == null) {
            JavaExpressionUtil.$$$reportNull$$$0(5);
        }
        List<Pair> refVars = args.stream().map(e -> new Pair((Object)JavaExpressionUtil.ifEnumNameCallThenEnumConst((PsiExpression)e.getFirst()), (Object)((String)e.getSecond()))).filter(e -> e.getFirst() != null).toList();
        List<Pair> vars = refVars.stream().map(e -> new Pair((Object)((PsiEnumConstant)e.getFirst()).getName(), (Object)LookupElementBuilder.create((String)((PsiEnumConstant)e.getFirst()).getName()).withTypeText((String)e.getSecond() + " (enum)").withIcon(AllIcons.Nodes.Method))).toList();
        Optional<PsiEnumConstant> enumConstant = refVars.stream().map(e -> (PsiEnumConstant)e.first).filter(e -> value.equals(e.getName())).findFirst();
        return new Pair(enumConstant, vars);
    }

    public static Pair<Optional<? extends PsiElement>, List<Pair<String, LookupElement>>> getRefIfKeyIsConstant(@NotNull String value, @NotNull Project project, List<Pair<PsiExpression, String>> argList) {
        if (value == null) {
            JavaExpressionUtil.$$$reportNull$$$0(6);
        }
        if (project == null) {
            JavaExpressionUtil.$$$reportNull$$$0(7);
        }
        PsiClassType stringType = PsiType.getTypeByName((String)"java.lang.String", (Project)project, (GlobalSearchScope)GlobalSearchScope.EMPTY_SCOPE);
        List<Pair> refVars = argList.stream().map(e -> {
            PsiElement psiElement;
            Object patt0$temp = e.getFirst();
            if (patt0$temp instanceof PsiReferenceExpression) {
                PsiReferenceExpression ref = (PsiReferenceExpression)patt0$temp;
                psiElement = ref.resolve();
            } else {
                psiElement = null;
            }
            return new Pair((Object)psiElement, (Object)((String)e.getSecond()));
        }).filter(e -> e.getFirst() instanceof PsiField).map(e -> new Pair((Object)((PsiField)e.getFirst()), (Object)((String)e.getSecond()))).toList();
        List<Pair> vars = refVars.stream().map(e -> {
            String str;
            Object patt0$temp = ConstantExpressionUtil.computeCastTo((PsiExpression)((PsiField)e.getFirst()).getInitializer(), (PsiType)stringType);
            return new Pair((Object)(patt0$temp instanceof String ? (str = (String)patt0$temp) : null), (Object)((String)e.getSecond()));
        }).filter(e -> e.getFirst() != null).map(e -> new Pair((Object)((String)e.getFirst()), (Object)LookupElementBuilder.create((String)((String)e.getFirst())).withTypeText((String)e.getSecond() + " (const)").withIcon(AllIcons.Nodes.Method))).toList();
        Optional<PsiElement> validReference = refVars.stream().map(e -> ((PsiField)e.getFirst()).getInitializer()).filter(e -> Objects.equals(ConstantExpressionUtil.computeCastTo((PsiExpression)e, (PsiType)stringType), value)).map(e -> e).findFirst();
        return new Pair(validReference, vars);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        objectArray2[1] = "org/cxbox/intellij/community/common/util/JavaExpressionUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getArgumentByIndex";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getCallArgumentList";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getRefIfKeyIsString";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getRefIfKeyIsEnumNameCall";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getRefIfKeyIsConstant";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

