/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.common.conf;

import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.cxbox.intellij.community.common.conf.JWidget;
import org.cxbox.intellij.community.common.conf.JsonTag;
import org.cxbox.intellij.community.common.util.Common;
import org.cxbox.intellij.community.common.util.JsonFacade;
import org.cxbox.intellij.community.common.util.SearchScopeUtil;
import org.cxbox.intellij.community.injection.SimpleLangToMetaFilesValueInjector;
import org.cxbox.intellij.community.language.SimpleNamedElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JScreen {
    public static final String NO_LEADING_DOT_SCREEN_JSON = "screen.json";
    public static final String SCREEN_JSON = ".screen.json";
    public static final JsonTag<JsonStringLiteral> NAME = new JsonTag<JsonStringLiteral>("name", JsonStringLiteral.class, null);
    public static final PsiElementPattern.Capture<JsonValue> SCREEN_NAME_REF_PATTERN = Common.createPropertyValuePattern(NAME.getName(), ".screen.json");
    public static final JsonTag<JsonStringLiteral> TYPE = new JsonTag<JsonStringLiteral>("type", JsonStringLiteral.class, null);
    public static final JsonTag<JsonStringLiteral> PRIMARY_VIEW_NAME = new JsonTag<JsonStringLiteral>("primaryViewName", JsonStringLiteral.class, null);
    public static final JsonTag<JsonStringLiteral> VIEW_NAME = new JsonTag<JsonStringLiteral>("viewName", JsonStringLiteral.class, null);
    public static final JsonTag<JsonStringLiteral> DEFAULT_VIEW_NAME = new JsonTag<JsonStringLiteral>("defaultView", JsonStringLiteral.class, null);
    public static final JsonTag<JsonArray> PRIMARY_VIEWS = new JsonTag<JsonArray>("primaryViews", JsonArray.class, JsonStringLiteral.class);
    public static final JsonTag<JsonArray> NAVIGATION_MENU = new JsonTag<JsonArray>("navigation.menu", JsonArray.class, JsonObject.class);
    public static final JsonTag<JsonObject> NAVIGATION = new JsonTag<JsonObject>("navigation", JsonObject.class, null);
    public static final JsonTag<JsonStringLiteral> HIDDEN = new JsonTag<JsonStringLiteral>("hidden", JsonStringLiteral.class, null);
    public static final JsonTag<JsonArray> MENU = new JsonTag<JsonArray>("menu", JsonArray.class, JsonObject.class);
    public static final JsonTag<JsonArray> CHILD = new JsonTag<JsonArray>("child", JsonArray.class, JsonObject.class);
    public static final JsonTag<JsonArray> NAVIGATION_MENU_ANY_DEPTH_CHILD = new JsonTag<JsonArray>("navigation.menu.*.child", JsonArray.class, JsonObject.class);

    public static String getName(@Nullable JsonFile file) {
        JsonObject topLevelObject = JsonFacade.getTopLevelObject(file);
        JsonStringLiteral type = JsonFacade.safeGetPropertyValueOfType(topLevelObject, NAME);
        return JsonFacade.safeGetValueAsString((PsiElement)type);
    }

    public static SimpleNamedElement getInjectedName(@Nullable JsonFile file) {
        if (file == null) {
            return null;
        }
        JsonObject widgetTopLevelObject = JsonFacade.getTopLevelObject(file);
        JsonStringLiteral name = JsonFacade.safeGetPropertyValueOfType(widgetTopLevelObject, NAME);
        Project project = file.getProject();
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)file);
        if (module == null) {
            return null;
        }
        return JScreen.getScreenFileInjectedName(project, module, name);
    }

    public static void setNameTagIfChanged(@NotNull JsonFile jsonFile, @NotNull String newValue) {
        if (jsonFile == null) {
            JScreen.$$$reportNull$$$0(0);
        }
        if (newValue == null) {
            JScreen.$$$reportNull$$$0(1);
        }
        String propName = NAME.getName();
        if (!JsonStringLiteral.class.isAssignableFrom(NAME.valueType())) {
            return;
        }
        JsonFacade.safeSetTopLevelPropertyIfChanged(jsonFile, propName, newValue);
    }

    @Nullable
    public static SimpleNamedElement getScreenFileInjectedName(@NotNull Project project, @NotNull Module module, @Nullable JsonStringLiteral nameInScreenFile) {
        if (project == null) {
            JScreen.$$$reportNull$$$0(2);
        }
        if (module == null) {
            JScreen.$$$reportNull$$$0(3);
        }
        return SimpleLangToMetaFilesValueInjector.getInjectedName(project, module, (JsonValue)nameInScreenFile);
    }

    public static List<ImmutablePair<JsonFile, PsiElement>> getAllScreensByViewName(@NotNull Project project, @NotNull Module module, @Nullable PsiElement viewFileInjectedName) {
        if (project == null) {
            JScreen.$$$reportNull$$$0(4);
        }
        if (module == null) {
            JScreen.$$$reportNull$$$0(5);
        }
        if (viewFileInjectedName == null) {
            return new ArrayList<ImmutablePair<JsonFile, PsiElement>>();
        }
        Collection<VirtualFile> allScreenFiles = JScreen.getAllScreens(module);
        GlobalSearchScope allScreenfilesWithLibrariesScope = GlobalSearchScope.filesWithoutLibrariesScope((Project)project, allScreenFiles);
        Query searchAllScreensReferencingViewFileInjectedName = ReferencesSearch.search((PsiElement)viewFileInjectedName, (SearchScope)allScreenfilesWithLibrariesScope, (boolean)true);
        return searchAllScreensReferencingViewFileInjectedName.findAll().stream().map(PsiReference::getElement).map(e -> new ImmutablePair((Object)((JsonFile)e.getContainingFile()), e)).collect(Collectors.toList());
    }

    public static Collection<VirtualFile> getAllScreens(@NotNull Module module) {
        if (module == null) {
            JScreen.$$$reportNull$$$0(6);
        }
        @NotNull Project project = module.getProject();
        CachedValuesManager valuesManager = CachedValuesManager.getManager((Project)project);
        return (Collection)valuesManager.getCachedValue((UserDataHolder)module, () -> new CachedValueProvider.Result(JScreen.getAllScreensNoCache(module), new Object[]{VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS, ProjectRootManager.getInstance((Project)module.getProject())}));
    }

    private static Collection<VirtualFile> getAllScreensNoCache(@NotNull Module module) {
        if (module == null) {
            JScreen.$$$reportNull$$$0(7);
        }
        @NotNull Project project = module.getProject();
        GlobalSearchScope scope = GlobalSearchScope.moduleScope((Module)module);
        return FilenameIndex.getAllFilesByExt((Project)project, (String)NO_LEADING_DOT_SCREEN_JSON, (GlobalSearchScope)scope);
    }

    public static Map<String, Map<Integer, JsonObject>> getScreenViews(@NotNull JsonFile screenFile) {
        Module module;
        if (screenFile == null) {
            JScreen.$$$reportNull$$$0(8);
        }
        if ((module = ModuleUtil.findModuleForPsiElement((PsiElement)screenFile)) == null) {
            return new HashMap<String, Map<Integer, JsonObject>>();
        }
        Map<String, Map<String, Map<Integer, JsonObject>>> allScreensViews = JScreen.getAllScreensViews(screenFile.getProject(), module);
        return allScreensViews.get(JScreen.getScreenName(screenFile));
    }

    @NotNull
    public static Map<String, Map<String, Map<Integer, JsonObject>>> getAllScreensViews(@NotNull Project project, @NotNull Module module) {
        if (project == null) {
            JScreen.$$$reportNull$$$0(9);
        }
        if (module == null) {
            JScreen.$$$reportNull$$$0(10);
        }
        CachedValuesManager valuesManager = CachedValuesManager.getManager((Project)project);
        Map map = (Map)valuesManager.getCachedValue((UserDataHolder)module, () -> new CachedValueProvider.Result(JScreen.getAllScreens(module).stream().map(vf -> {
            PsiFile file = PsiManager.getInstance((Project)module.getProject()).findFile(vf);
            return (JsonFile)file;
        }).filter(e -> e != null && JScreen.getScreenName(e) != null).collect(Collectors.toMap(JScreen::getScreenName, JScreen::getScreenViewsNoCache)), new Object[]{PsiModificationTracker.MODIFICATION_COUNT, ProjectRootManager.getInstance((Project)module.getProject())}));
        if (map == null) {
            JScreen.$$$reportNull$$$0(11);
        }
        return map;
    }

    public static String getScreenName(@NotNull JsonFile jsonFile) {
        if (jsonFile == null) {
            JScreen.$$$reportNull$$$0(12);
        }
        JsonStringLiteral jsonStringLiteral = JsonFacade.safeGetPropertyValueOfType(JsonFacade.getTopLevelObject(jsonFile), NAME);
        return JsonFacade.safeGetValueAsString((PsiElement)jsonStringLiteral);
    }

    @NotNull
    public static Optional<String> getTabsWidgetNameByLevel(@Nullable Integer level, @NotNull Project project, @NotNull Module module) {
        if (project == null) {
            JScreen.$$$reportNull$$$0(13);
        }
        if (module == null) {
            JScreen.$$$reportNull$$$0(14);
        }
        if (level != null) {
            Optional<String> optional = Optional.ofNullable(JScreen.getLevelToTabsWidgetName(project, module).get(level));
            if (optional == null) {
                JScreen.$$$reportNull$$$0(15);
            }
            return optional;
        }
        Optional<String> optional = Optional.empty();
        if (optional == null) {
            JScreen.$$$reportNull$$$0(16);
        }
        return optional;
    }

    @NotNull
    public static Map<Integer, String> getLevelToTabsWidgetName(@NotNull Project project, @NotNull Module module) {
        if (project == null) {
            JScreen.$$$reportNull$$$0(17);
        }
        if (module == null) {
            JScreen.$$$reportNull$$$0(18);
        }
        CachedValuesManager valuesManager = CachedValuesManager.getManager((Project)project);
        Map map = (Map)valuesManager.getCachedValue((UserDataHolder)module, () -> new CachedValueProvider.Result(JScreen.getLevelToTabsWidgetNameNoCache(module), new Object[]{PsiModificationTracker.MODIFICATION_COUNT, ProjectRootManager.getInstance((Project)module.getProject())}));
        if (map == null) {
            JScreen.$$$reportNull$$$0(19);
        }
        return map;
    }

    @NotNull
    private static Map<Integer, String> getLevelToTabsWidgetNameNoCache(@NotNull Module module) {
        if (module == null) {
            JScreen.$$$reportNull$$$0(20);
        }
        @NotNull Project project = module.getProject();
        GlobalSearchScope scp = SearchScopeUtil.getModuleSearchScopeWithParentsAndChildsAndLibraries(module, module.getProject());
        Optional<JsonFile> secondLevelMenu = JWidget.getWidgetByName("SecondLevelMenu", scp, project, module);
        Optional<JsonFile> thirdLevelMenu = JWidget.getWidgetByName("ThirdLevelMenu", scp, project, module);
        Optional<JsonFile> fourthLevelMenu = JWidget.getWidgetByName("FourthLevelMenu", scp, project, module);
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        secondLevelMenu.ifPresent(e -> result.put(2, e.getName()));
        thirdLevelMenu.ifPresent(e -> result.put(3, e.getName()));
        fourthLevelMenu.ifPresent(e -> result.put(4, e.getName()));
        HashMap<Integer, String> hashMap = result;
        if (hashMap == null) {
            JScreen.$$$reportNull$$$0(21);
        }
        return hashMap;
    }

    @NotNull
    private static Map<String, Map<Integer, JsonObject>> getScreenViewsNoCache(JsonFile containingFile) {
        JsonObject topLevelObject = JsonFacade.getTopLevelObject(containingFile);
        JsonObject navigation = JsonFacade.safeGetPropertyValueOfType(topLevelObject, "navigation", JsonObject.class);
        HashMap<String, Map<Integer, JsonObject>> viewsAndLevels = new HashMap<String, Map<Integer, JsonObject>>();
        JsonArray menu = JsonFacade.safeGetPropertyValueOfType(navigation, "menu", JsonArray.class);
        int START_LEVEL = 2;
        AtomicInteger level = new AtomicInteger(START_LEVEL);
        JScreen.visitViews(viewsAndLevels, menu, level);
        HashMap<String, Map<Integer, JsonObject>> hashMap = viewsAndLevels;
        if (hashMap == null) {
            JScreen.$$$reportNull$$$0(22);
        }
        return hashMap;
    }

    private static void visitViews(Map<String, Map<Integer, JsonObject>> viewsAndLevels, JsonArray viewGroup, AtomicInteger level) {
        List<JsonObject> valueList = JsonFacade.getChildrenOfTypeAsList((PsiElement)viewGroup, JsonObject.class);
        valueList.forEach(e -> {
            JsonArray nestedViewGroup;
            JsonStringLiteral viewName = JsonFacade.safeGetPropertyValueOfType(e, "viewName", JsonStringLiteral.class);
            String viewNameString = JsonFacade.safeGetValueAsString((PsiElement)viewName);
            if (viewName != null) {
                if (!viewsAndLevels.containsKey(viewNameString)) {
                    HashMap<Integer, JsonObject> objectObjectHashMap = new HashMap<Integer, JsonObject>();
                    objectObjectHashMap.put(level.get(), (JsonObject)e);
                    viewsAndLevels.put(viewNameString, objectObjectHashMap);
                } else {
                    Map integerJsonObjectMap = (Map)viewsAndLevels.get(viewNameString);
                    if (!integerJsonObjectMap.containsKey(level.get())) {
                        integerJsonObjectMap.put(level.get(), e);
                    }
                    viewsAndLevels.put(viewNameString, integerJsonObjectMap);
                }
            }
            if ((nestedViewGroup = JsonFacade.safeGetPropertyValueOfType(e, "child", JsonArray.class)) != null) {
                JScreen.visitViews(viewsAndLevels, nestedViewGroup, new AtomicInteger(level.get() + 1));
            }
        });
    }

    @NotNull
    public static Integer getScreenViewLevel(@NotNull PsiElement viewNamePsiElement) {
        if (viewNamePsiElement == null) {
            JScreen.$$$reportNull$$$0(23);
        }
        if (viewNamePsiElement instanceof JsonStringLiteral) {
            JsonStringLiteral liViewNamePsiElement = (JsonStringLiteral)viewNamePsiElement;
            JsonFile screenFile = (JsonFile)viewNamePsiElement.getContainingFile();
            String viewName = JsonFacade.safeGetValueAsString((PsiElement)liViewNamePsiElement);
            Map<String, Map<Integer, JsonObject>> screenViews = JScreen.getScreenViews(screenFile);
            Map<Integer, JsonObject> integerJsonObjectMap = screenViews.get(viewName);
            Optional<Integer> viewLevelOptional = integerJsonObjectMap.entrySet().stream().filter(entry -> {
                JsonStringLiteral viewNamePSI = JsonFacade.safeGetPropertyValueOfType((JsonObject)entry.getValue(), VIEW_NAME.getName(), JsonStringLiteral.class);
                return viewNamePsiElement.equals((Object)viewNamePSI);
            }).map(Map.Entry::getKey).findFirst();
            Integer n = viewLevelOptional.orElse(-1);
            if (n == null) {
                JScreen.$$$reportNull$$$0(24);
            }
            return n;
        }
        Integer n = -1;
        if (n == null) {
            JScreen.$$$reportNull$$$0(25);
        }
        return n;
    }

    @NotNull
    public static Pair<Optional<? extends PsiNamedElement>, List<String>> getLinkAndAutocompletionByViewName(@NotNull String value, @NotNull Project project, @NotNull Module module) {
        if (value == null) {
            JScreen.$$$reportNull$$$0(26);
        }
        if (project == null) {
            JScreen.$$$reportNull$$$0(27);
        }
        if (module == null) {
            JScreen.$$$reportNull$$$0(28);
        }
        List<PsiNamedElement> allInjectedScreenNames = JScreen.getAllInjectedScreenNames(project, module);
        Optional<PsiNamedElement> link = allInjectedScreenNames.stream().filter(e -> value.equals(e.getName())).findFirst();
        List autocomplete = allInjectedScreenNames.stream().map(PsiNamedElement::getName).collect(Collectors.toList());
        Pair pair = Pair.pair(link, autocomplete);
        if (pair == null) {
            JScreen.$$$reportNull$$$0(29);
        }
        return pair;
    }

    public static List<PsiNamedElement> getAllInjectedScreenNames(@NotNull Project project, @NotNull Module module) {
        if (project == null) {
            JScreen.$$$reportNull$$$0(30);
        }
        if (module == null) {
            JScreen.$$$reportNull$$$0(31);
        }
        CachedValuesManager valuesManager = CachedValuesManager.getManager((Project)project);
        return (List)valuesManager.getCachedValue((UserDataHolder)module, () -> new CachedValueProvider.Result(JScreen.getAllInjectedScreenNamesNoCache(module), new Object[]{PsiModificationTracker.MODIFICATION_COUNT, ProjectRootManager.getInstance((Project)module.getProject())}));
    }

    private static List<PsiNamedElement> getAllInjectedScreenNamesNoCache(@NotNull Module module) {
        if (module == null) {
            JScreen.$$$reportNull$$$0(32);
        }
        @NotNull Project project = module.getProject();
        GlobalSearchScope scp = SearchScopeUtil.getModuleSearchScopeWithParentsAndChildsAndLibraries(module, module.getProject());
        List<JsonFile> allViewFiles = JScreen.getAllScreenFiles(scp, project, module);
        return allViewFiles.stream().map(file -> {
            JsonObject topLevelObject = JsonFacade.getTopLevelObject(file);
            JsonStringLiteral name = JsonFacade.safeGetPropertyValueOfType(topLevelObject, NAME);
            return JScreen.getScreenFileInjectedName(project, module, name);
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @NotNull
    public static List<JsonFile> getAllScreenFiles(@NotNull GlobalSearchScope scp, @NotNull Project project, @NotNull Module module) {
        List<JsonFile> collect;
        if (scp == null) {
            JScreen.$$$reportNull$$$0(33);
        }
        if (project == null) {
            JScreen.$$$reportNull$$$0(34);
        }
        if (module == null) {
            JScreen.$$$reportNull$$$0(35);
        }
        List<JsonFile> list = collect = JScreen.getAllScreens(module).stream().map(vf -> PsiManager.getInstance((Project)project).findFile(vf)).map(JsonFile.class::cast).collect(Collectors.toList());
        if (list == null) {
            JScreen.$$$reportNull$$$0(36);
        }
        return list;
    }

    @Nullable
    public static JsonObject getScreenNavigation(@NotNull JsonFile jsonFile) {
        JsonObject topLevelObject;
        if (jsonFile == null) {
            JScreen.$$$reportNull$$$0(37);
        }
        if ((topLevelObject = JsonFacade.getTopLevelObject(jsonFile)) == null) {
            return null;
        }
        return JsonFacade.safeGetPropertyValueOfType(topLevelObject, NAVIGATION);
    }

    @NotNull
    public static List<JsonProperty> getViewNamePropertiesForScreen(@NotNull JsonFile screenJsonFile) {
        if (screenJsonFile == null) {
            JScreen.$$$reportNull$$$0(38);
        }
        List<JsonProperty> list = JScreen.getScreenViews(screenJsonFile).values().stream().map(Map::values).flatMap(Collection::stream).map(object -> JsonFacade.getChildrenOfTypeAsList((PsiElement)object, JsonProperty.class).stream().filter(property -> property.getName().equals(VIEW_NAME.getName())).toList()).flatMap(Collection::stream).toList();
        if (list == null) {
            JScreen.$$$reportNull$$$0(39);
        }
        return list;
    }

    @NotNull
    public static List<JsonProperty> getViewNamePropertiesForDefaultViewName(@NotNull PsiElement defaultViewNamePsiElement) {
        JsonObject defaultViewParent;
        if (defaultViewNamePsiElement == null) {
            JScreen.$$$reportNull$$$0(40);
        }
        if ((defaultViewParent = JsonFacade.getParentOfType(defaultViewNamePsiElement, JsonObject.class)) == null) {
            return new ArrayList<JsonProperty>();
        }
        return JScreen.getViewNamePropertiesFromDefaultViewNameObject((PsiElement)defaultViewParent);
    }

    @NotNull
    private static List<JsonProperty> getViewNamePropertiesFromDefaultViewNameObject(@NotNull PsiElement defaultViewNameJsonObject) {
        if (defaultViewNameJsonObject == null) {
            JScreen.$$$reportNull$$$0(41);
        }
        ArrayList<JsonProperty> result = new ArrayList<JsonProperty>();
        JsonFacade.getChildrenOfTypeAsList(defaultViewNameJsonObject, JsonProperty.class).stream().forEach(property -> {
            JsonValue patt0$temp;
            if (property.getName().equals(VIEW_NAME.getName())) {
                result.add((JsonProperty)property);
            } else if (property.getName().equals(CHILD.getName()) && (patt0$temp = property.getValue()) instanceof JsonArray) {
                JsonArray child = (JsonArray)patt0$temp;
                child.getValueList().stream().forEach(childElement -> {
                    if (childElement instanceof JsonObject) {
                        JsonObject childObject = (JsonObject)childElement;
                        result.addAll(JScreen.getViewNamePropertiesFromDefaultViewNameObject((PsiElement)childObject));
                    }
                });
            }
        });
        ArrayList<JsonProperty> arrayList = result;
        if (arrayList == null) {
            JScreen.$$$reportNull$$$0(42);
        }
        return arrayList;
    }

    @Nullable
    public static JsonProperty getViewNamePropertyForDefaultViewNameByName(@NotNull PsiElement defaultViewName, @NotNull String name) {
        if (defaultViewName == null) {
            JScreen.$$$reportNull$$$0(43);
        }
        if (name == null) {
            JScreen.$$$reportNull$$$0(44);
        }
        return JScreen.getViewNamePropertiesFromPropertiesByName(JScreen.getViewNamePropertiesForDefaultViewName(defaultViewName), name);
    }

    @Nullable
    public static JsonProperty getViewNamePropertyFromScreenByName(@NotNull JsonFile screenJsonFile, @NotNull String name) {
        if (screenJsonFile == null) {
            JScreen.$$$reportNull$$$0(45);
        }
        if (name == null) {
            JScreen.$$$reportNull$$$0(46);
        }
        return JScreen.getViewNamePropertiesFromPropertiesByName(JScreen.getViewNamePropertiesForScreen(screenJsonFile), name);
    }

    @Nullable
    private static JsonProperty getViewNamePropertiesFromPropertiesByName(@NotNull List<JsonProperty> properties, @NotNull String name) {
        if (properties == null) {
            JScreen.$$$reportNull$$$0(47);
        }
        if (name == null) {
            JScreen.$$$reportNull$$$0(48);
        }
        return properties.stream().filter(property -> {
            JsonValue patt0$temp = property.getValue();
            if (patt0$temp instanceof JsonStringLiteral) {
                JsonStringLiteral literal = (JsonStringLiteral)patt0$temp;
                return name.equals(JsonFacade.getValue(literal));
            }
            return false;
        }).findFirst().orElse(null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 15, 16, 19, 21, 22, 24, 25, 29, 36, 39, 42 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsonFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValue";
                break;
            }
            case 2: 
            case 4: 
            case 9: 
            case 13: 
            case 17: 
            case 27: 
            case 30: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 14: 
            case 18: 
            case 20: 
            case 28: 
            case 31: 
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "screenFile";
                break;
            }
            case 11: 
            case 15: 
            case 16: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 29: 
            case 36: 
            case 39: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/cxbox/intellij/community/common/conf/JScreen";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewNamePsiElement";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scp";
                break;
            }
            case 38: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "screenJsonFile";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultViewNamePsiElement";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultViewNameJsonObject";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultViewName";
                break;
            }
            case 44: 
            case 46: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/cxbox/intellij/community/common/conf/JScreen";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllScreensViews";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getTabsWidgetNameByLevel";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getLevelToTabsWidgetName";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getLevelToTabsWidgetNameNoCache";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getScreenViewsNoCache";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getScreenViewLevel";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getLinkAndAutocompletionByViewName";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllScreenFiles";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewNamePropertiesForScreen";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewNamePropertiesFromDefaultViewNameObject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setNameTagIfChanged";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getScreenFileInjectedName";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAllScreensByViewName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAllScreens";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAllScreensNoCache";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getScreenViews";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getAllScreensViews";
                break;
            }
            case 11: 
            case 15: 
            case 16: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 29: 
            case 36: 
            case 39: 
            case 42: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getScreenName";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getTabsWidgetNameByLevel";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getLevelToTabsWidgetName";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getLevelToTabsWidgetNameNoCache";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getScreenViewLevel";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getLinkAndAutocompletionByViewName";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getAllInjectedScreenNames";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getAllInjectedScreenNamesNoCache";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getAllScreenFiles";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getScreenNavigation";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getViewNamePropertiesForScreen";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getViewNamePropertiesForDefaultViewName";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getViewNamePropertiesFromDefaultViewNameObject";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getViewNamePropertyForDefaultViewNameByName";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getViewNamePropertyFromScreenByName";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getViewNamePropertiesFromPropertiesByName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 15, 16, 19, 21, 22, 24, 25, 29, 36, 39, 42 -> new IllegalStateException(string);
        };
    }
}

