/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.wigdet.name;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.RenameElementFix;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.util.SmartList;
import org.apache.commons.lang3.StringUtils;
import org.cxbox.intellij.community.common.conf.JWidget;
import org.cxbox.intellij.community.common.util.JsonFacade;
import org.cxbox.intellij.community.language.SimpleNamedElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WidgetNameContainsKeyWordsInspection
extends LocalInspectionTool {
    @NotNull
    public String getShortName() {
        return "WidgetNameContainsKeyWordsInspection";
    }

    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            WidgetNameContainsKeyWordsInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            WidgetNameContainsKeyWordsInspection.$$$reportNull$$$0(1);
        }
        if (!(file instanceof JsonFile)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        JsonFile widgetFile = (JsonFile)file;
        if (!file.getName().endsWith(".widget.json")) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        JsonObject widgetFileTopLevelObject = JsonFacade.getTopLevelObject(widgetFile);
        JsonStringLiteral widgetName = JsonFacade.safeGetPropertyValueOfType(widgetFileTopLevelObject, JWidget.NAME);
        SimpleNamedElement injectedWidgetName = JWidget.getWidgetFileInjectedName(widgetFile);
        SmartList descriptors = new SmartList();
        String widgetNameValue = JsonFacade.safeGetValueAsString((PsiElement)widgetName);
        if (StringUtils.containsAnyIgnoreCase((CharSequence)widgetNameValue, (CharSequence[])new CharSequence[]{"screen"})) {
            String widgetNameNoScreen = StringUtils.removeIgnoreCase((String)widgetNameValue, (String)"screen");
            String newWidgetName = StringUtils.removeIgnoreCase((String)widgetNameNoScreen, (String)".widget.json");
            descriptors.add(manager.createProblemDescriptor((PsiElement)widgetName, new TextRange(1, widgetNameValue.length() + 1), "Widget name should not contain keywords: 'screen'", ProblemHighlightType.GENERIC_ERROR, true, new LocalQuickFix[]{new Fix((PsiNamedElement)injectedWidgetName, newWidgetName, "(1) Rename widget")}));
        }
        return descriptors.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
        }
        objectArray[1] = "org/cxbox/intellij/community/wigdet/name/WidgetNameContainsKeyWordsInspection";
        objectArray[2] = "checkFile";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Fix
    extends RenameElementFix {
        private final String text;

        public Fix(PsiNamedElement widgetFile, @NotNull String newWidgetName, @Nullable String text) {
            if (newWidgetName == null) {
                Fix.$$$reportNull$$$0(0);
            }
            super(widgetFile, newWidgetName);
            this.text = text;
        }

        @NotNull
        public String getText() {
            String string = this.text != null ? this.text : CodeInsightBundle.message((String)"rename.file.fix", (Object[])new Object[0]);
            if (string == null) {
                Fix.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newWidgetName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/cxbox/intellij/community/wigdet/name/WidgetNameContainsKeyWordsInspection$Fix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/cxbox/intellij/community/wigdet/name/WidgetNameContainsKeyWordsInspection$Fix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

