/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.wigdet.fields.field.commonProps.label;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.SmartList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.cxbox.intellij.community.common.conf.JWidget;
import org.cxbox.intellij.community.common.util.QuickFixUtils;
import org.jetbrains.annotations.NotNull;

public final class FieldCorrectLabelOrTitleUsageInspection
extends LocalInspectionTool {
    @NotNull
    public String getShortName() {
        return "FieldCorrectLabelOrTitleUsageInspection";
    }

    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            FieldCorrectLabelOrTitleUsageInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            FieldCorrectLabelOrTitleUsageInspection.$$$reportNull$$$0(1);
        }
        if (!(file instanceof JsonFile)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        JsonFile jsonFile = (JsonFile)file;
        if (!file.getName().endsWith(".widget.json")) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        String widgetType = JWidget.getWidgetType(jsonFile);
        List<Triple<String, JsonObject, JsonArray>> widgetFields = JWidget.getWidgetFields(jsonFile);
        SmartList descriptors = new SmartList();
        widgetFields.forEach(arg_0 -> FieldCorrectLabelOrTitleUsageInspection.lambda$checkFile$0(widgetType, (List)descriptors, manager, arg_0));
        return descriptors.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    private static /* synthetic */ void lambda$checkFile$0(String widgetType, List descriptors, InspectionManager manager, Triple widgetField) {
        JsonProperty label;
        JsonObject fieldObject = (JsonObject)widgetField.getMiddle();
        if (widgetType != null) {
            JsonProperty title;
            if (JWidget.getFormLikeWidgetTypes().stream().anyMatch(widgetType::contains) && (title = JWidget.getFieldTitleProperty(fieldObject)) != null) {
                descriptors.add(manager.createProblemDescriptor((PsiElement)title, (TextRange)null, "Form and Info widget fields should use 'label' instead of 'title'", ProblemHighlightType.GENERIC_ERROR, true, new LocalQuickFix[]{new Fix(JWidget.LABEL.getName(), "rename title to label")}));
            }
        }
        if (StringUtils.containsAnyIgnoreCase((CharSequence)widgetType, (CharSequence[])new CharSequence[]{"List", "Table"}) && (label = JWidget.getFieldLabelProperty(fieldObject)) != null) {
            descriptors.add(manager.createProblemDescriptor((PsiElement)label, (TextRange)null, "List and Table widget fields should use 'title' instead of 'label'", ProblemHighlightType.GENERIC_ERROR, true, new LocalQuickFix[]{new Fix(JWidget.TITLE.getName(), "rename label to title")}));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
        }
        objectArray[1] = "org/cxbox/intellij/community/wigdet/fields/field/commonProps/label/FieldCorrectLabelOrTitleUsageInspection";
        objectArray[2] = "checkFile";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private record Fix(String newName, String name) implements LocalQuickFix
    {
        @NotNull
        public String getName() {
            String string = this.name;
            if (string == null) {
                Fix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            return "Use correct label/title field tag";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement psiElement;
            if (project == null) {
                Fix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                Fix.$$$reportNull$$$0(2);
            }
            if (!((psiElement = descriptor.getPsiElement()) instanceof JsonProperty)) {
                return;
            }
            JsonProperty displayNameProperty = (JsonProperty)psiElement;
            CodeStyleManager.getInstance((Project)project).performActionWithFormatterDisabled(() -> {
                displayNameProperty.setName(this.newName);
                QuickFixUtils.safeDoPostponedOperationsIfPossible(project, (PsiElement)displayNameProperty);
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/cxbox/intellij/community/wigdet/fields/field/commonProps/label/FieldCorrectLabelOrTitleUsageInspection$Fix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/cxbox/intellij/community/wigdet/fields/field/commonProps/label/FieldCorrectLabelOrTitleUsageInspection$Fix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

