/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.wigdet.bc.service.generator.versionaware;

import com.intellij.openapi.module.Module;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import org.cxbox.intellij.community.wigdet.bc.common.ResponseServiceType;
import org.cxbox.intellij.community.wigdet.bc.service.BcServiceGeneratorHolder;
import org.cxbox.intellij.community.wigdet.bc.service.generator.BcDialogCreationData;
import org.cxbox.intellij.community.wigdet.bc.service.generator.BcServiceGenerator;
import org.cxbox.intellij.community.wigdet.bc.service.generator.ElementGenerationContext;
import org.cxbox.intellij.community.wigdet.bc.service.generator.GenerationType;
import org.cxbox.intellij.community.wigdet.bc.service.generator.ServicePsiElementGenerator;
import org.cxbox.intellij.community.wigdet.bc.service.generator.common.EnumBcPsiElementGeneratorBc;
import org.cxbox.intellij.community.wigdet.bc.service.generator.versionaware.VersionAwareBcServiceGenerator;
import org.cxbox.intellij.community.wigdet.bc.service.generator.versionaware.VersionAwareDtoGeneratorBc;
import org.cxbox.intellij.community.wigdet.bc.service.generator.versionaware.VersionAwareEntityGeneratorBc;
import org.cxbox.intellij.community.wigdet.bc.service.generator.versionaware.VersionAwareMetaGeneratorBc;
import org.cxbox.intellij.community.wigdet.bc.service.generator.versionaware.VersionAwareParentRepositoryGeneratorBc;
import org.cxbox.intellij.community.wigdet.bc.service.generator.versionaware.VersionAwareRepositoryGeneratorBc;

public class VersionAwareElementsGenerator
extends BcServiceGenerator {
    @Override
    public boolean isApplicable(Module module, BcDialogCreationData data) {
        return ResponseServiceType.VERSION_AWARE_RESPONSE_SERVICE.equals(data.serviceType());
    }

    @Override
    public List<GenerationType<ElementGenerationContext>> elementsToGenerate() {
        return Arrays.stream(VersionAwareGenerationType.values()).map(type -> type).toList();
    }

    public static enum VersionAwareGenerationType implements GenerationType<ElementGenerationContext>
    {
        VERSION_AWARE_ENTITY(BcServiceGeneratorHolder.ElementType.ENTITY, VersionAwareEntityGeneratorBc::new),
        VERSION_AWARE_REPO(BcServiceGeneratorHolder.ElementType.REPO, VersionAwareRepositoryGeneratorBc::new),
        VERSION_AWARE_PARENT_REPO(BcServiceGeneratorHolder.ElementType.REPO, VersionAwareParentRepositoryGeneratorBc::new),
        VERSION_AWARE_DTO(BcServiceGeneratorHolder.ElementType.DTO, VersionAwareDtoGeneratorBc::new),
        VERSION_AWARE_META(BcServiceGeneratorHolder.ElementType.META, VersionAwareMetaGeneratorBc::new),
        VERSION_AWARE_SERVICE(BcServiceGeneratorHolder.ElementType.SERVICE, VersionAwareBcServiceGenerator::new),
        BC(BcServiceGeneratorHolder.ElementType.ENUM_BC, EnumBcPsiElementGeneratorBc::new);

        private final BcServiceGeneratorHolder.ElementType type;
        private final Supplier<ServicePsiElementGenerator<ElementGenerationContext>> factorySupplier;

        private VersionAwareGenerationType(BcServiceGeneratorHolder.ElementType type, Supplier<ServicePsiElementGenerator<ElementGenerationContext>> factorySupplier) {
            this.type = type;
            this.factorySupplier = factorySupplier;
        }

        @Override
        public BcServiceGeneratorHolder.ElementType type() {
            return this.type;
        }

        @Override
        public ServicePsiElementGenerator<ElementGenerationContext> factory() {
            return this.factorySupplier.get();
        }
    }
}

