/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.common.util;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.List;

public class PsiIndexSynchronizer {
    private PsiIndexSynchronizer() {
    }

    public static void synchronizeFile(Project project, List<VirtualFile> virtualFile) {
        ApplicationManager.getApplication().runWriteAction(() -> {
            PsiDocumentManager psiDocManager = PsiDocumentManager.getInstance((Project)project);
            psiDocManager.commitAllDocuments();
            FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
            PsiManager psiManager = PsiManager.getInstance((Project)project);
            virtualFile.forEach(vf -> {
                Document document;
                PsiFile psiFile = psiManager.findFile(vf);
                if (psiFile != null && (document = psiDocManager.getDocument(psiFile)) != null) {
                    psiDocManager.performForCommittedDocument(document, () -> {
                        vf.refresh(false, false);
                        fileBasedIndex.requestReindex(vf);
                        FileBasedIndex.getInstance().requestReindex(vf);
                    });
                }
            });
        });
    }
}

