/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.common.util;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.json.psi.JsonElement;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.util.StatusBarProgress;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.cxbox.intellij.community.common.conf.JWidget;
import org.cxbox.intellij.community.common.conf.SQLBcUtil;
import org.cxbox.intellij.community.common.util.EnumBcUtil;
import org.cxbox.intellij.community.common.util.FieldMetaBuilderUtil;
import org.cxbox.intellij.community.common.util.JavaUtil;
import org.cxbox.intellij.community.common.util.JsonFacade;
import org.cxbox.intellij.community.wigdet.options.actionGroups.action.StandardActionType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BcUtil {
    @NotNull
    public static List<PsiReference> getActionGroupRefs(@Nullable PsiClass bcEnumServiceClass) {
        if (bcEnumServiceClass == null) {
            return new ArrayList<PsiReference>();
        }
        List list = (List)CachedValuesManager.getCachedValue((PsiElement)bcEnumServiceClass, () -> new CachedValueProvider.Result(BcUtil.getActionGroupRefsNoCache(bcEnumServiceClass), new Object[]{bcEnumServiceClass, ProjectRootManager.getInstance((Project)bcEnumServiceClass.getProject())}));
        if (list == null) {
            BcUtil.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    private static List<PsiReference> getActionGroupRefsNoCache(@Nullable PsiClass bcEnumServiceClass) {
        ArrayList<PsiReference> refs = new ArrayList<PsiReference>();
        if (bcEnumServiceClass != null) {
            Project project = bcEnumServiceClass.getProject();
            Module module = ModuleUtil.findModuleForPsiElement((PsiElement)bcEnumServiceClass);
            if (module == null) {
                ArrayList<PsiReference> arrayList = refs;
                if (arrayList == null) {
                    BcUtil.$$$reportNull$$$0(1);
                }
                return arrayList;
            }
            PsiMethod actionBuilderAddGroupMethod = FieldMetaBuilderUtil.getActionBuilderAddGroupMethod(project, module);
            GlobalSearchScope serviceScope = GlobalSearchScope.fileScope((PsiFile)bcEnumServiceClass.getContainingFile());
            StatusBarProgress progressIndicator = new StatusBarProgress();
            progressIndicator.setText("Finding action group refs");
            refs.addAll(JavaUtil.findRefs(actionBuilderAddGroupMethod, serviceScope, progressIndicator));
        }
        ArrayList<PsiReference> arrayList = refs;
        if (arrayList == null) {
            BcUtil.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @NotNull
    public static List<PsiReference> getActionMethodsRefs(@Nullable PsiClass bcEnumServiceClass) {
        if (bcEnumServiceClass == null) {
            return new ArrayList<PsiReference>();
        }
        List list = (List)CachedValuesManager.getCachedValue((PsiElement)bcEnumServiceClass, () -> new CachedValueProvider.Result(BcUtil.getActionMethodsRefsNoCache(bcEnumServiceClass), new Object[]{bcEnumServiceClass, ProjectRootManager.getInstance((Project)bcEnumServiceClass.getProject())}));
        if (list == null) {
            BcUtil.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public static List<PsiReference> getActionBuilderStandardActionLambdaStyleRefs(@Nullable PsiClass bcEnumServiceClass, @NotNull StandardActionType standardActionType) {
        if (standardActionType == null) {
            BcUtil.$$$reportNull$$$0(4);
        }
        if (bcEnumServiceClass == null) {
            return new ArrayList<PsiReference>();
        }
        return BcUtil.getActionBuilderMethodByNameAndHavingUnaryOperatorArgRefsNoCache(bcEnumServiceClass, standardActionType.lambdaStyleMethodName);
    }

    @NotNull
    public static List<PsiReference> getActionBuilderStandardActionRefs(@Nullable PsiClass bcEnumServiceClass, @NotNull StandardActionType standardActionType) {
        if (standardActionType == null) {
            BcUtil.$$$reportNull$$$0(5);
        }
        if (bcEnumServiceClass == null) {
            return new ArrayList<PsiReference>();
        }
        return BcUtil.getActionBuilderMethodRefsByMethodNameNoCache(bcEnumServiceClass, standardActionType.oldStyleMethodName);
    }

    @NotNull
    private static List<PsiReference> getActionMethodsRefsNoCache(@Nullable PsiClass bcEnumServiceClass) {
        ArrayList<PsiReference> refs = new ArrayList<PsiReference>();
        if (bcEnumServiceClass != null) {
            Project project = bcEnumServiceClass.getProject();
            Module module = ModuleUtil.findModuleForPsiElement((PsiElement)bcEnumServiceClass);
            if (module == null) {
                ArrayList<PsiReference> arrayList = refs;
                if (arrayList == null) {
                    BcUtil.$$$reportNull$$$0(6);
                }
                return arrayList;
            }
            PsiMethod actionBuilderActionMethod = FieldMetaBuilderUtil.getActionBuilderActionMethod(project, module);
            PsiMethod actionBuilderAddMethod = FieldMetaBuilderUtil.getActionBuilderAddMethod(project, module);
            PsiMethod actionDescriptionBuilderActionMethod = FieldMetaBuilderUtil.getActionDescriptionBuilderActionMethod(project, module);
            PsiMethod actionDescriptionBuilderAddMethod = FieldMetaBuilderUtil.getActionDescriptionBuilderAddMethod(project, module);
            GlobalSearchScope serviceScope = GlobalSearchScope.fileScope((PsiFile)bcEnumServiceClass.getContainingFile());
            StatusBarProgress progressIndicator = new StatusBarProgress();
            progressIndicator.setText("Finding action group refs");
            refs.addAll(JavaUtil.findRefs(actionBuilderActionMethod, serviceScope, progressIndicator));
            refs.addAll(JavaUtil.findRefs(actionBuilderAddMethod, serviceScope, progressIndicator));
            refs.addAll(JavaUtil.findRefs(actionDescriptionBuilderActionMethod, serviceScope, progressIndicator));
            refs.addAll(JavaUtil.findRefs(actionDescriptionBuilderAddMethod, serviceScope, progressIndicator));
        }
        ArrayList<PsiReference> arrayList = refs;
        if (arrayList == null) {
            BcUtil.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @NotNull
    private static List<PsiReference> getActionBuilderMethodByNameAndHavingUnaryOperatorArgRefsNoCache(@Nullable PsiClass bcEnumServiceClass, @NotNull String methodName) {
        if (methodName == null) {
            BcUtil.$$$reportNull$$$0(8);
        }
        ArrayList<PsiReference> refs = new ArrayList<PsiReference>();
        if (bcEnumServiceClass != null) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)bcEnumServiceClass);
            if (module == null) {
                ArrayList<PsiReference> arrayList = refs;
                if (arrayList == null) {
                    BcUtil.$$$reportNull$$$0(9);
                }
                return arrayList;
            }
            PsiMethod actionBuilderMethod = FieldMetaBuilderUtil.getActionBuilderMethodByNameAndHavingUnaryOperatorArg(module, methodName);
            GlobalSearchScope serviceScope = GlobalSearchScope.fileScope((PsiFile)bcEnumServiceClass.getContainingFile());
            StatusBarProgress progressIndicator = new StatusBarProgress();
            progressIndicator.setText("Finding action group refs");
            refs.addAll(JavaUtil.findRefs(actionBuilderMethod, serviceScope, progressIndicator));
        }
        ArrayList<PsiReference> arrayList = refs;
        if (arrayList == null) {
            BcUtil.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    @NotNull
    private static List<PsiReference> getActionBuilderMethodRefsByMethodNameNoCache(@Nullable PsiClass bcEnumServiceClass, @NotNull String methodName) {
        if (methodName == null) {
            BcUtil.$$$reportNull$$$0(11);
        }
        ArrayList<PsiReference> refs = new ArrayList<PsiReference>();
        if (bcEnumServiceClass != null) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)bcEnumServiceClass);
            if (module == null) {
                ArrayList<PsiReference> arrayList = refs;
                if (arrayList == null) {
                    BcUtil.$$$reportNull$$$0(12);
                }
                return arrayList;
            }
            PsiMethod actionBuilderMethod = FieldMetaBuilderUtil.getActionBuilderMethodByName(module, methodName);
            GlobalSearchScope serviceScope = GlobalSearchScope.fileScope((PsiFile)bcEnumServiceClass.getContainingFile());
            StatusBarProgress progressIndicator = new StatusBarProgress();
            progressIndicator.setText("Finding action group refs");
            refs.addAll(JavaUtil.findRefs(actionBuilderMethod, serviceScope, progressIndicator));
        }
        ArrayList<PsiReference> arrayList = refs;
        if (arrayList == null) {
            BcUtil.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @NotNull
    public static Pair<Optional<PsiNamedElement>, List<Pair<String, ? extends LookupElement>>> getLinkAndAutocompletionByBc(@Nullable String bc, @NotNull Project project, @NotNull Module module) {
        if (project == null) {
            BcUtil.$$$reportNull$$$0(14);
        }
        if (module == null) {
            BcUtil.$$$reportNull$$$0(15);
        }
        PsiNamedElement link = (PsiNamedElement)ObjectUtils.firstNonNull((Object[])new PsiNamedElement[]{EnumBcUtil.getEnumBc(bc, project, module).orElse(null), SQLBcUtil.getSQLBc(bc, project, module).orElse(null)});
        Pair pair = Pair.pair(Optional.ofNullable(link), (Object)ListUtils.union(EnumBcUtil.getEnumBcAutocompletion(project, module), SQLBcUtil.getSQLBcAutocompletion(project, module)));
        if (pair == null) {
            BcUtil.$$$reportNull$$$0(16);
        }
        return pair;
    }

    @NotNull
    public static Pair<Optional<? extends PsiNamedElement>, List<Pair<String, ? extends LookupElement>>> getLinkAndAutocompletionByFieldNameAndBcName(@NotNull String fieldName, @Nullable String bc, @NotNull Project project, @NotNull Module module) {
        if (fieldName == null) {
            BcUtil.$$$reportNull$$$0(17);
        }
        if (project == null) {
            BcUtil.$$$reportNull$$$0(18);
        }
        if (module == null) {
            BcUtil.$$$reportNull$$$0(19);
        }
        Pair<Optional<? extends PsiNamedElement>, List<Pair<String, ? extends LookupElement>>> enumBcResult = EnumBcUtil.getLinkAndAutocompletionByFieldNameAndBcName(fieldName, bc, project, module);
        Pair<Optional<? extends PsiNamedElement>, List<Pair<String, ? extends LookupElement>>> sqlBcResult = SQLBcUtil.getLinkAndAutocompletionByFieldNameAndBcName(fieldName, bc, project, module);
        PsiNamedElement link = (PsiNamedElement)ObjectUtils.firstNonNull((Object[])new PsiNamedElement[]{((Optional)enumBcResult.getFirst()).orElse(null), ((Optional)sqlBcResult.getFirst()).orElse(null)});
        List autocomplete = ListUtils.union((List)((List)enumBcResult.getSecond()), (List)((List)sqlBcResult.getSecond()));
        return new Pair(Optional.ofNullable(link), (Object)autocomplete);
    }

    @Nullable
    public static JsonStringLiteral getNearestPopupBc(JsonStringLiteral element) {
        JsonObject topLevelObject = JsonFacade.getTopLevelObject((JsonFile)element.getContainingFile());
        JsonObject bcObject = (JsonObject)JsonFacade.findFirstParent((PsiElement)element, (Condition<? super PsiElement>)((Condition)e -> {
            if (e instanceof JsonObject) {
                JsonObject object = (JsonObject)e;
                JsonProperty bc = object.findProperty("popupBc");
                JsonProperty bcName = object.findProperty("popupBcName");
                return bc != null && bc.getValue() instanceof JsonStringLiteral || bcName != null && bcName.getValue() instanceof JsonStringLiteral;
            }
            return false;
        }));
        JsonStringLiteral parentBc = null;
        if (bcObject != null) {
            JsonProperty bc = bcObject.findProperty("popupBc");
            JsonProperty bcName = bcObject.findProperty("popupBcName");
            JsonValue parentBc1 = bc != null ? bc.getValue() : (bcName != null ? bcName.getValue() : null);
            parentBc = parentBc1 instanceof JsonStringLiteral ? (JsonStringLiteral)parentBc1 : null;
        }
        JsonStringLiteral widgetBc = JsonFacade.safeGetPropertyValueOfType(topLevelObject, JWidget.BC);
        return parentBc != null ? parentBc : widgetBc;
    }

    @Nullable
    public static JsonStringLiteral getNearestBc(JsonElement element) {
        JsonObject topLevelObject = JsonFacade.getTopLevelObject((JsonFile)element.getContainingFile());
        JsonObject bcObject = (JsonObject)JsonFacade.findFirstParent((PsiElement)element, (Condition<? super PsiElement>)((Condition)e -> {
            if (e instanceof JsonObject) {
                JsonObject object = (JsonObject)e;
                JsonProperty bc = object.findProperty("bc");
                JsonProperty bcName = object.findProperty("bcName");
                return bc != null && bc.getValue() instanceof JsonStringLiteral || bcName != null && bcName.getValue() instanceof JsonStringLiteral;
            }
            return false;
        }));
        JsonStringLiteral parentBc = null;
        if (bcObject != null) {
            JsonProperty bc = bcObject.findProperty("bc");
            JsonProperty bcName = bcObject.findProperty("bcName");
            parentBc = bc != null ? (JsonStringLiteral)bc.getValue() : (bcName != null ? (JsonStringLiteral)bcName.getValue() : null);
        }
        JsonStringLiteral widgetBc = JsonFacade.safeGetPropertyValueOfType(topLevelObject, JWidget.BC);
        return parentBc != null ? parentBc : widgetBc;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4, 5, 8, 11, 14, 15, 17, 18, 19 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/cxbox/intellij/community/common/util/BcUtil";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "standardActionType";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionGroupRefs";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionGroupRefsNoCache";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionMethodsRefs";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "org/cxbox/intellij/community/common/util/BcUtil";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionMethodsRefsNoCache";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionBuilderMethodByNameAndHavingUnaryOperatorArgRefsNoCache";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionBuilderMethodRefsByMethodNameNoCache";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getLinkAndAutocompletionByBc";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getActionBuilderStandardActionLambdaStyleRefs";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getActionBuilderStandardActionRefs";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getActionBuilderMethodByNameAndHavingUnaryOperatorArgRefsNoCache";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getActionBuilderMethodRefsByMethodNameNoCache";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getLinkAndAutocompletionByBc";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getLinkAndAutocompletionByFieldNameAndBcName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 4, 5, 8, 11, 14, 15, 17, 18, 19 -> new IllegalArgumentException(string);
        };
    }
}

