/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.wigdet.options.actionGroups.action;

import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.json.psi.JsonElement;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.compiled.ClsClassImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.cxbox.intellij.community.common.Cache;
import org.cxbox.intellij.community.common.util.BcUtil;
import org.cxbox.intellij.community.common.util.EnumBcUtil;
import org.cxbox.intellij.community.common.util.JavaExpressionUtil;
import org.cxbox.intellij.community.common.util.JavaFacade;
import org.cxbox.intellij.community.common.util.JsonFacade;
import org.cxbox.intellij.community.common.util.SearchScopeUtil;
import org.cxbox.intellij.community.wigdet.options.actionGroups.action.StandardActionType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionKeyReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public static Pair<Optional<? extends PsiElement>, List<Pair<String, LookupElement>>> getLinkAndAutocompletionByActionName(@NotNull JsonStringLiteral element, @NotNull Project project, @NotNull Module module) {
        if (element == null) {
            ActionKeyReferenceProvider.$$$reportNull$$$0(0);
        }
        if (project == null) {
            ActionKeyReferenceProvider.$$$reportNull$$$0(1);
        }
        if (module == null) {
            ActionKeyReferenceProvider.$$$reportNull$$$0(2);
        }
        JsonStringLiteral bcJsonStringLiteral = BcUtil.getNearestBc((JsonElement)element);
        String bc = JsonFacade.safeGetValueAsString((PsiElement)bcJsonStringLiteral);
        PsiEnumConstant bcPsiElement = (PsiEnumConstant)EnumBcUtil.getLinkAndAutocompletionByBc(bc, project, module).getFirst();
        PsiClass bcEnumServiceClass = EnumBcUtil.getBcServiceClass(bcPsiElement, project, module);
        List<PsiReference> actionMethodsRefs = BcUtil.getActionMethodsRefs(bcEnumServiceClass);
        List<PsiElement> actionMethods = actionMethodsRefs.stream().map(PsiReference::getElement).toList();
        List<PsiExpressionList> actionCallArgs = actionMethods.stream().map(JavaExpressionUtil::getCallArgumentList).filter(Objects::nonNull).toList();
        List<Pair<PsiExpression, String>> actionKeyExpressionsToActionName = actionCallArgs.stream().filter(e -> !e.isEmpty()).map(e -> new Pair((Object)JavaExpressionUtil.getFirstCallArg(e), (Object)JavaExpressionUtil.computeSecondCallArgToString(e, project))).toList();
        Pair<Optional<? extends PsiElement>, List<Pair<String, LookupElement>>> actionStringRef = JavaExpressionUtil.getRefIfKeyIsString(element.getValue(), project, module, actionKeyExpressionsToActionName);
        Pair<Optional<? extends PsiElement>, List<Pair<String, LookupElement>>> actionConstRef = JavaExpressionUtil.getRefIfKeyIsConstant(element.getValue(), project, actionKeyExpressionsToActionName);
        Pair<Optional<? extends PsiElement>, List<Pair<String, LookupElement>>> actionEnumConstRef = JavaExpressionUtil.getRefIfKeyIsEnumNameCall(element.getValue(), actionKeyExpressionsToActionName);
        Pair<Optional<? extends PsiElement>, List<Pair<String, LookupElement>>> actionStandardRef = ActionKeyReferenceProvider.getRefIfKeyIsStandardAction(element, project, module, bcEnumServiceClass);
        PsiElement ref = JavaFacade.firstNonNull(((Optional)actionStringRef.getFirst()).orElse(null), ((Optional)actionConstRef.getFirst()).orElse(null), ((Optional)actionEnumConstRef.getFirst()).orElse(null), ((Optional)actionStandardRef.getFirst()).orElse(null));
        List vars = Stream.of((List)actionStringRef.getSecond(), (List)actionConstRef.getSecond(), (List)actionEnumConstRef.getSecond(), (List)actionStandardRef.getSecond()).flatMap(Collection::stream).toList();
        return new Pair(Optional.ofNullable(ref), vars);
    }

    @NotNull
    private static Pair<Optional<? extends PsiElement>, List<Pair<String, LookupElement>>> getRefIfKeyIsStandardAction(@NotNull JsonStringLiteral element, @NotNull Project project, @NotNull Module module, PsiClass bcEnumServiceClass) {
        if (element == null) {
            ActionKeyReferenceProvider.$$$reportNull$$$0(3);
        }
        if (project == null) {
            ActionKeyReferenceProvider.$$$reportNull$$$0(4);
        }
        if (module == null) {
            ActionKeyReferenceProvider.$$$reportNull$$$0(5);
        }
        JavaPsiFacade instance = JavaPsiFacade.getInstance((Project)project);
        GlobalSearchScope scp = SearchScopeUtil.getModuleSearchScopeWithParentsAndChildsAndLibraries(module, module.getProject());
        PsiClass actionEnum = instance.findClass(Cache.getPlatformRootPackageWithoutDot(project, module) + ".core.dto.rowmeta.ActionType", scp);
        if (actionEnum instanceof ClsClassImpl) {
            ClsClassImpl compiledElement = (ClsClassImpl)actionEnum;
            PsiClass decompiled = compiledElement.getSourceMirrorClass();
            PsiClass psiClass = actionEnum = decompiled != null ? decompiled : actionEnum;
        }
        if (actionEnum != null) {
            List<PsiEnumConstant> enumConstants = Arrays.stream(actionEnum.getFields()).filter(PsiEnumConstant.class::isInstance).map(PsiEnumConstant.class::cast).toList();
            List<Pair> moreVariants = Arrays.stream(StandardActionType.values()).map(e -> e.key).map(e -> new Pair(e, (Object)PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)e).withIcon(PlatformIcons.ENUM_ICON).withTypeText("Standard action"), (double)-2.147483648E9))).toList();
            StandardActionType standardAction = StandardActionType.fromKey(element.getValue());
            if (standardAction != null && bcEnumServiceClass != null && ActionKeyReferenceProvider.existsStandardActionImplementation(bcEnumServiceClass, standardAction)) {
                String actionEnumName = Optional.of(standardAction).map(Enum::name).orElse(null);
                Optional<PsiEnumConstant> enumActionLinkCandidate = enumConstants.stream().filter(e -> Objects.equals(e.getName(), actionEnumName)).findFirst();
                return new Pair(enumActionLinkCandidate, moreVariants);
            }
            return new Pair(Optional.empty(), moreVariants);
        }
        return new Pair(Optional.empty(), new ArrayList());
    }

    private static boolean existsStandardActionImplementation(@NotNull PsiClass bcEnumServiceClass, @NotNull StandardActionType standardAction) {
        if (bcEnumServiceClass == null) {
            ActionKeyReferenceProvider.$$$reportNull$$$0(6);
        }
        if (standardAction == null) {
            ActionKeyReferenceProvider.$$$reportNull$$$0(7);
        }
        return !BcUtil.getActionBuilderStandardActionLambdaStyleRefs(bcEnumServiceClass, standardAction).isEmpty() || !BcUtil.getActionBuilderStandardActionRefs(bcEnumServiceClass, standardAction).isEmpty();
    }

    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            ActionKeyReferenceProvider.$$$reportNull$$$0(8);
        }
        if (context == null) {
            ActionKeyReferenceProvider.$$$reportNull$$$0(9);
        }
        if (!(element instanceof JsonStringLiteral)) {
            return PsiReference.EMPTY_ARRAY;
        }
        JsonStringLiteral liElement = (JsonStringLiteral)element;
        ArrayList<SoftReferenceLink> refs = new ArrayList<SoftReferenceLink>();
        String originalText = element.getText();
        String value = originalText.replaceAll("\"", "");
        Project project = element.getProject();
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        Pair<Optional<? extends PsiElement>, List<Pair<String, LookupElement>>> pair = ActionKeyReferenceProvider.getLinkAndAutocompletionByActionName(liElement, project, module);
        List<LookupElement> collect = ((List)pair.getSecond()).stream().map(e -> (LookupElement)e.getSecond()).toList();
        refs.add(new SoftReferenceLink(element, new TextRange(1, value.length() + 1), ((Optional)pair.getFirst()).orElse(null), collect));
        return refs.isEmpty() ? PsiReference.EMPTY_ARRAY : (PsiReference[])ContainerUtil.toArray(refs, PsiReference[]::new);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bcEnumServiceClass";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "standardAction";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "org/cxbox/intellij/community/wigdet/options/actionGroups/action/ActionKeyReferenceProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getLinkAndAutocompletionByActionName";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getRefIfKeyIsStandardAction";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "existsStandardActionImplementation";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getReferencesByElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class SoftReferenceLink
    extends PsiReferenceBase<PsiElement> {
        final PsiElement resolve;
        final List<LookupElement> variants;

        public SoftReferenceLink(@NotNull PsiElement element, @NotNull TextRange rangeInElement, @Nullable PsiElement resolve, @NotNull List<LookupElement> variants) {
            if (element == null) {
                SoftReferenceLink.$$$reportNull$$$0(0);
            }
            if (rangeInElement == null) {
                SoftReferenceLink.$$$reportNull$$$0(1);
            }
            if (variants == null) {
                SoftReferenceLink.$$$reportNull$$$0(2);
            }
            super(element, rangeInElement, true);
            this.resolve = resolve;
            this.variants = variants;
        }

        @Nullable
        public PsiElement resolve() {
            return this.resolve;
        }

        public Object[] getVariants() {
            return this.variants.toArray();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "rangeInElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "variants";
                    break;
                }
            }
            objectArray[1] = "org/cxbox/intellij/community/wigdet/options/actionGroups/action/ActionKeyReferenceProvider$SoftReferenceLink";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

