/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.common.util;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJvmMember;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.cxbox.intellij.community.common.Cache;
import org.cxbox.intellij.community.common.util.ModuleLibUtils;

public class MinPackageUtils {
    private static final Key<CachedValue<Integer>> BASE_ENTITY_KEY_CACHE = Key.create((String)"BASE_ENTITY_KEY_CACHE");
    private static final Key<CachedValue<Integer>> DTO_KEY_CACHE = Key.create((String)"DTO_KEY_CACHE");
    private static final Key<CachedValue<Integer>> VERSION_AWARE_CACHE = Key.create((String)"VERSION_AWARE_CACHE");
    private static final Key<CachedValue<Integer>> ANY_SOURCE_CACHE = Key.create((String)"ANY_SOURCE_CACHE");
    private static final Key<CachedValue<Integer>> PACKAGE_COUNT_CACHE = Key.create((String)"PACKAGE_COUNT_CACHE");

    public static String minCommonPackage(PsiClass baseClass, Set<PsiPackage> psiPackages, PsiElement psiElement, Predicate<PsiClass> predicate, boolean isFirstFound) {
        Project project = psiElement.getProject();
        CachedValuesManager manager = CachedValuesManager.getManager((Project)project);
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
        PsiClass baseEntityClass = Cache.getBaseEntityClass(project, module);
        PsiClass dataResponseDTOClass = Cache.getDataResponseDTOClass(project, module);
        PsiClass anySourceServiceClass = Cache.getAnySourceServiceClass(project, module);
        PsiClass awareServiceClass = Cache.getVersionAwareServiceClass(project, module);
        Key<CachedValue<Integer>> key = PACKAGE_COUNT_CACHE;
        if (baseClass.isEquivalentTo((PsiElement)baseEntityClass)) {
            key = BASE_ENTITY_KEY_CACHE;
        } else if (baseClass.isEquivalentTo((PsiElement)dataResponseDTOClass)) {
            key = DTO_KEY_CACHE;
        } else if (baseClass.isEquivalentTo((PsiElement)awareServiceClass)) {
            key = VERSION_AWARE_CACHE;
        } else if (baseClass.isEquivalentTo((PsiElement)anySourceServiceClass)) {
            key = ANY_SOURCE_CACHE;
        }
        return MinPackageUtils.minCommonPackageWithoutCache(psiPackages, psiElement, predicate, manager, key, isFirstFound);
    }

    private static String minCommonPackageWithoutCache(Set<PsiPackage> psiPackages, PsiElement psiElement, Predicate<PsiClass> predicate, CachedValuesManager manager, Key<CachedValue<Integer>> key, boolean isFirstFound) {
        JavaPsiFacade jpf = JavaPsiFacade.getInstance((Project)psiElement.getProject());
        Project project = jpf.getProject();
        GlobalSearchScope allScope = GlobalSearchScope.projectScope((Project)project);
        Set<PsiPackage> mainPackages = MinPackageUtils.cacheMainPackages(project, jpf, allScope);
        HashMap<PsiPackage, Integer> packageCountMap = new HashMap<PsiPackage, Integer>();
        HashMap<PsiPackage, Integer> maxCounts = new HashMap<PsiPackage, Integer>();
        Iterator<PsiPackage> iterator = psiPackages.iterator();
        block0: while (iterator.hasNext()) {
            PsiPackage pkg;
            for (PsiPackage current = pkg = iterator.next(); current != null && !mainPackages.contains(current); current = current.getParentPackage()) {
                int count = MinPackageUtils.getCachedPackageClassCount(current, packageCountMap, predicate, manager, mainPackages, key);
                maxCounts.putIfAbsent(current, count);
                if (count > 0 && isFirstFound) continue block0;
            }
        }
        int maxCount = maxCounts.values().stream().mapToInt(Integer::intValue).max().orElse(0);
        return maxCounts.entrySet().stream().filter(e -> ((Integer)e.getValue()).equals(maxCount)).map(Map.Entry::getKey).max(Comparator.comparingInt(p -> p.getQualifiedName().split("\\.").length)).map(PsiPackage::getQualifiedName).orElse(null);
    }

    private static int getCachedPackageClassCount(final PsiPackage psiPackage, final Map<PsiPackage, Integer> packageCountMap, final Predicate<PsiClass> predicate, final CachedValuesManager manager, final Set<PsiPackage> mainPackages, final Key<CachedValue<Integer>> key) {
        if (packageCountMap.containsKey(psiPackage)) {
            return packageCountMap.get(psiPackage);
        }
        Integer cachedCount = (Integer)manager.getCachedValue((UserDataHolder)psiPackage, key, (CachedValueProvider)new CachedValueProvider<Integer>(){

            public CachedValueProvider.Result<Integer> compute() {
                int count = MinPackageUtils.countSubPackageClassesInternal(psiPackage, packageCountMap, predicate, mainPackages, manager, (Key<CachedValue<Integer>>)key);
                return CachedValueProvider.Result.create((Object)count, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }
        }, false);
        packageCountMap.put(psiPackage, cachedCount);
        return cachedCount;
    }

    private static int countSubPackageClassesInternal(PsiPackage psiPackage, Map<PsiPackage, Integer> packageCountMap, Predicate<PsiClass> predicate, Set<PsiPackage> mainPackages, CachedValuesManager manager, Key<CachedValue<Integer>> key) {
        if (packageCountMap.containsKey(psiPackage)) {
            return packageCountMap.get(psiPackage);
        }
        if (mainPackages.contains(psiPackage)) {
            packageCountMap.put(psiPackage, 0);
            return 0;
        }
        int count = MinPackageUtils.countDirectClasses(psiPackage, predicate);
        for (PsiPackage subPackage : psiPackage.getSubPackages()) {
            count += MinPackageUtils.getCachedPackageClassCount(subPackage, packageCountMap, predicate, manager, mainPackages, key);
        }
        packageCountMap.put(psiPackage, count);
        return count;
    }

    private static int countDirectClasses(PsiPackage psiPackage, Predicate<PsiClass> predicate) {
        PsiDirectory[] directories;
        int count = 0;
        for (PsiDirectory directory : directories = psiPackage.getDirectories()) {
            for (PsiFile file : directory.getFiles()) {
                if (!(file instanceof PsiJavaFile)) continue;
                PsiJavaFile javaFile = (PsiJavaFile)file;
                for (PsiClass psiClass : javaFile.getClasses()) {
                    if (!predicate.test(psiClass)) continue;
                    ++count;
                }
            }
        }
        return count;
    }

    private static Set<PsiPackage> cacheMainPackages(Project project, JavaPsiFacade jpf, GlobalSearchScope allScope) {
        Set<PsiPackage> mainPackages = Arrays.stream(PsiShortNamesCache.getInstance((Project)project).getMethodsByName("main", allScope)).filter(m -> m.getContainingClass() != null && ModuleLibUtils.isFromProjectSources(m.getContainingClass())).map(PsiJvmMember::getContainingClass).filter(Objects::nonNull).map(c -> (PsiJavaFile)c.getContainingFile()).map(PsiJavaFile::getPackageName).map(arg_0 -> ((JavaPsiFacade)jpf).findPackage(arg_0)).filter(Objects::nonNull).collect(Collectors.toSet());
        return mainPackages;
    }
}

