/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.common.util;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.openapi.compiler.CompilationStatusListener;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompileStatusNotification;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerTopics;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CompileUtils {
    public static final CompileStatusNotification SIMPLE_LOG_CALLBACK = (aborted, errors, warnings, context) -> {
        if (aborted) {
            ((CompilationStatusListener)context.getProject().getMessageBus().syncPublisher(CompilerTopics.COMPILATION_STATUS)).automakeCompilationFinished(errors, warnings, context);
        }
    };

    private CompileUtils() {
    }

    public static void runCompile(@NotNull Project project, @NotNull VirtualFile[] files, @Nullable CompileStatusNotification callback) {
        if (project == null) {
            CompileUtils.$$$reportNull$$$0(0);
        }
        if (files == null) {
            CompileUtils.$$$reportNull$$$0(1);
        }
        CompilerManager.getInstance((Project)project).compile(files, callback);
    }

    public static void runCompileWithForcedAnnotationProcessing(@NotNull Project project, @NotNull VirtualFile[] files, @Nullable CompileStatusNotification callback) {
        if (project == null) {
            CompileUtils.$$$reportNull$$$0(2);
        }
        if (files == null) {
            CompileUtils.$$$reportNull$$$0(3);
        }
        CompilerManager compilerManager = CompilerManager.getInstance((Project)project);
        for (VirtualFile file : files) {
            Module moduleForFile = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
            if (moduleForFile != null && CompileUtils.isAnnotationProcessingEnabled(moduleForFile)) {
                CompileScope scope = compilerManager.createFilesCompileScope(new VirtualFile[]{file});
                compilerManager.make(scope, (aborted, errors, warnings, compileContext) -> {
                    if (callback != null) {
                        callback.finished(aborted, errors, warnings, compileContext);
                    }
                });
                continue;
            }
            compilerManager.compile(new VirtualFile[]{file}, callback);
        }
    }

    private static boolean isAnnotationProcessingEnabled(Module module) {
        return CompilerConfiguration.getInstance((Project)module.getProject()).getAnnotationProcessingConfiguration(module).isEnabled();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        objectArray2[1] = "org/cxbox/intellij/community/common/util/CompileUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "runCompile";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "runCompileWithForcedAnnotationProcessing";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

